/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNumberTsonElement;

public class TsonFloatImpl
extends AbstractNumberTsonElement
implements TsonFloat {
    private float value;

    public TsonFloatImpl(float value, String unit) {
        super(TsonElementType.FLOAT, TsonNumberLayout.DECIMAL, unit);
        this.value = value;
    }

    @Override
    public Number numberValue() {
        return Float.valueOf(this.value());
    }

    @Override
    public TsonFloat toFloat() {
        return this;
    }

    @Override
    public float value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonFloatImpl tsonFloat = (TsonFloatImpl)o;
        return Float.compare(tsonFloat.value, this.value) == 0;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), Float.valueOf(this.value));
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    public TsonByte toByte() {
        return Tson.of((byte)this.value()).toByte();
    }

    @Override
    public TsonShort toShort() {
        return Tson.of((short)this.value()).toShort();
    }

    @Override
    public TsonInt toInt() {
        return Tson.of((int)this.value()).toInt();
    }

    @Override
    public TsonLong toLong() {
        return Tson.of((long)this.value()).toLong();
    }

    @Override
    public TsonDouble toDouble() {
        return Tson.of((double)this.value()).toDouble();
    }

    @Override
    public Byte byteObject() {
        return (byte)this.value();
    }

    @Override
    public Long longObject() {
        return (long)this.value();
    }

    @Override
    public Integer intObject() {
        return (int)this.value();
    }

    @Override
    public Short shortObject() {
        return (short)this.value();
    }

    @Override
    public Float floatObject() {
        return Float.valueOf(this.value());
    }

    @Override
    public Double doubleObject() {
        return this.value();
    }

    @Override
    public byte byteValue() {
        return (byte)this.value();
    }

    @Override
    public short shortValue() {
        return (short)this.value();
    }

    @Override
    public int intValue() {
        return (int)this.value();
    }

    @Override
    public long longValue() {
        return (long)this.value();
    }

    @Override
    public float floatValue() {
        return this.value();
    }

    @Override
    public double doubleValue() {
        return this.value();
    }

    @Override
    protected int compareCore(TsonElement o) {
        return Float.compare(this.value, o.toFloat().value());
    }

    @Override
    public int compareTo(TsonElement o) {
        long lon = Long.MAX_VALUE;
        float t = Float.MAX_VALUE;
        float v = (float)lon + t;
        if (o.type().isNumber()) {
            switch (o.type()) {
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: 
                case FLOAT: {
                    int i = Float.compare(this.value(), o.floatValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
                case DOUBLE: {
                    int i = Double.compare(this.value(), o.doubleValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
            }
        }
        return super.compareTo(o);
    }
}

