/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAlias;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArrayBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigDecimal;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBinaryStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBoolean;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonChar;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCharStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCustom;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCustomBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDoubleComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloatComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInstant;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonListContainer;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDate;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDateTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrix;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonName;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNull;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumber;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObjectBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOp;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOpBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOpType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPairBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonRegex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUpletBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonArrayBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonObjectBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonOpBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPairBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonUpletBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractTsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public abstract class TsonElementDecorator
extends AbstractTsonElementBase {
    private TsonElement base;
    private TsonComments comments = TsonComments.BLANK;
    private TsonAnnotation[] annotations;

    private static TsonComment[] trimToNull(TsonComment[] comments) {
        if (comments == null) {
            return null;
        }
        ArrayList<TsonComment> ok = new ArrayList<TsonComment>();
        for (TsonComment c : comments) {
            if (c == null) continue;
            ok.add(c);
        }
        if (ok.isEmpty()) {
            return null;
        }
        return ok.toArray(new TsonComment[0]);
    }

    public static TsonElement of(TsonElement base, TsonComments comments, TsonAnnotation[] annotations) {
        boolean decorated = base instanceof TsonElementDecorator;
        if (comments == null && (annotations == null || annotations.length == 0)) {
            if (!decorated) {
                return base;
            }
            return ((TsonElementDecorator)base).base;
        }
        if (annotations == null) {
            annotations = TsonUtils.TSON_ANNOTATIONS_EMPTY_ARRAY;
        }
        List<TsonAnnotation> annList = Arrays.asList(annotations);
        if (decorated) {
            TsonComments oldComments = base.comments();
            List<TsonAnnotation> oldAnnotations = base.annotations();
            if (Objects.equals(comments, oldComments) && annList.equals(oldAnnotations)) {
                return base;
            }
        }
        switch (base.type()) {
            case NULL: {
                return new AsNull((TsonNull)base, comments, annotations);
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                return new AsString((TsonString)base, comments, annotations);
            }
            case BOOLEAN: {
                return new AsBoolean((TsonBoolean)base, comments, annotations);
            }
            case BYTE: {
                return new AsByte((TsonByte)base, comments, annotations);
            }
            case SHORT: {
                return new AsShort((TsonShort)base, comments, annotations);
            }
            case INTEGER: {
                return new AsInt((TsonInt)base, comments, annotations);
            }
            case LONG: {
                return new AsLong((TsonLong)base, comments, annotations);
            }
            case FLOAT: {
                return new AsFloat((TsonFloat)base, comments, annotations);
            }
            case DOUBLE: {
                return new AsDouble((TsonDouble)base, comments, annotations);
            }
            case NAME: {
                return new AsName((TsonName)base, comments, annotations);
            }
            case ALIAS: {
                return new AsAlias((TsonAlias)base, comments, annotations);
            }
            case REGEX: {
                return new AsRegex((TsonRegex)base, comments, annotations);
            }
            case INSTANT: {
                return new AsInstant((TsonInstant)base, comments, annotations);
            }
            case LOCAL_DATE: {
                return new AsLocalLocalDate((TsonLocalDate)base, comments, annotations);
            }
            case LOCAL_DATETIME: {
                return new AsLocalDateTime((TsonLocalDateTime)base, comments, annotations);
            }
            case LOCAL_TIME: {
                return new AsLocalTime((TsonLocalTime)base, comments, annotations);
            }
            case CHAR: {
                return new AsChar((TsonChar)base, comments, annotations);
            }
            case OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                return new AsObject((TsonObject)base, comments, annotations);
            }
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: {
                return new AsArray((TsonArray)base, comments, annotations);
            }
            case MATRIX: 
            case NAMED_MATRIX: 
            case PARAMETRIZED_MATRIX: 
            case NAMED_PARAMETRIZED_MATRIX: {
                return new AsMatrix((TsonMatrix)base, comments, annotations);
            }
            case UPLET: 
            case NAMED_UPLET: {
                return new AsUplet((TsonUplet)base, comments, annotations);
            }
            case PAIR: {
                return new AsPair((TsonPair)base, comments, annotations);
            }
            case BIG_INTEGER: {
                return new AsBigInt((TsonBigInt)base, comments, annotations);
            }
            case BIG_COMPLEX: {
                return new AsBigComplex((TsonBigComplex)base, comments, annotations);
            }
            case BIG_DECIMAL: {
                return new AsBigDecimal((TsonBigDecimal)base, comments, annotations);
            }
            case BINARY_STREAM: {
                return new AsBinaryStream((TsonBinaryStream)base, comments, annotations);
            }
            case CHAR_STREAM: {
                return new AsCharStream((TsonCharStream)base, comments, annotations);
            }
            case DOUBLE_COMPLEX: {
                return new AsDoubleComplex((TsonDoubleComplex)base, comments, annotations);
            }
            case FLOAT_COMPLEX: {
                return new AsFloatComplex((TsonFloatComplex)base, comments, annotations);
            }
            case OP: {
                return new AsOp((TsonOp)base, comments, annotations);
            }
            case CUSTOM: {
                return new AsCustom((TsonOp)base, comments, annotations);
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)base.type()));
    }

    public static TsonElement of(TsonElement base, TsonComments comments, Collection<TsonAnnotation> annotationsList) {
        ArrayList annotations;
        boolean decorated = base instanceof TsonElementDecorator;
        if (comments == null && (annotationsList == null || annotationsList.isEmpty())) {
            if (!decorated) {
                return base;
            }
            return ((TsonElementDecorator)base).base;
        }
        List<Object> list = annotations = annotationsList == null ? new ArrayList() : annotationsList.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (decorated) {
            TsonComments oldComments = base.comments();
            List<TsonAnnotation> oldAnnotations = base.annotations();
            if (Objects.equals(comments, oldComments) && annotations.equals(oldAnnotations)) {
                return base;
            }
        }
        if ((comments == null || comments.isEmpty()) && annotations.size() == 0) {
            return base;
        }
        TsonAnnotation[] annArr = annotations.toArray(new TsonAnnotation[0]);
        switch (base.type()) {
            case NULL: {
                return new AsNull((TsonNull)base, comments, annArr);
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                return new AsString((TsonString)base, comments, annArr);
            }
            case BOOLEAN: {
                return new AsBoolean((TsonBoolean)base, comments, annArr);
            }
            case BYTE: {
                return new AsByte((TsonByte)base, comments, annArr);
            }
            case SHORT: {
                return new AsShort((TsonShort)base, comments, annArr);
            }
            case INTEGER: {
                return new AsInt((TsonInt)base, comments, annArr);
            }
            case LONG: {
                return new AsLong((TsonLong)base, comments, annArr);
            }
            case FLOAT: {
                return new AsFloat((TsonFloat)base, comments, annArr);
            }
            case DOUBLE: {
                return new AsDouble((TsonDouble)base, comments, annArr);
            }
            case NAME: {
                return new AsName((TsonName)base, comments, annArr);
            }
            case REGEX: {
                return new AsRegex((TsonRegex)base, comments, annArr);
            }
            case LOCAL_DATE: {
                return new AsLocalLocalDate((TsonLocalDate)base, comments, annArr);
            }
            case LOCAL_DATETIME: {
                return new AsLocalDateTime((TsonLocalDateTime)base, comments, annArr);
            }
            case LOCAL_TIME: {
                return new AsLocalTime((TsonLocalTime)base, comments, annArr);
            }
            case CHAR: {
                return new AsChar((TsonChar)base, comments, annArr);
            }
            case OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                return new AsObject((TsonObject)base, comments, annArr);
            }
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: {
                return new AsArray((TsonArray)base, comments, annArr);
            }
            case UPLET: 
            case NAMED_UPLET: {
                return new AsUplet((TsonUplet)base, comments, annArr);
            }
            case PAIR: {
                return new AsPair((TsonPair)base, comments, annArr);
            }
        }
        throw new IllegalArgumentException("Unsupported " + (Object)((Object)base.type()));
    }

    private TsonElementDecorator(TsonElement base, TsonComments comments, TsonAnnotation[] annotations) {
        if (base instanceof TsonElementDecorator) {
            base = ((TsonElementDecorator)base).base;
        }
        this.base = base;
        this.comments = comments == null ? TsonComments.BLANK : comments;
        this.annotations = Arrays.copyOf(annotations, annotations.length);
    }

    protected void processCommentsAndAnnotations(TsonParserVisitor visitor) {
        for (TsonComment c : this.comments().leadingComments()) {
            visitor.visitComments(c);
        }
        for (TsonAnnotation annotation : this.annotations()) {
            visitor.visitAnnotationStart(annotation.name().orNull());
            List<TsonElement> params = annotation.params();
            if (params != null) {
                visitor.visitAnnotationParamsStart();
                for (TsonElement param : params) {
                    visitor.visitAnnotationParamStart();
                    param.visit(visitor);
                    visitor.visitAnnotationParamEnd();
                }
                visitor.visitAnnotationParamsEnd();
            }
            visitor.visitAnnotationEnd();
        }
    }

    public TsonElement getBase() {
        return this.base;
    }

    public TsonElement simplify() {
        if (this.comments == null && this.annotations.length == 0) {
            return this.base;
        }
        return this;
    }

    @Override
    public TsonMatrix toMatrix() {
        return this.base.toMatrix();
    }

    @Override
    public TsonElementType type() {
        return this.base.type();
    }

    @Override
    public TsonComments comments() {
        return this.comments;
    }

    @Override
    public List<TsonAnnotation> annotations() {
        return Arrays.asList(this.annotations);
    }

    @Override
    public int annotationsCount() {
        return this.annotations.length;
    }

    @Override
    public TsonString toStr() {
        return this.base.toStr();
    }

    @Override
    public TsonLong toLong() {
        return this.base.toLong();
    }

    @Override
    public TsonCustom toCustom() {
        return this.base.toCustom();
    }

    @Override
    public TsonNumber toNumber() {
        return this.base.toNumber();
    }

    @Override
    public TsonBinaryStream toBinaryStream() {
        return this.base.toBinaryStream();
    }

    @Override
    public TsonCharStream toCharStream() {
        return this.base.toCharStream();
    }

    @Override
    public TsonInt toInt() {
        return this.base.toInt();
    }

    @Override
    public TsonShort toShort() {
        return this.base.toShort();
    }

    @Override
    public TsonByte toByte() {
        return this.base.toByte();
    }

    @Override
    public TsonChar toChar() {
        return this.base.toChar();
    }

    @Override
    public TsonBoolean toBoolean() {
        return this.base.toBoolean();
    }

    @Override
    public TsonName toName() {
        return this.base.toName();
    }

    @Override
    public TsonAlias toAlias() {
        return this.base.toAlias();
    }

    @Override
    public Temporal temporalValue() {
        return this.base.temporalValue();
    }

    @Override
    public TsonArray toArray() {
        return this.base.toArray();
    }

    @Override
    public TsonListContainer toListContainer() {
        return this.base.toListContainer();
    }

    @Override
    public TsonObject toObject() {
        return this.base.toObject();
    }

    @Override
    public TsonUplet toUplet() {
        return this.base.toUplet();
    }

    @Override
    public byte byteValue() {
        return this.base.byteValue();
    }

    @Override
    public char charValue() {
        return this.base.charValue();
    }

    @Override
    public boolean booleanValue() {
        return this.base.booleanValue();
    }

    @Override
    public String stringValue() {
        return this.base.stringValue();
    }

    @Override
    public int intValue() {
        return this.base.intValue();
    }

    @Override
    public long longValue() {
        return this.base.longValue();
    }

    @Override
    public short shortValue() {
        return this.base.shortValue();
    }

    @Override
    public TsonLocalDate toLocalDate() {
        return this.base.toLocalDate();
    }

    @Override
    public TsonInstant toInstant() {
        return this.base.toInstant();
    }

    @Override
    public TsonLocalDateTime toLocalDateTime() {
        return this.base.toLocalDateTime();
    }

    @Override
    public TsonLocalTime toLocalTime() {
        return this.base.toLocalTime();
    }

    @Override
    public TsonRegex toRegex() {
        return this.base.toRegex();
    }

    @Override
    public LocalDate localDateValue() {
        return this.base.localDateValue();
    }

    @Override
    public Instant instantValue() {
        return this.base.instantValue();
    }

    @Override
    public LocalDateTime localDateTimeValue() {
        return this.base.localDateTimeValue();
    }

    @Override
    public LocalTime localTimeValue() {
        return this.base.localTimeValue();
    }

    @Override
    public Pattern regexValue() {
        return this.base.regexValue();
    }

    @Override
    public TsonFloat toFloat() {
        return this.base.toFloat();
    }

    @Override
    public TsonDouble toDouble() {
        return this.base.toDouble();
    }

    @Override
    public TsonPair toPair() {
        return this.base.toPair();
    }

    @Override
    public TsonOp toOp() {
        return this.base.toOp();
    }

    @Override
    public float floatValue() {
        return this.base.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.base.doubleValue();
    }

    @Override
    public Boolean booleanObject() {
        return this.base.booleanObject();
    }

    @Override
    public Character charObject() {
        return this.base.charObject();
    }

    @Override
    public Byte byteObject() {
        return this.base.byteObject();
    }

    @Override
    public Integer intObject() {
        return this.base.intObject();
    }

    @Override
    public Long longObject() {
        return this.base.longObject();
    }

    @Override
    public Short shortObject() {
        return this.base.shortObject();
    }

    @Override
    public Float floatObject() {
        return this.base.floatObject();
    }

    @Override
    public Double doubleObject() {
        return this.base.doubleObject();
    }

    @Override
    public TsonBigInt toBigInt() {
        return this.base.toBigInt();
    }

    @Override
    public TsonBigDecimal toBigDecimal() {
        return this.base.toBigDecimal();
    }

    @Override
    public TsonBigComplex toBigComplex() {
        return this.base.toBigComplex();
    }

    @Override
    public TsonFloatComplex toFloatComplex() {
        return this.base.toFloatComplex();
    }

    @Override
    public TsonDoubleComplex toDoubleComplex() {
        return this.base.toDoubleComplex();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.base.bigIntegerValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.base.bigDecimalValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsonElementDecorator that = (TsonElementDecorator)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.comments, that.comments) && Arrays.equals(this.annotations, that.annotations);
    }

    public int hashCode() {
        int result = Objects.hash(this.base, this.comments);
        result = 31 * result + Arrays.hashCode(this.annotations);
        return result;
    }

    @Override
    public TsonElementBuilder builder() {
        return this.base.builder();
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        return this.base.visit(visitor);
    }

    @Override
    public String toString() {
        return Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(boolean compact) {
        return compact ? Tson.COMPACT_FORMAT.format(this) : Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(TsonFormat format) {
        return format == null ? Tson.DEFAULT_FORMAT.format(this) : format.format(this);
    }

    @Override
    public Number numberValue() {
        return this.base.numberValue();
    }

    @Override
    public int compareTo(TsonElement o) {
        return this.base.compareTo(o);
    }

    @Override
    public boolean isNull() {
        return this.base.isNull();
    }

    public static class AsNull
    extends AsPrimitive<TsonNull>
    implements TsonNull {
        public AsNull(TsonNull base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }
    }

    public static class AsString
    extends AsPrimitive<TsonString>
    implements TsonString {
        public AsString(TsonString base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonString toStr() {
            return this;
        }

        @Override
        public String raw() {
            return ((TsonString)this.getBase()).raw();
        }

        @Override
        public String value() {
            return ((TsonString)this.getBase()).value();
        }

        @Override
        public String literalString() {
            return ((TsonString)this.getBase()).literalString();
        }
    }

    public static class AsBoolean
    extends AsPrimitive<TsonBoolean>
    implements TsonBoolean {
        public AsBoolean(TsonBoolean base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonBoolean toBoolean() {
            return this;
        }

        @Override
        public boolean value() {
            return ((TsonBoolean)this.getBase()).value();
        }
    }

    public static class AsByte
    extends AsPrimitive<TsonByte>
    implements TsonByte {
        public AsByte(TsonByte base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonByte toByte() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonByte)this.getBase()).numberLayout();
        }

        @Override
        public byte value() {
            return ((TsonByte)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonByte)this.getBase()).numberSuffix();
        }
    }

    public static class AsShort
    extends AsPrimitive<TsonShort>
    implements TsonShort {
        public AsShort(TsonShort base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonShort toShort() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonShort)this.getBase()).numberLayout();
        }

        @Override
        public short value() {
            return ((TsonShort)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonShort)this.getBase()).numberSuffix();
        }
    }

    public static class AsInt
    extends AsPrimitive<TsonInt>
    implements TsonInt {
        public AsInt(TsonInt base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonInt toInt() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonInt)this.getBase()).numberLayout();
        }

        @Override
        public int value() {
            return ((TsonInt)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonInt)this.getBase()).numberSuffix();
        }
    }

    public static class AsLong
    extends AsPrimitive<TsonLong>
    implements TsonLong {
        public AsLong(TsonLong base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonLong toLong() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonLong)this.getBase()).numberLayout();
        }

        @Override
        public long value() {
            return ((TsonLong)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonLong)this.getBase()).numberSuffix();
        }
    }

    public static class AsFloat
    extends AsPrimitive<TsonFloat>
    implements TsonFloat {
        public AsFloat(TsonFloat base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonFloat toFloat() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonFloat)this.getBase()).numberLayout();
        }

        @Override
        public float value() {
            return ((TsonFloat)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonFloat)this.getBase()).numberSuffix();
        }
    }

    public static class AsDouble
    extends AsPrimitive<TsonDouble>
    implements TsonDouble {
        public AsDouble(TsonDouble base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonDouble toDouble() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonDouble)this.getBase()).numberLayout();
        }

        @Override
        public double value() {
            return ((TsonDouble)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonDouble)this.getBase()).numberSuffix();
        }
    }

    public static class AsName
    extends AsPrimitive<TsonName>
    implements TsonName {
        public AsName(TsonName base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonName toName() {
            return this;
        }

        @Override
        public String value() {
            return ((TsonName)this.getBase()).value();
        }
    }

    public static class AsAlias
    extends AsPrimitive<TsonAlias>
    implements TsonAlias {
        public AsAlias(TsonAlias base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonAlias toAlias() {
            return this;
        }

        @Override
        public String getName() {
            return ((TsonAlias)this.getBase()).getName();
        }
    }

    public static class AsRegex
    extends AsPrimitive<TsonRegex>
    implements TsonRegex {
        public AsRegex(TsonRegex base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonRegex toRegex() {
            return this;
        }

        @Override
        public Pattern value() {
            return ((TsonRegex)this.getBase()).value();
        }
    }

    public static class AsInstant
    extends AsPrimitive<TsonInstant>
    implements TsonInstant {
        public AsInstant(TsonInstant base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonInstant toInstant() {
            return this;
        }

        @Override
        public Instant value() {
            return ((TsonInstant)this.getBase()).value();
        }
    }

    public static class AsLocalLocalDate
    extends AsPrimitive<TsonLocalDate>
    implements TsonLocalDate {
        public AsLocalLocalDate(TsonLocalDate base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonLocalDate toLocalDate() {
            return this;
        }

        @Override
        public LocalDate value() {
            return ((TsonLocalDate)this.getBase()).value();
        }
    }

    public static class AsLocalDateTime
    extends AsPrimitive<TsonLocalDateTime>
    implements TsonLocalDateTime {
        public AsLocalDateTime(TsonLocalDateTime base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonLocalDateTime toLocalDateTime() {
            return this;
        }

        @Override
        public LocalDateTime value() {
            return ((TsonLocalDateTime)this.getBase()).value();
        }
    }

    public static class AsLocalTime
    extends AsPrimitive<TsonLocalTime>
    implements TsonLocalTime {
        public AsLocalTime(TsonLocalTime base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonLocalTime toLocalTime() {
            return this;
        }

        @Override
        public LocalTime value() {
            return ((TsonLocalTime)this.getBase()).value();
        }
    }

    public static class AsChar
    extends AsPrimitive<TsonChar>
    implements TsonChar {
        public AsChar(TsonChar base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonChar toChar() {
            return this;
        }

        @Override
        public char value() {
            return ((TsonChar)this.getBase()).value();
        }
    }

    public static class AsObject
    extends TsonElementDecorator
    implements TsonObject {
        public AsObject(TsonObject base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public boolean isNamed() {
            return this.name() != null;
        }

        @Override
        public TsonObject toObject() {
            return this;
        }

        @Override
        public TsonElementList params() {
            return this.getBase().params();
        }

        @Override
        public TsonListContainer toListContainer() {
            return this;
        }

        @Override
        public String name() {
            return this.getBase().name();
        }

        @Override
        public TsonObject getBase() {
            return (TsonObject)super.getBase();
        }

        @Override
        public TsonElement get(String name) {
            return this.getBase().get(name);
        }

        @Override
        public TsonElementList body() {
            return this.getBase().body();
        }

        @Override
        public TsonElement get(TsonElement element) {
            return this.getBase().get(element);
        }

        @Override
        public int size() {
            return this.getBase().size();
        }

        @Override
        public Iterator<TsonElement> iterator() {
            return this.getBase().iterator();
        }

        @Override
        public TsonObjectBuilder builder() {
            return new TsonObjectBuilderImpl().merge(this);
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitElementStart();
            this.processCommentsAndAnnotations(visitor);
            if (this.name() != null) {
                visitor.visitNamedStart(this.name());
            }
            if (this.isParametrized()) {
                visitor.visitParamsStart();
                for (TsonElement param : this.params()) {
                    visitor.visitParamElementStart();
                    param.visit(visitor);
                    visitor.visitParamElementEnd();
                }
                visitor.visitParamsEnd();
            }
            visitor.visitNamedObjectStart();
            for (TsonElement element : this.body()) {
                visitor.visitObjectElementStart();
                element.visit(visitor);
                visitor.visitObjectElementEnd();
            }
            visitor.visitObjectEnd();
        }

        @Override
        public boolean isParametrized() {
            return this.getBase().isParametrized();
        }

        @Override
        public int paramsCount() {
            return this.getBase().paramsCount();
        }
    }

    public static class AsArray
    extends TsonElementDecorator
    implements TsonArray {
        public AsArray(TsonArray base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public boolean isNamed() {
            return this.getBase().isNamed();
        }

        @Override
        public TsonArray toArray() {
            return this;
        }

        @Override
        public TsonElementList body() {
            return this.getBase().body();
        }

        @Override
        public TsonElementList params() {
            return this.getBase().params();
        }

        @Override
        public String name() {
            return this.getBase().name();
        }

        @Override
        public TsonListContainer toListContainer() {
            return this;
        }

        @Override
        public TsonElement get(int index) {
            return this.getBase().get(index);
        }

        @Override
        public TsonArray getBase() {
            return (TsonArray)super.getBase();
        }

        @Override
        public boolean isEmpty() {
            return this.getBase().isEmpty();
        }

        @Override
        public int size() {
            return this.getBase().size();
        }

        @Override
        public Iterator<TsonElement> iterator() {
            return this.getBase().iterator();
        }

        @Override
        public TsonArrayBuilder builder() {
            return new TsonArrayBuilderImpl().merge(this);
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitElementStart();
            this.processCommentsAndAnnotations(visitor);
            if (this.name() != null) {
                visitor.visitNamedStart(this.name());
            }
            if (this.isParametrized()) {
                visitor.visitParamsStart();
                for (TsonElement param : this.params()) {
                    visitor.visitParamElementStart();
                    param.visit(visitor);
                    visitor.visitParamElementEnd();
                }
                visitor.visitParamsEnd();
            }
            visitor.visitNamedArrayStart();
            for (TsonElement element : this.body()) {
                visitor.visitArrayElementStart();
                element.visit(visitor);
                visitor.visitArrayElementEnd();
            }
            visitor.visitArrayEnd();
        }

        @Override
        public boolean isParametrized() {
            return this.getBase().isParametrized();
        }

        @Override
        public int paramsCount() {
            return this.getBase().paramsCount();
        }
    }

    public static class AsMatrix
    extends TsonElementDecorator
    implements TsonMatrix {
        public AsMatrix(TsonMatrix base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public int columnSize() {
            return this.getBase().columnSize();
        }

        @Override
        public boolean isNamed() {
            return this.getBase().isNamed();
        }

        @Override
        public int paramsCount() {
            return this.getBase().paramsCount();
        }

        @Override
        public TsonMatrix toMatrix() {
            return this;
        }

        @Override
        public TsonMatrix getBase() {
            return (TsonMatrix)super.getBase();
        }

        @Override
        public int rowSize() {
            return this.getBase().rowSize();
        }

        @Override
        public List<TsonArray> rows() {
            return this.getBase().rows();
        }

        @Override
        public TsonElement cell(int col, int row) {
            return this.getBase().cell(col, row);
        }

        @Override
        public TsonArray row(int row) {
            return this.getBase().row(row);
        }

        @Override
        public TsonArray column(int column) {
            return this.getBase().column(column);
        }

        @Override
        public List<TsonArray> columns() {
            return this.getBase().columns();
        }

        @Override
        public boolean isEmpty() {
            return this.getBase().isEmpty();
        }

        @Override
        public Iterator<TsonArray> iterator() {
            return this.getBase().iterator();
        }

        @Override
        public TsonArrayBuilder builder() {
            return new TsonArrayBuilderImpl().merge(this);
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitElementStart();
            this.processCommentsAndAnnotations(visitor);
            if (this.name() != null) {
                visitor.visitNamedStart(this.name());
            }
            if (this.isParametrized()) {
                visitor.visitParamsStart();
                for (TsonElement tsonElement : this.params()) {
                    visitor.visitParamElementStart();
                    tsonElement.visit(visitor);
                    visitor.visitParamElementEnd();
                }
                visitor.visitParamsEnd();
            }
            visitor.visitNamedArrayStart();
            for (TsonElement tsonElement : this.rows()) {
                visitor.visitArrayElementStart();
                tsonElement.visit(visitor);
                visitor.visitArrayElementEnd();
            }
            visitor.visitArrayEnd();
        }

        @Override
        public String name() {
            return this.getBase().name();
        }

        @Override
        public boolean isParametrized() {
            return this.getBase().isParametrized();
        }

        @Override
        public TsonElementList params() {
            return this.getBase().params();
        }
    }

    public static class AsUplet
    extends TsonElementDecorator
    implements TsonUplet {
        public AsUplet(TsonUplet base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public boolean isParametrized() {
            return this.getBase().isParametrized();
        }

        @Override
        public TsonElement param(int index) {
            return this.getBase().param(index);
        }

        @Override
        public TsonUplet toUplet() {
            return this;
        }

        @Override
        public TsonListContainer toListContainer() {
            return this;
        }

        @Override
        public boolean isNamed() {
            return this.getBase().isNamed();
        }

        @Override
        public TsonElementList body() {
            return this.getBase().body();
        }

        @Override
        public TsonElementList params() {
            return this.getBase().params();
        }

        @Override
        public String name() {
            return this.getBase().name();
        }

        @Override
        public TsonUplet getBase() {
            return (TsonUplet)super.getBase();
        }

        @Override
        public int size() {
            return this.getBase().size();
        }

        @Override
        public boolean isBlank() {
            return this.getBase().isBlank();
        }

        @Override
        public Iterator<TsonElement> iterator() {
            return this.getBase().iterator();
        }

        @Override
        public TsonUpletBuilder builder() {
            return new TsonUpletBuilderImpl().merge(this);
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitElementStart();
            this.processCommentsAndAnnotations(visitor);
            if (this.isNamed()) {
                visitor.visitNamedStart(this.name());
            }
            visitor.visitParamsStart();
            for (TsonElement param : this.params()) {
                visitor.visitParamElementStart();
                param.visit(visitor);
                visitor.visitParamElementEnd();
            }
            visitor.visitParamsEnd();
            visitor.visitUpletEnd();
        }

        @Override
        public int paramsCount() {
            return this.getBase().paramsCount();
        }
    }

    public static class AsPair
    extends TsonElementDecorator
    implements TsonPair {
        public AsPair(TsonPair base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonPair toPair() {
            return this;
        }

        @Override
        public TsonPair getBase() {
            return (TsonPair)super.getBase();
        }

        @Override
        public TsonElement value() {
            return this.getBase().value();
        }

        @Override
        public TsonElement key() {
            return this.getBase().key();
        }

        @Override
        public TsonPairBuilder builder() {
            return new TsonPairBuilderImpl().merge(this);
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitInstructionStart();
            this.processCommentsAndAnnotations(visitor);
            this.key().visit(visitor);
            this.value().visit(visitor);
            visitor.visitKeyValueEnd();
        }
    }

    public static class AsBigInt
    extends AsPrimitive<TsonBigInt>
    implements TsonBigInt {
        public AsBigInt(TsonBigInt base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonBigInt toBigInt() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonBigInt)this.getBase()).numberLayout();
        }

        @Override
        public BigInteger value() {
            return ((TsonBigInt)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonBigInt)this.getBase()).numberSuffix();
        }
    }

    public static class AsBigComplex
    extends AsPrimitive<TsonBigComplex>
    implements TsonBigComplex {
        public AsBigComplex(TsonBigComplex base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonBigComplex toBigComplex() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonBigComplex)this.getBase()).numberLayout();
        }

        @Override
        public BigDecimal real() {
            return ((TsonBigComplex)this.getBase()).real();
        }

        @Override
        public BigDecimal imag() {
            return ((TsonBigComplex)this.getBase()).imag();
        }

        @Override
        public String numberSuffix() {
            return ((TsonBigComplex)this.getBase()).numberSuffix();
        }
    }

    public static class AsBigDecimal
    extends AsPrimitive<TsonBigDecimal>
    implements TsonBigDecimal {
        public AsBigDecimal(TsonBigDecimal base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonBigDecimal toBigDecimal() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonBigDecimal)this.getBase()).numberLayout();
        }

        @Override
        public BigDecimal value() {
            return ((TsonBigDecimal)this.getBase()).value();
        }

        @Override
        public String numberSuffix() {
            return ((TsonBigDecimal)this.getBase()).numberSuffix();
        }
    }

    public static class AsBinaryStream
    extends AsPrimitive<TsonBinaryStream>
    implements TsonBinaryStream {
        public AsBinaryStream(TsonBinaryStream base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonBinaryStream toBinaryStream() {
            return this;
        }

        @Override
        public InputStream value() {
            return ((TsonBinaryStream)this.getBase()).value();
        }

        @Override
        public Reader getBase64Value() {
            return ((TsonBinaryStream)this.getBase()).getBase64Value();
        }

        @Override
        public Reader getBase64Value(int lineMax) {
            return ((TsonBinaryStream)this.getBase()).getBase64Value(lineMax);
        }
    }

    public static class AsCharStream
    extends AsPrimitive<TsonCharStream>
    implements TsonCharStream {
        public AsCharStream(TsonCharStream base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonCharStream toCharStream() {
            return this;
        }

        @Override
        public String getStreamType() {
            return ((TsonCharStream)this.getBase()).getStreamType();
        }

        @Override
        public Reader value() {
            return ((TsonCharStream)this.getBase()).value();
        }
    }

    public static class AsDoubleComplex
    extends AsPrimitive<TsonDoubleComplex>
    implements TsonDoubleComplex {
        public AsDoubleComplex(TsonDoubleComplex base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonDoubleComplex toDoubleComplex() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonDoubleComplex)this.getBase()).numberLayout();
        }

        @Override
        public double real() {
            return ((TsonDoubleComplex)this.getBase()).real();
        }

        @Override
        public double imag() {
            return ((TsonDoubleComplex)this.getBase()).imag();
        }

        @Override
        public String numberSuffix() {
            return ((TsonDoubleComplex)this.getBase()).numberSuffix();
        }
    }

    public static class AsFloatComplex
    extends AsPrimitive<TsonFloatComplex>
    implements TsonFloatComplex {
        public AsFloatComplex(TsonFloatComplex base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonFloatComplex toFloatComplex() {
            return this;
        }

        @Override
        public TsonNumberLayout numberLayout() {
            return ((TsonFloatComplex)this.getBase()).numberLayout();
        }

        @Override
        public float real() {
            return ((TsonFloatComplex)this.getBase()).real();
        }

        @Override
        public float imag() {
            return ((TsonFloatComplex)this.getBase()).imag();
        }

        @Override
        public String numberSuffix() {
            return ((TsonFloatComplex)this.getBase()).numberSuffix();
        }
    }

    public static class AsOp
    extends TsonElementDecorator
    implements TsonOp {
        public AsOp(TsonOp base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonOpBuilder builder() {
            return new TsonOpBuilderImpl().merge(this);
        }

        @Override
        public TsonOp toOp() {
            return this;
        }

        @Override
        public TsonOpType opType() {
            return this.getBase().opType();
        }

        @Override
        public TsonOp getBase() {
            return (TsonOp)super.getBase();
        }

        @Override
        public TsonElement second() {
            return this.getBase().second();
        }

        @Override
        public TsonElement first() {
            return this.getBase().first();
        }

        @Override
        public String opName() {
            return this.getBase().opName();
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitElementStart();
            this.processCommentsAndAnnotations(visitor);
            this.first().visit(visitor);
            visitor.visitBinOpEnd(this.opName());
            this.second().visit(visitor);
        }
    }

    public static class AsCustom
    extends TsonElementDecorator
    implements TsonCustom {
        public AsCustom(TsonOp base, TsonComments comments, TsonAnnotation[] annotations) {
            super(base, comments, annotations);
        }

        @Override
        public TsonCustom toCustom() {
            return this;
        }

        @Override
        public TsonCustom getBase() {
            return (TsonCustom)super.getBase();
        }

        @Override
        public Object value() {
            return this.getBase().value();
        }

        @Override
        public TsonCustomBuilder builder() {
            return this.getBase().builder();
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitElementStart();
            this.processCommentsAndAnnotations(visitor);
            visitor.visitCustomEnd(this);
        }
    }

    public static abstract class AsPrimitive<T extends TsonElement>
    extends TsonElementDecorator {
        public AsPrimitive(T base, TsonComments comments, TsonAnnotation[] annotations) {
            super((TsonElement)base, comments, annotations);
        }

        public T getBase() {
            return (T)super.getBase();
        }

        @Override
        public TsonPrimitiveBuilder builder() {
            return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
        }

        @Override
        public void visit(TsonParserVisitor visitor) {
            visitor.visitElementStart();
            this.processCommentsAndAnnotations(visitor);
            visitor.visitPrimitiveEnd(this);
        }
    }
}

