/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNumberTsonElement;

public class TsonDoubleImpl
extends AbstractNumberTsonElement
implements TsonDouble {
    private double value;

    public TsonDoubleImpl(double value, String unit) {
        super(TsonElementType.DOUBLE, TsonNumberLayout.DECIMAL, unit);
        this.value = value;
    }

    @Override
    public Number numberValue() {
        return this.value();
    }

    @Override
    public TsonDouble toDouble() {
        return this;
    }

    @Override
    public double value() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonDoubleImpl that = (TsonDoubleImpl)o;
        return Double.compare(that.value, this.value) == 0;
    }

    @Override
    public TsonByte toByte() {
        return Tson.of((byte)this.value()).toByte();
    }

    @Override
    public TsonShort toShort() {
        return Tson.of((short)this.value()).toShort();
    }

    @Override
    public TsonInt toInt() {
        return Tson.of((int)this.value()).toInt();
    }

    @Override
    public TsonLong toLong() {
        return Tson.of((long)this.value()).toLong();
    }

    @Override
    public TsonFloat toFloat() {
        return Tson.of((float)this.value()).toFloat();
    }

    @Override
    public Byte byteObject() {
        return (byte)this.value();
    }

    @Override
    public Long longObject() {
        return (long)this.value();
    }

    @Override
    public Integer intObject() {
        return (int)this.value();
    }

    @Override
    public Short shortObject() {
        return (short)this.value();
    }

    @Override
    public Float floatObject() {
        return Float.valueOf((float)this.value());
    }

    @Override
    public Double doubleObject() {
        return this.value();
    }

    @Override
    public byte byteValue() {
        return (byte)this.value();
    }

    @Override
    public short shortValue() {
        return (short)this.value();
    }

    @Override
    public int intValue() {
        return (int)this.value();
    }

    @Override
    public long longValue() {
        return (long)this.value();
    }

    @Override
    public float floatValue() {
        return (float)this.value();
    }

    @Override
    public double doubleValue() {
        return this.value();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return Double.compare(this.value, o.toDouble().value());
    }

    @Override
    public int compareTo(TsonElement o) {
        if (o.type().isNumber()) {
            switch (o.type()) {
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: {
                    int i = Double.compare(this.value(), o.doubleValue());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
            }
        }
        return super.compareTo(o);
    }
}

