/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocument;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeader;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonDocumentBuilderImpl;

public class TsonDocumentImpl
implements TsonDocument {
    private TsonDocumentHeader header;
    private TsonElement content;

    public TsonDocumentImpl(TsonDocumentHeader header, TsonElement content) {
        this.header = header;
        this.content = content;
    }

    @Override
    public TsonDocumentHeader getHeader() {
        return this.header;
    }

    @Override
    public TsonElement getContent() {
        return this.content;
    }

    public TsonDocumentBuilder builder() {
        return new TsonDocumentBuilderImpl().setHeader(this.header).setValue(this.content);
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (!visitor.visit(this)) {
            return false;
        }
        if (!visitor.visit(this.header)) {
            return false;
        }
        return visitor.visit(this.content);
    }

    public String toString() {
        return Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(boolean compact) {
        return compact ? Tson.COMPACT_FORMAT.format(this) : Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(TsonFormat format) {
        return format == null ? Tson.DEFAULT_FORMAT.format(this) : format.format(this);
    }

    @Override
    public int compareTo(TsonDocument o) {
        int i = this.header.compareTo(o.getHeader());
        if (i != 0) {
            return i;
        }
        i = this.content.compareTo(o.getContent());
        if (i != 0) {
            return i;
        }
        return 0;
    }
}

