/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBoolean;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractPrimitiveTsonElement;

public class TsonBooleanImpl
extends AbstractPrimitiveTsonElement
implements TsonBoolean {
    public static final TsonBoolean TRUE = new TsonBooleanImpl(true);
    public static final TsonBoolean FALSE = new TsonBooleanImpl(false);
    private boolean value;

    public static final TsonBoolean valueOf(boolean value) {
        return value ? TRUE : FALSE;
    }

    private TsonBooleanImpl(boolean value) {
        super(TsonElementType.BOOLEAN);
        this.value = value;
    }

    @Override
    public TsonString toStr() {
        return (TsonString)Tson.of(String.valueOf(this.value));
    }

    @Override
    public TsonBoolean toBoolean() {
        return this;
    }

    @Override
    public boolean value() {
        return this.value;
    }

    @Override
    public boolean booleanValue() {
        return this.value();
    }

    @Override
    public Boolean booleanObject() {
        return this.value();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonBooleanImpl that = (TsonBooleanImpl)o;
        return this.value == that.value;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return Boolean.compare(this.value, o.toBoolean().value());
    }
}

