/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigDecimal;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNumberTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBigDecimalImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBigIntImpl;

public class TsonBigComplexImpl
extends AbstractNumberTsonElement
implements TsonBigComplex {
    private BigDecimal real;
    private BigDecimal imag;

    public TsonBigComplexImpl(BigDecimal real, BigDecimal imag, String unit) {
        super(TsonElementType.BIG_COMPLEX, TsonNumberLayout.DECIMAL, unit);
        this.real = real;
        this.imag = imag;
    }

    @Override
    public Number numberValue() {
        return new TsonComplex(this.real, this.imag);
    }

    @Override
    public TsonBigDecimal toBigDecimal() {
        return new TsonBigDecimalImpl(this.real(), this.numberSuffix());
    }

    @Override
    public BigDecimal real() {
        return this.real;
    }

    @Override
    public BigDecimal imag() {
        return this.imag;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonBigComplexImpl tsonInt = (TsonBigComplexImpl)o;
        return this.real.equals(tsonInt.real) && this.imag.equals(tsonInt.imag);
    }

    @Override
    public TsonByte toByte() {
        return Tson.of(this.numberValue().byteValue()).toByte();
    }

    @Override
    public TsonShort toShort() {
        return Tson.of(this.numberValue().shortValue()).toShort();
    }

    @Override
    public TsonLong toLong() {
        return Tson.of(this.numberValue().longValue()).toLong();
    }

    @Override
    public TsonFloat toFloat() {
        return Tson.of(this.numberValue().floatValue()).toFloat();
    }

    @Override
    public TsonDouble toDouble() {
        return Tson.of(this.numberValue().doubleValue()).toDouble();
    }

    @Override
    public Byte byteObject() {
        return this.numberValue().byteValue();
    }

    @Override
    public Long longObject() {
        return this.numberValue().longValue();
    }

    @Override
    public Integer intObject() {
        return this.numberValue().intValue();
    }

    @Override
    public Short shortObject() {
        return this.numberValue().shortValue();
    }

    @Override
    public Float floatObject() {
        return Float.valueOf(this.numberValue().floatValue());
    }

    @Override
    public Double doubleObject() {
        return this.numberValue().doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return this.real();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return this.real().toBigInteger();
    }

    @Override
    public TsonBigInt toBigInt() {
        return new TsonBigIntImpl(this.bigIntegerValue(), this.numberLayout(), this.numberSuffix());
    }

    @Override
    public byte byteValue() {
        return this.numberValue().byteValue();
    }

    @Override
    public short shortValue() {
        return this.numberValue().shortValue();
    }

    @Override
    public int intValue() {
        return this.numberValue().intValue();
    }

    @Override
    public long longValue() {
        return this.numberValue().longValue();
    }

    @Override
    public float floatValue() {
        return this.numberValue().floatValue();
    }

    @Override
    public double doubleValue() {
        return this.numberValue().doubleValue();
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.real, this.imag);
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return TsonBigComplexImpl.compare(this, o.toBigComplex());
    }

    public static int compare(TsonBigComplex a, TsonBigComplex oc) {
        int c = a.real().compareTo(oc.real());
        if (c != 0) {
            return c;
        }
        c = a.imag().compareTo(oc.imag());
        if (c != 0) {
            return c;
        }
        return c;
    }

    @Override
    public int compareTo(TsonElement o) {
        if (o.type().isNumber()) {
            switch (o.type()) {
                case BYTE: 
                case SHORT: 
                case INTEGER: 
                case LONG: 
                case BIG_INTEGER: 
                case FLOAT: 
                case DOUBLE: 
                case BIG_DECIMAL: 
                case BIG_COMPLEX: {
                    TsonBigComplex bce = o.toBigComplex();
                    int i = TsonBigComplexImpl.compare(this, o.toBigComplex());
                    return i == 0 ? this.type().compareTo(o.type()) : i;
                }
            }
        }
        return super.compareTo(o);
    }

    private static class TsonComplex
    extends Number {
        private BigDecimal real;
        private BigDecimal image;

        public TsonComplex(BigDecimal real, BigDecimal image) {
            this.real = real;
            this.image = image;
        }

        public BigDecimal getReal() {
            return this.real;
        }

        public BigDecimal getImage() {
            return this.image;
        }

        @Override
        public int intValue() {
            return this.real.intValue();
        }

        @Override
        public long longValue() {
            return this.real.longValue();
        }

        @Override
        public float floatValue() {
            return this.real.floatValue();
        }

        @Override
        public double doubleValue() {
            return this.real.doubleValue();
        }

        public String toString() {
            return "TsonBigComplex{real=" + this.real + ", image=" + this.image + '}';
        }
    }
}

