/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArrayBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonListContainer;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonArrayBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractNonPrimitiveTsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.UnmodifiableArrayList;

public class TsonArrayImpl
extends AbstractNonPrimitiveTsonElement
implements TsonArray {
    private String name;
    private TsonElementList args;
    private TsonElementList elements;

    public TsonArrayImpl(String name, TsonElementList params, UnmodifiableArrayList<TsonElement> elements) {
        super(name == null && params == null ? TsonElementType.ARRAY : (name == null && params != null ? TsonElementType.PARAMETRIZED_ARRAY : (name != null && params == null ? TsonElementType.NAMED_ARRAY : TsonElementType.NAMED_PARAMETRIZED_ARRAY)));
        this.name = name;
        this.args = params;
        this.elements = new TsonElementListImpl(elements.stream().map(x -> x).collect(Collectors.toList()));
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public TsonElementList body() {
        return this.elements;
    }

    @Override
    public TsonElementList params() {
        return this.args;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TsonElement get(int index) {
        return this.elements.getAt(index);
    }

    @Override
    public boolean isParametrized() {
        return this.args != null;
    }

    @Override
    public int paramsCount() {
        return this.args == null ? 0 : this.args.size();
    }

    @Override
    public TsonArray toArray() {
        return this;
    }

    @Override
    public TsonListContainer toListContainer() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Iterator<TsonElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonArrayImpl that = (TsonArrayImpl)o;
        return Objects.equals(this.elements, that.elements) && Objects.equals(this.name, that.name) && Objects.equals(this.args, that.args);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(super.hashCode(), this.name, this.args);
        result = 31 * result + Objects.hashCode(this.elements);
        return result;
    }

    @Override
    public TsonArrayBuilder builder() {
        return new TsonArrayBuilderImpl().merge(this);
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        if (this.args != null) {
            for (TsonElement element : this.args) {
                if (visitor.visit(element)) continue;
                return false;
            }
        }
        for (TsonElement element : this.elements) {
            if (visitor.visit(element)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected int compareCore(TsonElement o) {
        TsonArray na = o.toArray();
        int i = this.name().compareTo(na.name());
        if (i != 0) {
            return i;
        }
        i = TsonUtils.compareElementsArray(this.params(), na.params());
        if (i != 0) {
            return i;
        }
        return TsonUtils.compareElementsArray(this.body(), na.body());
    }

    @Override
    public void visit(TsonParserVisitor visitor) {
        visitor.visitElementStart();
        if (this.name != null) {
            visitor.visitNamedStart(this.name());
        }
        if (this.args != null) {
            visitor.visitParamsStart();
            for (TsonElement param : this.params()) {
                visitor.visitParamElementStart();
                param.visit(visitor);
                visitor.visitParamElementEnd();
            }
            visitor.visitParamsEnd();
        }
        visitor.visitNamedArrayStart();
        for (TsonElement element : this.body()) {
            visitor.visitArrayElementStart();
            element.visit(visitor);
            visitor.visitArrayElementEnd();
        }
        visitor.visitArrayEnd();
    }
}

