/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.util.Objects;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAlias;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractPrimitiveTsonElement;
import net.thevpc.nuts.util.NAssert;

public class TsonAliasImpl
extends AbstractPrimitiveTsonElement
implements TsonAlias {
    private String value;

    public TsonAliasImpl(String value) {
        super(TsonElementType.ALIAS);
        NAssert.requireNonNull(value, "value");
        this.value = value;
    }

    @Override
    public TsonAlias toAlias() {
        return this;
    }

    @Override
    public TsonString toStr() {
        return (TsonString)Tson.of(this.value);
    }

    @Override
    public String getName() {
        return this.value;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TsonAliasImpl tsonId = (TsonAliasImpl)o;
        return Objects.equals(this.value, tsonId.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value);
    }

    @Override
    public TsonPrimitiveBuilder builder() {
        return new TsonPrimitiveElementBuilderImpl().copyFrom(this);
    }

    @Override
    protected int compareCore(TsonElement o) {
        return this.value.compareTo(o.toName().value());
    }

    @Override
    public String stringValue() {
        return this.getName();
    }
}

