/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.io.Writer;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonCharStreamSource;

public class ReaderTsonCharStreamSource
extends TsonCharStreamSource {
    private ByteArrayOutputStream memoryBuffer = new ByteArrayOutputStream();
    private Writer memoryBufferWriter = new OutputStreamWriter(this.memoryBuffer);
    private Writer persistentBuffer;
    private int MAX_MEM_LEN = 80960;
    private long length;
    private boolean inMemory = true;
    private File tempFile;

    public void set(Reader inputStream) {
        char[] b = new char[8096];
        while (true) {
            int r;
            try {
                r = inputStream.read(b);
                if (r <= 0) {
                    break;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.push(b, 0, r);
        }
    }

    public void push(char[] buffer, int offset, int len) {
        try {
            if (this.inMemory) {
                if (this.length + (long)len < (long)this.MAX_MEM_LEN) {
                    this.memoryBufferWriter.write(buffer, offset, len);
                } else {
                    this.tempFile = File.createTempFile("tsonchar", ".temp");
                    this.persistentBuffer = new FileWriter(this.tempFile);
                    this.inMemory = false;
                    this.memoryBuffer.flush();
                    this.persistentBuffer.write(new String(this.memoryBuffer.toByteArray()));
                    this.memoryBuffer = null;
                }
            } else {
                this.memoryBuffer.flush();
                this.persistentBuffer.write(new String(this.memoryBuffer.toByteArray()));
            }
            this.length += (long)len;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public ReaderTsonCharStreamSource() {
    }

    public ReaderTsonCharStreamSource(Reader inputStream) {
        this.set(inputStream);
    }

    @Override
    public Reader open() {
        try {
            if (this.inMemory) {
                this.memoryBuffer.flush();
                return new StringReader(new String(this.memoryBuffer.toByteArray()));
            }
            if (this.persistentBuffer != null) {
                this.persistentBuffer.close();
                this.persistentBuffer = null;
            }
            return new FileReader(this.tempFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

