/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumber;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractPrimitiveTsonElement;

public abstract class AbstractNumberTsonElement
extends AbstractPrimitiveTsonElement
implements TsonNumber {
    private TsonNumberLayout layout;
    private String unit;

    public AbstractNumberTsonElement(TsonElementType type, TsonNumberLayout layout, String unit) {
        super(type);
        TsonNumberLayout tsonNumberLayout = this.layout = layout == null ? TsonNumberLayout.DECIMAL : layout;
        if (unit != null) {
            unit = unit.trim();
        }
        String string = unit == null ? null : (this.unit = unit.isEmpty() ? null : unit);
        if (this.unit != null && this.layout == TsonNumberLayout.HEXADECIMAL) {
            boolean someNonHex = false;
            for (char c : this.unit.toCharArray()) {
                boolean isHex;
                boolean bl = isHex = c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
                if (isHex) continue;
                someNonHex = true;
                break;
            }
            if (!someNonHex) {
                throw new IllegalArgumentException("Unit '" + this.unit + "' is hexadecimal and hence is unacceptable");
            }
        }
    }

    @Override
    public TsonString toStr() {
        return (TsonString)Tson.of(String.valueOf(this.numberValue()));
    }

    @Override
    public TsonNumber toNumber() {
        return this;
    }

    @Override
    public TsonNumberLayout numberLayout() {
        return this.layout;
    }

    @Override
    public String numberSuffix() {
        return this.unit;
    }
}

