/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAlias;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBoolean;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonByte;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonChar;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCustom;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDouble;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonInt;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDate;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalDateTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLocalTime;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonLong;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrix;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonName;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOp;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonRegex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonShort;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.AbstractTsonElement;

public abstract class AbstractNonPrimitiveTsonElement
extends AbstractTsonElement {
    public AbstractNonPrimitiveTsonElement(TsonElementType type) {
        super(type);
    }

    @Override
    protected <T> T throwPrimitive(TsonElementType type) {
        throw new ClassCastException((Object)((Object)this.type()) + " is not a primitive. Cannot cast to " + (Object)((Object)type));
    }

    @Override
    protected <T> T throwNonPrimitive(TsonElementType type) {
        throw new ClassCastException((Object)((Object)this.type()) + " cannot be cast to " + (Object)((Object)type));
    }

    @Override
    public TsonString toStr() {
        return (TsonString)this.throwPrimitive(TsonElementType.DOUBLE_QUOTED_STRING);
    }

    @Override
    public TsonLong toLong() {
        return (TsonLong)this.throwPrimitive(TsonElementType.LONG);
    }

    @Override
    public TsonInt toInt() {
        return (TsonInt)this.throwPrimitive(TsonElementType.INTEGER);
    }

    @Override
    public TsonFloat toFloat() {
        return (TsonFloat)this.throwPrimitive(TsonElementType.FLOAT);
    }

    @Override
    public TsonDouble toDouble() {
        return (TsonDouble)this.throwPrimitive(TsonElementType.DOUBLE);
    }

    @Override
    public TsonShort toShort() {
        return (TsonShort)this.throwPrimitive(TsonElementType.SHORT);
    }

    @Override
    public TsonByte toByte() {
        return (TsonByte)this.throwPrimitive(TsonElementType.BYTE);
    }

    @Override
    public TsonChar toChar() {
        return (TsonChar)this.throwPrimitive(TsonElementType.CHAR);
    }

    @Override
    public TsonBoolean toBoolean() {
        return (TsonBoolean)this.throwPrimitive(TsonElementType.BOOLEAN);
    }

    @Override
    public TsonCustom toCustom() {
        return (TsonCustom)this.throwPrimitive(TsonElementType.CUSTOM);
    }

    @Override
    public TsonName toName() {
        return (TsonName)this.throwPrimitive(TsonElementType.NAME);
    }

    @Override
    public TsonAlias toAlias() {
        return (TsonAlias)this.throwPrimitive(TsonElementType.ALIAS);
    }

    @Override
    public TsonLocalDate toLocalDate() {
        return (TsonLocalDate)this.throwPrimitive(TsonElementType.LOCAL_DATE);
    }

    @Override
    public TsonLocalDateTime toLocalDateTime() {
        return (TsonLocalDateTime)this.throwPrimitive(TsonElementType.LOCAL_DATETIME);
    }

    @Override
    public TsonLocalTime toLocalTime() {
        return (TsonLocalTime)this.throwPrimitive(TsonElementType.LOCAL_TIME);
    }

    @Override
    public TsonRegex toRegex() {
        return (TsonRegex)this.throwPrimitive(TsonElementType.REGEX);
    }

    @Override
    public Boolean booleanObject() {
        return (Boolean)this.throwPrimitive(TsonElementType.BOOLEAN);
    }

    @Override
    public Character charObject() {
        return (Character)this.throwPrimitive(TsonElementType.CHAR);
    }

    @Override
    public Byte byteObject() {
        return (Byte)this.throwPrimitive(TsonElementType.BYTE);
    }

    @Override
    public Long longObject() {
        return (Long)this.throwPrimitive(TsonElementType.LONG);
    }

    @Override
    public Integer intObject() {
        return (Integer)this.throwPrimitive(TsonElementType.INTEGER);
    }

    @Override
    public Short shortObject() {
        return (Short)this.throwPrimitive(TsonElementType.SHORT);
    }

    @Override
    public Float floatObject() {
        return (Float)this.throwPrimitive(TsonElementType.FLOAT);
    }

    @Override
    public Double doubleObject() {
        return (Double)this.throwPrimitive(TsonElementType.DOUBLE);
    }

    @Override
    public float floatValue() {
        return ((Float)this.throwPrimitive(TsonElementType.FLOAT)).floatValue();
    }

    @Override
    public double doubleValue() {
        return (Double)this.throwPrimitive(TsonElementType.DOUBLE);
    }

    @Override
    public byte byteValue() {
        return (Byte)this.throwPrimitive(TsonElementType.BYTE);
    }

    @Override
    public char charValue() {
        return ((Character)this.throwPrimitive(TsonElementType.CHAR)).charValue();
    }

    @Override
    public boolean booleanValue() {
        return (Boolean)this.throwPrimitive(TsonElementType.BOOLEAN);
    }

    @Override
    public int intValue() {
        return (Integer)this.throwPrimitive(TsonElementType.INTEGER);
    }

    @Override
    public long longValue() {
        return (Long)this.throwPrimitive(TsonElementType.LONG);
    }

    @Override
    public short shortValue() {
        return (Short)this.throwPrimitive(TsonElementType.SHORT);
    }

    @Override
    public LocalDate localDateValue() {
        return (LocalDate)this.throwPrimitive(TsonElementType.LOCAL_DATE);
    }

    @Override
    public Instant instantValue() {
        return (Instant)this.throwPrimitive(TsonElementType.INSTANT);
    }

    @Override
    public LocalDateTime localDateTimeValue() {
        return (LocalDateTime)this.throwPrimitive(TsonElementType.LOCAL_DATETIME);
    }

    @Override
    public LocalTime localTimeValue() {
        return (LocalTime)this.throwPrimitive(TsonElementType.LOCAL_TIME);
    }

    @Override
    public Pattern regexValue() {
        return (Pattern)this.throwPrimitive(TsonElementType.REGEX);
    }

    @Override
    public String stringValue() {
        return (String)this.throwPrimitive(TsonElementType.DOUBLE_QUOTED_STRING);
    }

    @Override
    public TsonArray toArray() {
        return (TsonArray)this.throwNonPrimitive(TsonElementType.ARRAY);
    }

    @Override
    public TsonMatrix toMatrix() {
        return (TsonMatrix)this.throwNonPrimitive(TsonElementType.MATRIX);
    }

    @Override
    public TsonObject toObject() {
        return (TsonObject)this.throwNonPrimitive(TsonElementType.OBJECT);
    }

    @Override
    public TsonUplet toUplet() {
        return (TsonUplet)this.throwNonPrimitive(TsonElementType.UPLET);
    }

    @Override
    public TsonPair toPair() {
        return (TsonPair)this.throwNonPrimitive(TsonElementType.PAIR);
    }

    @Override
    public TsonOp toOp() {
        return (TsonOp)this.throwNonPrimitive(TsonElementType.OP);
    }

    @Override
    public boolean visit(TsonDocumentVisitor visitor) {
        return true;
    }

    @Override
    public String toString() {
        return Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(boolean compact) {
        return compact ? Tson.COMPACT_FORMAT.format(this) : Tson.DEFAULT_FORMAT.format(this);
    }

    @Override
    public String toString(TsonFormat format) {
        return format == null ? Tson.DEFAULT_FORMAT.format(this) : format.format(this);
    }
}

