/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Iterator;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUpletBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.AbstractTsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonUpletImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonUpletBuilderImpl
extends AbstractTsonElementBuilder<TsonUpletBuilder>
implements TsonUpletBuilder {
    private String name;
    private ArrayList<TsonElement> elements = new ArrayList();

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isNamed() {
        return this.name != null;
    }

    @Override
    public boolean isBlank() {
        return this.name == null && this.elements.isEmpty();
    }

    @Override
    public TsonUpletBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TsonElementType type() {
        return this.name == null ? TsonElementType.UPLET : TsonElementType.NAMED_UPLET;
    }

    @Override
    public TsonUpletBuilder reset() {
        this.elements.clear();
        return this;
    }

    @Override
    public TsonUpletBuilder addAll(TsonElement[] element) {
        for (TsonElement tsonElement : element) {
            this.add(tsonElement);
        }
        return this;
    }

    @Override
    public TsonUpletBuilder addAll(TsonElementBase[] element) {
        for (TsonElementBase tsonElement : element) {
            this.add(tsonElement);
        }
        return this;
    }

    @Override
    public TsonUpletBuilder addAll(Iterable<? extends TsonElementBase> element) {
        for (TsonElementBase tsonElementBase : element) {
            this.add(tsonElementBase);
        }
        return this;
    }

    @Override
    public TsonUpletBuilder add(TsonElementBase element) {
        this.elements.add(Tson.of(element).build());
        return this;
    }

    @Override
    public Iterator<TsonElement> iterator() {
        return this.elements.iterator();
    }

    @Override
    public TsonUpletBuilder remove(TsonElementBase element) {
        this.elements.remove(Tson.of(element));
        return this;
    }

    @Override
    public TsonElement[] params() {
        return this.elements.toArray(new TsonElement[0]);
    }

    @Override
    public TsonElement param(int index) {
        return this.elements.get(index);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public TsonUpletBuilder removeAll() {
        this.elements.clear();
        return this;
    }

    @Override
    public TsonUpletBuilder addAt(int index, TsonElementBase element) {
        this.elements.add(index, Tson.of(element));
        return this;
    }

    @Override
    public TsonUpletBuilder setAt(int index, TsonElementBase element) {
        this.elements.set(index, Tson.of(element));
        return this;
    }

    @Override
    public TsonUpletBuilder removeAt(int index) {
        this.elements.remove(index);
        return this;
    }

    @Override
    public TsonUplet build() {
        TsonUpletImpl built = new TsonUpletImpl(this.name, TsonUtils.unmodifiableElements(this.elements));
        return (TsonUplet)TsonUtils.decorate(built, this.comments(), this.annotations());
    }

    @Override
    public TsonUpletBuilder merge(TsonElementBase element0) {
        TsonElement element = element0.build();
        this.addAnnotations(element.annotations());
        switch (element.type()) {
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: {
                TsonArray h = element.toArray();
                if (h != null) {
                    this.addAll(h.params());
                }
                return this;
            }
            case OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                TsonObject h = element.toObject();
                if (h != null) {
                    this.addAll(h.params());
                }
                return this;
            }
            case UPLET: 
            case NAMED_UPLET: {
                TsonUplet uplet = element.toUplet();
                if (uplet.isNamed()) {
                    this.name(uplet.name());
                }
                this.addAll(uplet.params());
                return this;
            }
        }
        throw new IllegalArgumentException("Unsupported copy from " + (Object)((Object)element.type()));
    }

    @Override
    public TsonUpletBuilder ensureCapacity(int length) {
        this.elements.ensureCapacity(length);
        return this;
    }
}

