/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBaseListBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObjectBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.AbstractTsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonElementBaseListBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonObjectImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonObjectBuilderImpl
extends AbstractTsonElementBuilder<TsonObjectBuilder>
implements TsonObjectBuilder {
    private TsonElementBaseListBuilder elementsSupport = new TsonElementBaseListBuilderImpl();
    private String name;
    private List<TsonElement> params;

    @Override
    public TsonElementType type() {
        return this.name == null && this.params == null ? TsonElementType.OBJECT : (this.name == null && this.params != null ? TsonElementType.PARAMETRIZED_OBJECT : (this.name != null && this.params == null ? TsonElementType.NAMED_OBJECT : TsonElementType.NAMED_PARAMETRIZED_OBJECT));
    }

    @Override
    public TsonObjectBuilder clear() {
        this.setParametrized(false);
        this.elementsSupport.clear();
        return this;
    }

    @Override
    public Iterator<TsonElement> iterator() {
        return this.elementsSupport.toIterator();
    }

    @Override
    public TsonElementBaseListBuilder content() {
        return this.elementsSupport;
    }

    @Override
    public TsonObjectBuilder add(TsonElementBase key, TsonElementBase value) {
        this.elementsSupport.add(key, value);
        return this;
    }

    @Override
    public List<TsonElement> body() {
        return this.elementsSupport.toList();
    }

    @Override
    public TsonObjectBuilder clearBody() {
        this.elementsSupport.clear();
        return this;
    }

    @Override
    public TsonObjectBuilder add(String key, String value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, int value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, long value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, float value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, double value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, byte value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, short value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, char value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, Enum value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, boolean value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder add(String key, TsonElementBase value) {
        this.elementsSupport.add(key, value);
        return this;
    }

    @Override
    public TsonObjectBuilder set(TsonElementBase key, TsonElementBase value) {
        this.elementsSupport.set(key, value);
        return this;
    }

    @Override
    public TsonObjectBuilder set(String key, String value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, int value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, long value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, float value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, double value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, byte value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, short value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, char value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, Enum value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, boolean value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonObjectBuilder set(String key, TsonElementBase value) {
        this.elementsSupport.set(key, value);
        return this;
    }

    @Override
    public TsonObjectBuilder add(TsonElementBase element) {
        this.elementsSupport.add(element);
        return this;
    }

    @Override
    public TsonObjectBuilder remove(TsonElementBase element) {
        this.elementsSupport.remove(element);
        return this;
    }

    @Override
    public TsonObjectBuilder remove(String name) {
        this.elementsSupport.remove(name);
        return this;
    }

    @Override
    public TsonObjectBuilder addAt(int index, TsonElementBase element) {
        this.elementsSupport.addAt(index, element);
        return this;
    }

    @Override
    public TsonObjectBuilder removeAt(int index) {
        this.elementsSupport.removeAt(index);
        return this;
    }

    @Override
    public TsonObjectBuilder setAt(int index, TsonElementBase element) {
        this.elementsSupport.setAt(index, element);
        return this;
    }

    @Override
    public List<TsonElement> all() {
        return this.elementsSupport.toList();
    }

    @Override
    public TsonObject build() {
        TsonObjectImpl built = new TsonObjectImpl(this.name, this.params == null ? null : new TsonElementListImpl(this.params), TsonUtils.unmodifiableElements(this.elementsSupport.toList()));
        return (TsonObject)TsonUtils.decorate(built, this.comments(), this.annotations());
    }

    @Override
    public TsonObjectBuilder addAll(TsonElement[] elements) {
        this.elementsSupport.addAll(elements);
        return this;
    }

    @Override
    public TsonObjectBuilder addAll(TsonElementBase[] elements) {
        this.elementsSupport.addAll(elements);
        return this;
    }

    @Override
    public TsonObjectBuilder addAll(Iterable<? extends TsonElementBase> elements) {
        this.elementsSupport.addAll(elements);
        return this;
    }

    @Override
    public boolean iParametrized() {
        return this.params != null;
    }

    @Override
    public TsonObjectBuilder setParametrized(boolean parametrized) {
        if (parametrized) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
        } else {
            this.params = null;
        }
        return this;
    }

    @Override
    public List<TsonElement> params() {
        return this.params;
    }

    @Override
    public int paramsCount() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public TsonObjectBuilder clearParams() {
        if (this.params != null) {
            this.params.clear();
        }
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TsonObjectBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TsonObjectBuilder addParam(TsonElementBase element) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
            this.params.add(Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonObjectBuilder removeParam(TsonElementBase element) {
        if (element != null && this.params != null) {
            this.params.remove(Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonObjectBuilder addParam(TsonElementBase element, int index) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
            this.params.add(index, Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonObjectBuilder removeParamAt(int index) {
        if (this.params != null) {
            this.params.remove(index);
        }
        return this;
    }

    @Override
    public TsonObjectBuilder addParams(TsonElement[] element) {
        if (element != null) {
            for (TsonElement tsonElement : element) {
                this.addParam(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonObjectBuilder addParams(TsonElementBase[] element) {
        if (element != null) {
            for (TsonElementBase tsonElement : element) {
                this.addParam(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonObjectBuilder addParams(Iterable<? extends TsonElementBase> element) {
        if (element != null) {
            for (TsonElementBase tsonElementBase : element) {
                this.addParam(tsonElementBase);
            }
        }
        return this;
    }

    @Override
    public TsonObjectBuilder merge(TsonElementBase element) {
        TsonElement e = Tson.of(element);
        this.addAnnotations(e.annotations());
        switch (e.type()) {
            case UPLET: 
            case NAMED_UPLET: {
                TsonUplet uplet = e.toUplet();
                if (uplet.isNamed()) {
                    this.name(uplet.name());
                }
                this.addParams(uplet);
                break;
            }
            case NAME: {
                this.name(e.toName().value());
                break;
            }
            case OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                TsonObject h = e.toObject();
                this.name(h.name());
                this.addParams(h.params());
                this.addAll(e.toObject().body());
                break;
            }
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: {
                TsonArray h = e.toArray();
                this.name(h.name());
                this.addParams(h.params());
                this.addAll(e.toArray().body());
                break;
            }
        }
        return this;
    }

    @Override
    public TsonObjectBuilder ensureCapacity(int length) {
        this.elementsSupport.ensureCapacity(length);
        return this;
    }
}

