/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBaseList;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBaseListBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonElementBaseListImpl;

public class TsonElementBaseListBuilderImpl
implements TsonElementBaseListBuilder {
    private ArrayList<TsonElementBase> elements = new ArrayList();

    public TsonElementBaseListBuilderImpl() {
    }

    public TsonElementBaseListBuilderImpl(List<TsonElementBase> elements) {
        this.addAll(elements);
    }

    @Override
    public TsonElementBaseListBuilder set(String key, TsonElementBase value) {
        return this.set(Tson.ofString(key), Tson.ofElementBase(value));
    }

    @Override
    public TsonElementBaseListBuilder set(TsonElementBase key, TsonElementBase value) {
        key = Tson.of(key);
        value = Tson.of(value);
        for (int i = 0; i < this.elements.size(); ++i) {
            TsonElementBase e = this.elements.get(i);
            if (e.type() != TsonElementType.PAIR) continue;
            TsonElement k = ((TsonPair)e).key();
            if (key == null || key.type() == TsonElementType.NULL) {
                if (k.type() != TsonElementType.NULL) continue;
                this.elements.set(i, Tson.ofPair(key, value));
                return this;
            }
            if (!k.build().equals(key.build())) continue;
            this.elements.set(i, Tson.ofPair(key, value));
            return this;
        }
        this.add(Tson.ofPair(key, value));
        return this;
    }

    @Override
    public TsonElementBaseListBuilder clear() {
        this.elements.clear();
        return this;
    }

    @Override
    public TsonElementBaseListBuilder add(TsonElementBase key, TsonElementBase value) {
        return this.add(Tson.ofPair(key, value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, TsonElementBase value) {
        return this.add(Tson.ofPair(key, value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, String value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, int value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, long value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, float value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, double value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, byte value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, short value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, char value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, Enum value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(String key, boolean value) {
        return this.add(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, String value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, int value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, long value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, float value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, double value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, byte value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, short value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, char value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, Enum value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder set(String key, boolean value) {
        return this.set(key, (TsonElementBase)Tson.of(value));
    }

    @Override
    public TsonElementBaseListBuilder add(TsonElementBase element) {
        this.elements.add(Tson.of(element));
        return this;
    }

    @Override
    public TsonElementBaseListBuilder remove(TsonElementBase element) {
        this.elements.remove(Tson.of(element));
        return this;
    }

    @Override
    public TsonElementBaseListBuilder remove(String name) {
        this.elements.remove(Tson.ofString(name));
        return this;
    }

    @Override
    public TsonElementBaseListBuilder addAt(int index, TsonElementBase element) {
        this.elements.add(index, Tson.of(element));
        return this;
    }

    @Override
    public TsonElementBaseListBuilder setAt(int index, TsonElementBase element) {
        this.elements.set(index, Tson.of(element));
        return this;
    }

    @Override
    public TsonElementBaseListBuilder removeAt(int index) {
        this.elements.remove(index);
        return this;
    }

    @Override
    public TsonElementBaseList build() {
        return new TsonElementBaseListImpl(this.elements);
    }

    @Override
    public TsonElementBaseListBuilder addAll(TsonElement[] elements) {
        if (elements != null) {
            for (TsonElement element : elements) {
                if (element == null) continue;
                this.elements.add(element);
            }
        }
        return this;
    }

    @Override
    public TsonElementBaseListBuilder addAll(TsonElementBase[] elements) {
        if (elements != null) {
            for (TsonElementBase element : elements) {
                if (element == null) continue;
                this.elements.add(element);
            }
        }
        return this;
    }

    @Override
    public TsonElementBaseListBuilder addAll(Iterable<? extends TsonElementBase> elements) {
        if (elements != null) {
            for (TsonElementBase tsonElementBase : elements) {
                if (tsonElementBase == null) continue;
                this.elements.add(tsonElementBase);
            }
        }
        return this;
    }

    @Override
    public TsonElementBase getAt(int index) {
        return this.elements.get(index);
    }

    @Override
    public TsonElementBase get(String name) {
        return this.get(name == null ? null : Tson.ofString(name));
    }

    @Override
    public TsonElementBase get(TsonElementBase name) {
        TsonElement vn = (name == null ? Tson.ofNull() : name).build();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                if (!Objects.equals(element1.key().build(), vn)) continue;
                return element1.value();
            }
            if (!Objects.equals(element.build(), vn)) continue;
            return element;
        }
        return null;
    }

    @Override
    public List<TsonElementBase> get2(String name) {
        return this.get2(name == null ? null : Tson.ofString(name));
    }

    @Override
    public List<TsonElementBase> get2(TsonElementBase name) {
        TsonElement vn = (name == null ? Tson.ofNull() : name).build();
        ArrayList<TsonElementBase> all = new ArrayList<TsonElementBase>();
        LinkedHashMap m = new LinkedHashMap();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                if (!Objects.equals(element1.key().build(), vn)) continue;
                all.add(element1.value());
                continue;
            }
            if (!Objects.equals(element.build(), vn)) continue;
            all.add(element);
        }
        return all;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public Map<TsonElementBase, TsonElementBase> toBaseMap() {
        LinkedHashMap<TsonElementBase, TsonElementBase> m = new LinkedHashMap<TsonElementBase, TsonElementBase>();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.put(element1.key(), element1.value());
                continue;
            }
            m.put(element, element);
        }
        return m;
    }

    @Override
    public Map<TsonElement, TsonElement> toMap() {
        LinkedHashMap<TsonElement, TsonElement> m = new LinkedHashMap<TsonElement, TsonElement>();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.put(element1.key(), element1.value());
                continue;
            }
            m.put(element.build(), element.build());
        }
        return m;
    }

    @Override
    public Map<TsonElementBase, List<TsonElementBase>> toMultiBaseMap() {
        LinkedHashMap<TsonElementBase, List<TsonElementBase>> m = new LinkedHashMap<TsonElementBase, List<TsonElementBase>>();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.computeIfAbsent(element1.key(), k -> new ArrayList()).add(element1.value());
                continue;
            }
            m.computeIfAbsent(element, k -> new ArrayList()).add(element);
        }
        return m;
    }

    @Override
    public Map<TsonElement, List<TsonElement>> toMultiMap() {
        LinkedHashMap<TsonElement, List<TsonElement>> m = new LinkedHashMap<TsonElement, List<TsonElement>>();
        for (TsonElementBase element : this.elements) {
            if (element instanceof TsonPair) {
                TsonPair element1 = (TsonPair)element;
                m.computeIfAbsent(element1.key(), k -> new ArrayList()).add(element1.value());
                continue;
            }
            m.computeIfAbsent(element.build(), k -> new ArrayList()).add(element.build());
        }
        return m;
    }

    @Override
    public List<TsonElementBase> toBaseList() {
        return new ArrayList<TsonElementBase>(this.elements);
    }

    @Override
    public List<TsonElement> toList() {
        return this.elements.stream().map(x -> x.build()).collect(Collectors.toList());
    }

    @Override
    public Iterable<TsonElement> toIterable() {
        return this::toIterator;
    }

    @Override
    public Iterator<TsonElement> toIterator() {
        final Iterator<TsonElementBase> i = this.elements.iterator();
        return new Iterator<TsonElement>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public TsonElement next() {
                return ((TsonElementBase)i.next()).build();
            }
        };
    }

    @Override
    public Iterable<TsonElementBase> toBaseIterable() {
        return () -> this.elements.iterator();
    }

    @Override
    public Iterator<TsonElementBase> toBaseIterator() {
        return this.elements.iterator();
    }

    @Override
    public TsonElementBaseListBuilder ensureCapacity(int length) {
        this.elements.ensureCapacity(length);
        return this;
    }
}

