/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonArrayBuilderSupport {
    private ArrayList<List<TsonElement>> rows = new ArrayList();
    private ArrayList<TsonElement> current = new ArrayList();
    private boolean multiRows = false;

    public void reset() {
        this.rows.clear();
        this.current.clear();
        this.multiRows = false;
    }

    public Iterator<TsonElement> iterator() {
        return this.getRows().iterator();
    }

    public void add(TsonElementBase element) {
        TsonElement e = Tson.of(element).build();
        this.current.add(e);
    }

    public void remove(TsonElementBase element) {
        TsonElement e = Tson.of(element).build();
        if (!this.current.remove(e)) {
            // empty if block
        }
    }

    public void add(TsonElementBase element, int index) {
        this.current.add(index, Tson.of(element).build());
    }

    public void removeAt(int index) {
        this.current.remove(index);
    }

    public void removeAll() {
        this.reset();
    }

    public List<TsonElement> getRows() {
        return this.buildElements();
    }

    public void addAll(TsonElement[] element) {
        for (TsonElement tsonElement : element) {
            this.add(tsonElement);
        }
    }

    public void addAll(TsonElementBase[] element) {
        for (TsonElementBase tsonElement : element) {
            this.add(tsonElement);
        }
    }

    public void addAll(Iterable<? extends TsonElementBase> element) {
        for (TsonElementBase tsonElementBase : element) {
            this.add(tsonElementBase);
        }
    }

    public void newRow() {
        this.multiRows = true;
        this.rows.add(new ArrayList<TsonElement>(this.current));
        this.current.clear();
    }

    public List<TsonElement> buildElements() {
        if (this.multiRows) {
            ArrayList<TsonElement> e = new ArrayList<TsonElement>();
            for (List<TsonElement> row : this.rows) {
                e.add(TsonUtils.toArray(row));
            }
            e.add(TsonUtils.toArray(this.current));
            return e;
        }
        return this.current;
    }

    public void ensureElementsCapacity(int length) {
        this.rows.ensureCapacity(length);
        this.current.ensureCapacity(length);
    }
}

