/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArrayBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.AbstractTsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonArrayBuilderSupport;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonArrayImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonElementListImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.UnmodifiableArrayList;

public class TsonArrayBuilderImpl
extends AbstractTsonElementBuilder<TsonArrayBuilder>
implements TsonArrayBuilder {
    private TsonArrayBuilderSupport elementsSupport = new TsonArrayBuilderSupport();
    private String name;
    private List<TsonElement> params;

    @Override
    public TsonElementType type() {
        return this.name == null && this.params == null ? TsonElementType.ARRAY : (this.name == null && this.params != null ? TsonElementType.PARAMETRIZED_ARRAY : (this.name != null && this.params == null ? TsonElementType.NAMED_ARRAY : TsonElementType.NAMED_PARAMETRIZED_ARRAY));
    }

    @Override
    public Iterator<TsonElement> iterator() {
        return this.elementsSupport.iterator();
    }

    @Override
    public List<TsonElement> all() {
        return this.getAll();
    }

    @Override
    public List<TsonElement> getAll() {
        return this.elementsSupport.getRows();
    }

    @Override
    public TsonArrayBuilder removeAll() {
        this.elementsSupport.removeAll();
        return this;
    }

    @Override
    public TsonArrayBuilder reset() {
        this.elementsSupport.reset();
        this.name = null;
        this.params = null;
        return this;
    }

    @Override
    public TsonArrayBuilder add(TsonElementBase element) {
        this.elementsSupport.add(element);
        return this;
    }

    @Override
    public TsonArrayBuilder remove(TsonElementBase element) {
        this.elementsSupport.remove(element);
        return this;
    }

    @Override
    public TsonArrayBuilder add(TsonElementBase element, int index) {
        this.elementsSupport.add(element, index);
        return this;
    }

    @Override
    public TsonArrayBuilder removeAt(int index) {
        this.elementsSupport.removeAt(index);
        return this;
    }

    @Override
    public TsonArray build() {
        TsonArrayImpl built = new TsonArrayImpl(this.name, this.params == null ? null : new TsonElementListImpl(this.params), UnmodifiableArrayList.ofCopy(this.elementsSupport.getRows().toArray(new TsonElement[0])));
        return (TsonArray)TsonUtils.decorate(built, this.comments(), this.annotations());
    }

    @Override
    public TsonArrayBuilder addAll(TsonElement[] elements) {
        this.elementsSupport.addAll(elements);
        return this;
    }

    @Override
    public TsonArrayBuilder addAll(TsonElementBase[] elements) {
        this.elementsSupport.addAll(elements);
        return this;
    }

    @Override
    public TsonArrayBuilder addAll(Iterable<? extends TsonElementBase> elements) {
        this.elementsSupport.addAll(elements);
        return this;
    }

    @Override
    public TsonArrayBuilder ensureCapacity(int length) {
        this.elementsSupport.ensureElementsCapacity(length);
        return this;
    }

    @Override
    public TsonArrayBuilder merge(TsonElementBase element) {
        TsonElement e = Tson.of(element);
        this.addAnnotations(e.annotations());
        switch (e.type()) {
            case UPLET: 
            case NAMED_UPLET: {
                TsonUplet uplet = e.toUplet();
                if (uplet.isNamed()) {
                    this.name(uplet.name());
                }
                this.addParams(uplet);
                break;
            }
            case NAME: {
                this.name(e.toName().value());
                break;
            }
            case OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                TsonObject h = e.toObject();
                this.name(h.name());
                this.addParams(h.params());
                this.addAll(e.toObject().body());
                break;
            }
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: {
                TsonArray h = e.toArray();
                this.name(h.name());
                this.addParams(h.params());
                this.addAll(e.toArray().body());
                break;
            }
        }
        return this;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public TsonArrayBuilder setParametrized(boolean parametrized) {
        if (parametrized) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
        } else {
            this.params = null;
        }
        return this;
    }

    @Override
    public List<TsonElement> params() {
        return this.params;
    }

    @Override
    public int paramsCount() {
        return this.params == null ? 0 : this.params.size();
    }

    @Override
    public TsonArrayBuilder clearParams() {
        if (this.params != null) {
            this.params.clear();
        }
        return this;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public TsonArrayBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TsonArrayBuilder addParam(TsonElementBase element) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
            this.params.add(Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonArrayBuilder removeParam(TsonElementBase element) {
        if (element != null && this.params != null) {
            this.params.remove(Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonArrayBuilder addParam(TsonElementBase element, int index) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList<TsonElement>();
            }
            this.params.add(index, Tson.of(element).build());
        }
        return this;
    }

    @Override
    public TsonArrayBuilder removeParamAt(int index) {
        if (this.params != null) {
            this.params.remove(index);
        }
        return this;
    }

    @Override
    public TsonArrayBuilder addParams(TsonElement[] element) {
        if (element != null) {
            for (TsonElement tsonElement : element) {
                this.addParam(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonArrayBuilder addParams(TsonElementBase[] element) {
        if (element != null) {
            for (TsonElementBase tsonElement : element) {
                this.addParam(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonArrayBuilder addParams(Iterable<? extends TsonElementBase> element) {
        if (element != null) {
            for (TsonElementBase tsonElementBase : element) {
                this.addParam(tsonElementBase);
            }
        }
        return this;
    }

    @Override
    public List<TsonElement> body() {
        return this.elementsSupport.buildElements();
    }

    @Override
    public TsonArrayBuilder clearBody() {
        this.elementsSupport.reset();
        return this;
    }
}

