/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotationBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonAnnotationImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.util.TsonUtils;

public class TsonAnnotationBuilderImpl
implements TsonAnnotationBuilder {
    private String name;
    private ArrayList<TsonElement> params;

    @Override
    public TsonAnnotationBuilder reset() {
        this.name = null;
        this.params = null;
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String name() {
        return this.getName();
    }

    @Override
    public List<TsonElement> all() {
        return this.params();
    }

    @Override
    public TsonElement get(int index) {
        return this.params.get(index);
    }

    @Override
    public TsonAnnotationBuilder name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public TsonAnnotationBuilder with(TsonElementBase ... elements) {
        return this.addAll(elements);
    }

    @Override
    public TsonAnnotationBuilder add(TsonElementBase element) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            this.params.add(Tson.of(element));
        }
        return this;
    }

    @Override
    public TsonAnnotationBuilder remove(TsonElementBase element) {
        if (this.params != null) {
            this.params.remove(Tson.of(element));
        }
        return this;
    }

    @Override
    public TsonAnnotationBuilder add(TsonElementBase element, int index) {
        if (element != null) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
            this.params.add(index, Tson.of(element));
        }
        return this;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public List<TsonElement> params() {
        return this.params == null ? null : Collections.unmodifiableList(this.params);
    }

    @Override
    public TsonAnnotationBuilder removeAt(int index) {
        if (this.params != null) {
            this.params.remove(index);
        }
        return this;
    }

    @Override
    public TsonAnnotationBuilder addAll(TsonElement[] element) {
        if (this.params != null) {
            for (TsonElement tsonElement : element) {
                this.add(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonAnnotationBuilder addAll(TsonElementBase[] element) {
        if (this.params != null) {
            for (TsonElementBase tsonElement : element) {
                this.add(tsonElement);
            }
        }
        return this;
    }

    @Override
    public TsonAnnotationBuilder addAll(Iterable<? extends TsonElementBase> element) {
        if (element != null) {
            for (TsonElementBase tsonElementBase : element) {
                this.add(tsonElementBase);
            }
        }
        return this;
    }

    @Override
    public TsonAnnotationBuilder setParametrized(boolean parametrized) {
        if (parametrized) {
            if (this.params == null) {
                this.params = new ArrayList();
            }
        } else {
            this.params = null;
        }
        return this;
    }

    @Override
    public boolean isParametrized() {
        return this.params != null;
    }

    @Override
    public TsonAnnotationBuilder merge(TsonElementBase element0) {
        TsonElement element = Tson.of(element0);
        switch (element.type()) {
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: {
                TsonArray h = element.toArray();
                if (h != null) {
                    this.addAll(h.params());
                }
                return this;
            }
            case OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: {
                TsonObject h = element.toObject();
                if (h != null) {
                    this.addAll(h.params());
                }
                return this;
            }
            case UPLET: 
            case NAMED_UPLET: {
                this.addAll(element.toUplet().params());
                return this;
            }
        }
        throw new IllegalArgumentException("Unsupported copy from " + (Object)((Object)element.type()));
    }

    @Override
    public TsonAnnotationBuilder merge(TsonAnnotation element) {
        this.name = element.name().orNull();
        List<TsonElement> params1 = element.params();
        if (params1 != null) {
            this.addAll(params1);
        }
        return this;
    }

    @Override
    public TsonAnnotation build() {
        boolean blank = TsonUtils.isBlank(this.name);
        if (!blank && !TsonUtils.isValidIdentifier(this.name)) {
            throw new IllegalArgumentException("Invalid function annotation '" + this.name + "'");
        }
        return new TsonAnnotationImpl(blank ? null : this.name, this.params == null ? null : TsonUtils.unmodifiableElements(this.params));
    }

    @Override
    public TsonAnnotationBuilder ensureCapacity(int length) {
        this.params.ensureCapacity(length);
        return this;
    }
}

