/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArrayBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObjectBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUpletBuilder;

public abstract class AbstractTsonElementBuilder<T extends TsonElementBuilder>
implements TsonElementBuilder {
    private TsonComments comments;
    private final List<TsonAnnotation> annotations = new ArrayList<TsonAnnotation>();

    @Override
    public TsonComments comments() {
        return this.comments;
    }

    @Override
    public List<TsonAnnotation> annotations() {
        return Collections.unmodifiableList(this.annotations);
    }

    public T setComments(TsonComments comments) {
        if (comments != null && comments.isEmpty()) {
            comments = null;
        }
        this.comments = comments;
        return (T)this;
    }

    public T setAnnotations(TsonAnnotation[] annotations) {
        this.annotations.clear();
        this.addAnnotations(annotations);
        return (T)this;
    }

    public T addAnnotations(TsonAnnotation ... annotations) {
        for (TsonAnnotation annotation : annotations) {
            this.addAnnotation(annotation);
        }
        return (T)this;
    }

    public T addAnnotations(Collection<TsonAnnotation> annotations) {
        if (annotations != null) {
            this.annotations.addAll(annotations);
        }
        return (T)this;
    }

    public T addAnnotation(TsonAnnotation annotation) {
        if (annotation != null) {
            this.annotations.add(annotation);
        }
        return (T)this;
    }

    public T addAnnotation(String name, TsonElementBase ... elements) {
        return this.addAnnotation(Tson.ofAnnotation(name, elements));
    }

    public T removeAnnotationAt(int index) {
        this.annotations.remove(index);
        return (T)this;
    }

    public T annotation(String name, TsonElementBase ... elements) {
        return this.addAnnotation(name, elements);
    }

    public T comments(TsonComments comments) {
        return this.setComments(comments);
    }

    @Override
    public String toString() {
        return this.build().toString();
    }

    @Override
    public String toString(boolean compact) {
        return this.build().toString(compact);
    }

    @Override
    public String toString(TsonFormat format) {
        return this.build().toString(format);
    }

    public T clearAnnotations() {
        this.annotations.clear();
        return (T)this;
    }

    @Override
    public TsonArrayBuilder toArray() {
        return (TsonArrayBuilder)((Object)this);
    }

    @Override
    public TsonObjectBuilder toObject() {
        return (TsonObjectBuilder)((Object)this);
    }

    @Override
    public TsonUpletBuilder toUplet() {
        return (TsonUpletBuilder)((Object)this);
    }

    @Override
    public TsonElementBuilder anchor(String name) {
        return this.addAnnotation(null, Tson.ofName(name));
    }
}

