/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.CharStreamCodeSupport;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.Tson;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotationBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArrayBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBinaryStream;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBinaryStreamBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocument;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeaderBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDoubleComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementsFactory;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloatComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormatBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrixBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObjectBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOpBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPairBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParseException;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonProcessor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonString;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUpletBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.TsonProcessorImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonAnnotationBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonArrayBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonDocumentBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonDocumentHeaderBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonMatrixBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonObjectBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonOpBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPairBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonPrimitiveElementBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonUpletBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.InputStreamTsonBinaryStreamSource;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonAliasImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBigComplexImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBigDecimalImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBigIntImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBinaryStreamImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBinaryStreamSource;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonBooleanImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonByteImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonCharImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonCharStreamImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonCharStreamSource;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonCustomImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonDoubleComplexImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonDoubleImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonFloatComplexImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonFloatImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonInstantImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonIntImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonLocalDateImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonLocalDateTimeImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonLocalTimeImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonLongImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonNameImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonNullImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonRegexImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonShortImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonStopWordCharStreamImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonStringImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.format.TsonFormatImplBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.CharStreamCodeSupports;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.TsonNumberHelper;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.TsonParserUtils;

public class TsonElementsFactoryImpl
implements TsonElementsFactory {
    @Override
    public TsonElement parseString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return TsonParserUtils.parseRawString(value);
    }

    @Override
    public TsonElement ofDoubleQuotedString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStringImpl(TsonElementType.DOUBLE_QUOTED_STRING, value, value);
    }

    @Override
    public TsonElement ofSingleQuotedString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStringImpl(TsonElementType.SINGLE_QUOTED_STRING, value, value);
    }

    @Override
    public TsonElement ofAntiQuotedString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStringImpl(TsonElementType.ANTI_QUOTED_STRING, value, value);
    }

    @Override
    public TsonElement ofTripleDoubleQuotedString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStringImpl(TsonElementType.TRIPLE_DOUBLE_QUOTED_STRING, value, value);
    }

    @Override
    public TsonElement ofTripleSingleQuotedString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStringImpl(TsonElementType.TRIPLE_SINGLE_QUOTED_STRING, value, value);
    }

    @Override
    public TsonElement ofTripleAntiQuotedString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStringImpl(TsonElementType.TRIPLE_ANTI_QUOTED_STRING, value, value);
    }

    @Override
    public TsonElement ofLineString(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStringImpl(TsonElementType.LINE_STRING, value, value);
    }

    @Override
    public TsonElement ofElement(TsonElementBase value) {
        if (value == null) {
            return this.ofNull();
        }
        return value.build();
    }

    @Override
    public TsonElementBase ofElementBase(TsonElementBase value) {
        if (value == null) {
            return this.ofNull();
        }
        return value;
    }

    @Override
    public TsonElement ofInstant(Instant value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonInstantImpl(value);
    }

    @Override
    public TsonElement ofLocalDatetime(Instant value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonLocalDateTimeImpl(value.atZone(ZoneId.systemDefault()).toLocalDateTime());
    }

    @Override
    public TsonElement ofLocalDatetime(LocalDateTime value) {
        return new TsonLocalDateTimeImpl(value);
    }

    @Override
    public TsonElement ofLocalDatetime(Date value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofLocalDatetime(Instant.ofEpochMilli(value.getTime()));
    }

    @Override
    public TsonElement ofLocalDate(LocalDate value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonLocalDateImpl(value);
    }

    @Override
    public TsonElement ofLocalTime(LocalTime value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonLocalTimeImpl(value);
    }

    @Override
    public TsonElement ofLocalTime(Time value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonLocalTimeImpl(value.toLocalTime());
    }

    @Override
    public TsonElement ofLocalDate(java.sql.Date value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonLocalDateImpl(value.toLocalDate());
    }

    @Override
    public TsonElement ofRegex(Pattern value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonRegexImpl(value);
    }

    @Override
    public TsonElement ofRegex(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonRegexImpl(Pattern.compile(value));
    }

    @Override
    public TsonElement ofChar(char value) {
        return new TsonCharImpl(value);
    }

    @Override
    public TsonElement ofInt(int value) {
        return this.ofInt(value, TsonNumberLayout.DECIMAL);
    }

    @Override
    public TsonElement ofInt(int value, TsonNumberLayout layout) {
        return new TsonIntImpl(value, layout, null);
    }

    @Override
    public TsonElement ofInt(int value, TsonNumberLayout layout, String unit) {
        return new TsonIntImpl(value, layout, unit);
    }

    @Override
    public TsonElement ofNumber(Number value, TsonNumberLayout layout, String unit) {
        if (value == null) {
            return this.ofNull();
        }
        switch (TsonElementsFactoryImpl.resolveType(value)) {
            case BYTE: {
                return this.ofByte(value.byteValue(), layout, unit);
            }
            case SHORT: {
                return this.ofShort(value.shortValue(), layout, unit);
            }
            case INTEGER: {
                return this.ofInt(value.intValue(), layout, unit);
            }
            case LONG: {
                return this.ofLong(value.longValue(), layout, unit);
            }
            case FLOAT: {
                return this.ofFloat(value.floatValue(), unit);
            }
            case DOUBLE: {
                return this.ofDouble(value.doubleValue(), unit);
            }
            case FLOAT_COMPLEX: {
                TsonFloatComplex fc = (TsonFloatComplex)((Object)value);
                return this.ofFloatComplex(fc.real(), fc.imag(), unit);
            }
            case DOUBLE_COMPLEX: {
                TsonDoubleComplex fc = (TsonDoubleComplex)((Object)value);
                return this.ofDoubleComplex(fc.real(), fc.imag(), unit);
            }
            case BIG_COMPLEX: {
                TsonBigComplex fc = (TsonBigComplex)((Object)value);
                return this.ofBigComplex(fc.real(), fc.imag(), unit);
            }
        }
        throw new IllegalArgumentException("unsupported number type: " + value.getClass().getName());
    }

    @Override
    public TsonElement ofLong(long value) {
        return this.ofLong(value, TsonNumberLayout.DECIMAL);
    }

    @Override
    public TsonElement ofLong(long value, TsonNumberLayout layout) {
        return new TsonLongImpl(value, layout, null);
    }

    @Override
    public TsonElement ofLong(long value, TsonNumberLayout layout, String unit) {
        return new TsonLongImpl(value, layout, unit);
    }

    @Override
    public TsonElement ofByte(byte value, TsonNumberLayout layout) {
        return new TsonByteImpl(value, layout, null);
    }

    @Override
    public TsonElement ofByte(byte value, TsonNumberLayout layout, String unit) {
        return new TsonByteImpl(value, layout, unit);
    }

    @Override
    public TsonElement ofByte(byte value) {
        return this.ofByte(value, TsonNumberLayout.DECIMAL);
    }

    @Override
    public TsonElement ofShort(short value, TsonNumberLayout layout) {
        return new TsonShortImpl(value, layout, null);
    }

    @Override
    public TsonElement ofShort(short value, TsonNumberLayout layout, String unit) {
        return new TsonShortImpl(value, layout, unit);
    }

    @Override
    public TsonElement ofShort(short value) {
        return this.ofShort(value, TsonNumberLayout.DECIMAL);
    }

    @Override
    public TsonElement ofFloat(float value) {
        return new TsonFloatImpl(value, null);
    }

    @Override
    public TsonElement ofFloat(float value, String unit) {
        return new TsonFloatImpl(value, unit);
    }

    @Override
    public TsonElement ofBigInt(BigInteger value) {
        return this.ofBigInt(value, TsonNumberLayout.DECIMAL);
    }

    @Override
    public TsonElement ofBigInt(BigInteger value, TsonNumberLayout layout) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBigIntImpl(value, layout, null);
    }

    @Override
    public TsonElement ofBigInt(BigInteger value, TsonNumberLayout layout, String unit) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBigIntImpl(value, layout, unit);
    }

    @Override
    public TsonElement ofBigDecimal(BigDecimal value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBigDecimalImpl(value, null);
    }

    @Override
    public TsonElement ofBigDecimal(BigDecimal value, String unit) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBigDecimalImpl(value, unit);
    }

    @Override
    public TsonElement ofBigComplex(BigDecimal real, BigDecimal imag) {
        if (real == null && imag == null) {
            return this.ofNull();
        }
        if (real == null || imag == null) {
            throw new IllegalArgumentException("Null real or imag");
        }
        return new TsonBigComplexImpl(real, imag, null);
    }

    @Override
    public TsonElement ofBigComplex(BigDecimal real, BigDecimal imag, String unit) {
        if (real == null && imag == null) {
            return this.ofNull();
        }
        if (real == null || imag == null) {
            throw new IllegalArgumentException("Null real or imag");
        }
        return new TsonBigComplexImpl(real, imag, unit);
    }

    @Override
    public TsonElement ofFloatComplex(float real, float imag) {
        return new TsonFloatComplexImpl(real, imag, null);
    }

    @Override
    public TsonElement ofFloatComplex(float real, float imag, String unit) {
        return new TsonFloatComplexImpl(real, imag, unit);
    }

    @Override
    public TsonElement ofDoubleComplex(double real, double imag) {
        return new TsonDoubleComplexImpl(real, imag, null);
    }

    @Override
    public TsonElement ofDoubleComplex(double real, double imag, String unit) {
        return new TsonDoubleComplexImpl(real, imag, unit);
    }

    @Override
    public TsonElement ofDouble(double value) {
        return new TsonDoubleImpl(value, null);
    }

    @Override
    public TsonElement ofDouble(double value, String unit) {
        return new TsonDoubleImpl(value, unit);
    }

    @Override
    public TsonElement ofName(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonNameImpl(value);
    }

    @Override
    public TsonElement ofAlias(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonAliasImpl(value);
    }

    @Override
    public TsonOpBuilder ofOpBuilder() {
        return new TsonOpBuilderImpl();
    }

    @Override
    public TsonElement of(boolean value) {
        return this.ofBoolean(value);
    }

    @Override
    public TsonElement of(char value) {
        return this.ofChar(value);
    }

    @Override
    public TsonElement of(byte value) {
        return this.ofByte(value);
    }

    @Override
    public TsonElement of(short value) {
        return this.ofShort(value);
    }

    @Override
    public TsonElement of(int value) {
        return this.ofInt(value);
    }

    @Override
    public TsonElement of(long value) {
        return this.ofLong(value);
    }

    @Override
    public TsonElement of(float value) {
        return this.ofFloat(value);
    }

    @Override
    public TsonElement of(double value) {
        return this.ofDouble(value);
    }

    @Override
    public TsonElement of(BigInteger value) {
        return this.ofBigInt(value);
    }

    @Override
    public TsonElement of(BigDecimal value) {
        return this.ofBigDecimal(value);
    }

    @Override
    public TsonElement of(byte[] value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofBinStream(value);
    }

    @Override
    public TsonElement of(InputStream value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofBinStream(value);
    }

    @Override
    public TsonElement ofBinStream(byte[] value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBinaryStreamImpl(TsonBinaryStreamSource.of(value));
    }

    @Override
    public TsonElement ofBinStream(InputStream value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBinaryStreamImpl(TsonBinaryStreamSource.of(value));
    }

    @Override
    public TsonElement ofBinStream(File value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBinaryStreamImpl(TsonBinaryStreamSource.of(value));
    }

    @Override
    public TsonElement ofBinStream(Path value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonBinaryStreamImpl(TsonBinaryStreamSource.of(value));
    }

    @Override
    public TsonElement ofCharStream(char[] value, String type) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), type);
    }

    @Override
    public TsonElement ofCharStream(Reader value, String type) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), type);
    }

    @Override
    public TsonElement ofCharStream(File value, String type) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), type);
    }

    @Override
    public TsonElement ofCharStream(String value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), "");
    }

    @Override
    public TsonElement ofCharStream(char[] value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), "");
    }

    @Override
    public TsonElement ofCharStream(Reader value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), "");
    }

    @Override
    public TsonElement ofCharStream(File value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), "");
    }

    @Override
    public TsonElement ofCharStream(Path value) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), "");
    }

    @Override
    public TsonElement ofCharStream(String value, String language) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), language);
    }

    @Override
    public TsonElement ofCharStream(Path value, String language) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonCharStreamImpl(TsonCharStreamSource.of(value), language);
    }

    @Override
    public TsonElement ofStopStream(String value, String stopWord) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStopWordCharStreamImpl(TsonCharStreamSource.of(value), stopWord);
    }

    @Override
    public TsonElement ofStopStream(char[] value, String stopWord) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStopWordCharStreamImpl(TsonCharStreamSource.of(value), stopWord);
    }

    @Override
    public TsonElement ofStopStream(Reader value, String stopWord) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStopWordCharStreamImpl(TsonCharStreamSource.of(value), stopWord);
    }

    @Override
    public TsonElement ofStopStream(File value, String stopWord) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStopWordCharStreamImpl(TsonCharStreamSource.of(value), stopWord);
    }

    @Override
    public TsonElement ofStopStream(Path value, String stopWord) {
        if (value == null) {
            return this.ofNull();
        }
        return new TsonStopWordCharStreamImpl(TsonCharStreamSource.of(value), stopWord);
    }

    @Override
    public TsonElement of(Boolean value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofBoolean(value);
    }

    @Override
    public TsonElement of(Character value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofChar(value.charValue());
    }

    @Override
    public TsonElement of(Byte value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofByte(value);
    }

    @Override
    public TsonElement of(Short value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofShort(value);
    }

    @Override
    public TsonElement of(Integer value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofInt(value);
    }

    @Override
    public TsonElement of(Long value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofLong(value);
    }

    @Override
    public TsonElement of(Float value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofFloat(value.floatValue());
    }

    @Override
    public TsonElement of(Double value) {
        if (value == null) {
            return this.ofNull();
        }
        return this.ofDouble(value);
    }

    @Override
    public TsonElement of(Date value) {
        if (value == null) {
            return this.ofNull();
        }
        if (value instanceof Time) {
            return this.ofLocalTime((Time)value);
        }
        if (value instanceof java.sql.Date) {
            return this.ofLocalDate(((java.sql.Date)value).toLocalDate());
        }
        return this.ofLocalDatetime(Instant.ofEpochMilli(value.getTime()));
    }

    @Override
    public TsonElement of(Instant value) {
        return this.ofLocalDatetime(value);
    }

    @Override
    public TsonElement of(LocalDate value) {
        return this.ofLocalDate(value);
    }

    @Override
    public TsonElement of(java.sql.Date value) {
        return this.ofLocalDate(value);
    }

    @Override
    public TsonElement of(Time value) {
        return this.ofLocalTime(value);
    }

    @Override
    public TsonElement of(LocalTime value) {
        return this.ofLocalTime(value);
    }

    @Override
    public TsonElement of(Pattern value) {
        return this.ofRegex(value);
    }

    @Override
    public TsonPrimitiveBuilder of() {
        return new TsonPrimitiveElementBuilderImpl();
    }

    @Override
    public TsonArrayBuilder ofArrayBuilder() {
        return new TsonArrayBuilderImpl();
    }

    @Override
    public TsonMatrixBuilder ofMatrixBuilder() {
        return new TsonMatrixBuilderImpl();
    }

    @Override
    public TsonPairBuilder ofPairBuilder() {
        return new TsonPairBuilderImpl();
    }

    @Override
    public TsonObjectBuilder ofObjBuilder() {
        return new TsonObjectBuilderImpl();
    }

    @Override
    public TsonUpletBuilder ofUpletBuilder() {
        return new TsonUpletBuilderImpl();
    }

    @Override
    public TsonAnnotationBuilder ofAnnotationBuilder() {
        return new TsonAnnotationBuilderImpl();
    }

    @Override
    public TsonFormatBuilder format() {
        return new TsonFormatImplBuilder();
    }

    @Override
    public TsonDocumentBuilder ofDocument() {
        return new TsonDocumentBuilderImpl();
    }

    @Override
    public TsonDocumentHeaderBuilder ofDocumentHeader() {
        return new TsonDocumentHeaderBuilderImpl();
    }

    @Override
    public TsonElement of(Enum b) {
        return b == null ? this.ofNull() : this.ofName(b.name());
    }

    @Override
    public TsonElement of(TsonElementBase b) {
        return b == null ? this.ofNull() : b.build();
    }

    @Override
    public TsonElement ofNull() {
        return TsonNullImpl.INSTANCE;
    }

    @Override
    public TsonElement ofString(TsonElementType stringType, String value) {
        switch (stringType == null ? TsonElementType.DOUBLE_QUOTED_STRING : stringType) {
            case DOUBLE_QUOTED_STRING: {
                return this.ofDoubleQuotedString(value);
            }
            case SINGLE_QUOTED_STRING: {
                return this.ofSingleQuotedString(value);
            }
            case ANTI_QUOTED_STRING: {
                return this.ofAntiQuotedString(value);
            }
            case TRIPLE_DOUBLE_QUOTED_STRING: {
                return this.ofTripleDoubleQuotedString(value);
            }
            case TRIPLE_SINGLE_QUOTED_STRING: {
                return this.ofTripleSingleQuotedString(value);
            }
            case TRIPLE_ANTI_QUOTED_STRING: {
                return this.ofTripleAntiQuotedString(value);
            }
            case LINE_STRING: {
                return this.ofLineString(value);
            }
            case CHAR: {
                if (value == null) {
                    return this.ofNull();
                }
                if (value.length() == 1) {
                    return this.ofChar(value.charAt(0));
                }
                throw new IllegalArgumentException("Unsupported String TsonElementType: " + (Object)((Object)stringType));
            }
        }
        throw new IllegalArgumentException("Unsupported String TsonElementType: " + (Object)((Object)stringType));
    }

    @Override
    public TsonElement ofBoolean(boolean val) {
        return TsonBooleanImpl.valueOf(val);
    }

    @Override
    public TsonProcessor processor() {
        return new TsonProcessorImpl();
    }

    @Override
    public TsonBinaryStreamBuilder ofBinStreamBuilder() {
        return new TsonBinaryStreamBuilder(){
            InputStreamTsonBinaryStreamSource s = new InputStreamTsonBinaryStreamSource();

            @Override
            public TsonBinaryStream build() {
                return new TsonBinaryStreamImpl(this.s);
            }

            @Override
            public void writeBase64(String b64) {
                this.s.pushBase64(b64);
            }
        };
    }

    @Override
    public TsonElement parseLocalDateTime(String s) {
        return new TsonLocalDateTimeImpl(LocalDateTime.parse(s));
    }

    @Override
    public TsonElement parseInstant(String s) {
        return new TsonInstantImpl(Instant.parse(s));
    }

    @Override
    public TsonElement parseLocalDate(String s) {
        return new TsonLocalDateImpl(LocalDate.parse(s));
    }

    @Override
    public TsonElement parseLocalTime(String s) {
        return new TsonLocalTimeImpl(LocalTime.parse(s));
    }

    @Override
    public TsonElement parseRegex(String s) {
        String p = s.substring(1, s.length() - 1);
        return new TsonRegexImpl(Pattern.compile(p));
    }

    public Instant parseDateTime(String s) {
        return Instant.parse(s);
    }

    public LocalDate parseDate(String s) {
        return LocalDate.parse(s);
    }

    public LocalTime parseTime(String s) {
        return LocalTime.parse(s);
    }

    public Pattern parseRegexPattern(String s) {
        return Pattern.compile(s.substring(1, s.length() - 1));
    }

    public byte parseByte(String s) {
        if (s.endsWith("b") || s.endsWith("B")) {
            s = s.substring(0, s.length() - 1);
        }
        return Byte.parseByte(s);
    }

    public short parseShort(String s) {
        if (s.endsWith("s") || s.endsWith("S")) {
            s = s.substring(0, s.length() - 1);
        }
        return Short.parseShort(s);
    }

    public long parseLong(String s) {
        if (s.endsWith("l") || s.endsWith("L")) {
            s = s.substring(0, s.length() - 1);
        }
        return Long.parseLong(s);
    }

    public int parseInt(String s) {
        if (s.endsWith("i") || s.endsWith("I")) {
            s = s.substring(0, s.length() - 1);
        }
        return Integer.parseInt(s);
    }

    public float parseFloat(String s) {
        if (s.endsWith("f") || s.endsWith("F")) {
            s = s.substring(0, s.length() - 1);
        }
        return Float.parseFloat(s);
    }

    public double parseDouble(String s) {
        return Double.parseDouble(s);
    }

    @Override
    public TsonElement parseChar(String s) {
        TsonString e = this.parseString(s).toStr();
        if (e.type() == TsonElementType.SINGLE_QUOTED_STRING && e.value().length() == 1) {
            return new TsonCharImpl(e.value().charAt(0));
        }
        throw new TsonParseException("invalid char " + s, (Object)null);
    }

    @Override
    public TsonElement parseAlias(String s) {
        return new TsonAliasImpl(s.substring(1));
    }

    public String parseStringOld(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        StringBuilder sb = new StringBuilder(len - 2);
        int beforeLen = len - 1;
        block10: for (int i = 1; i < beforeLen; ++i) {
            switch (s.charAt(i)) {
                case '\\': {
                    switch (s.charAt(++i)) {
                        case 'n': {
                            sb.append('\n');
                            continue block10;
                        }
                        case 't': {
                            sb.append('\t');
                            continue block10;
                        }
                        case 'f': {
                            sb.append('\f');
                            continue block10;
                        }
                        case 'b': {
                            sb.append('\b');
                            continue block10;
                        }
                        case '\\': {
                            sb.append('\\');
                            continue block10;
                        }
                    }
                    sb.append(chars[i]);
                    continue block10;
                }
                default: {
                    sb.append(chars[i]);
                }
            }
        }
        return sb.toString();
    }

    public TsonDocument elementsToDocument(TsonElement[] roots) {
        Object c = null;
        if (roots.length == 0) {
            return Tson.ofDocument().header(null).content(Tson.ofObjectBuilder().build()).build();
        }
        if (roots.length == 1) {
            return this.elementToDocument(roots[0]);
        }
        List<TsonAnnotation> annotations = roots[0].annotations();
        if (annotations != null && annotations.size() > 0 && "tson".equals(annotations.get(0).name().orNull())) {
            ArrayList<TsonAnnotation> newAnn = new ArrayList<TsonAnnotation>(annotations);
            newAnn.remove(0);
            ArrayList<TsonElement> newList = new ArrayList<TsonElement>(Arrays.asList(roots));
            TsonElement c0 = roots[0].builder().setAnnotations(newAnn.toArray(new TsonAnnotation[0])).build();
            newList.set(0, c0);
            roots = newList.toArray(new TsonElement[0]);
        }
        return Tson.ofDocument().content(Tson.ofObjectBuilder(roots).build()).build();
    }

    public TsonDocument elementToDocument(TsonElement root) {
        List<TsonAnnotation> annotations = root.annotations();
        if (annotations != null && annotations.size() > 0 && "tson".equals(annotations.get(0).name().orNull())) {
            ArrayList<TsonAnnotation> newAnn = new ArrayList<TsonAnnotation>(annotations);
            newAnn.remove(0);
            return Tson.ofDocument().header(Tson.ofDocumentHeader().addParams(annotations.get(0).params()).build()).content(root.builder().setAnnotations(newAnn.toArray(new TsonAnnotation[0])).build()).build();
        }
        return Tson.ofDocument().header(null).content(root).build();
    }

    @Override
    public CharStreamCodeSupport charStreamCodeSupportOf(String language) {
        return CharStreamCodeSupports.of(language);
    }

    @Override
    public TsonElement ofCustom(Object o) {
        return TsonCustomImpl.valueOf(o);
    }

    @Override
    public TsonPrimitiveBuilder ofPrimitiveBuilder() {
        return new TsonPrimitiveElementBuilderImpl();
    }

    @Override
    public TsonComment parseComments(String c) {
        if (c == null) {
            return null;
        }
        if (c.startsWith("/*")) {
            return TsonComment.ofMultiLine(this.escapeMultiLineComments(c));
        }
        if (c.startsWith("//")) {
            return TsonComment.ofSingleLine(this.escapeSingleLineComments(c));
        }
        throw new IllegalArgumentException("unsupported comments " + c);
    }

    public String escapeSingleLineComments(String c) {
        if (c == null) {
            return null;
        }
        if (c.startsWith("//")) {
            return c.substring(2);
        }
        throw new IllegalArgumentException("unsupported comments " + c);
    }

    public String escapeMultiLineComments(String c) {
        if (c == null) {
            return null;
        }
        int line = 0;
        String[] lines = c.trim().split("\n");
        StringBuilder sb = new StringBuilder();
        for (String s : lines) {
            s = s.trim();
            if (line == 0 && s.startsWith("/*")) {
                s = s.substring(2);
            }
            if (line == lines.length - 1 && s.endsWith("*/")) {
                s = s.substring(0, s.length() - 2);
            }
            if (s.equals("*")) {
                s = s.substring(1);
            } else if (s.equals("**")) {
                s = s.substring(1);
            } else if (s.startsWith("*") && s.length() > 1 && Character.isWhitespace(s.charAt(1))) {
                s = s.substring(2).trim();
            } else if (s.startsWith("**") && s.length() > 2 && Character.isWhitespace(s.charAt(1))) {
                s = s.substring(2).trim();
            }
            if (s.length() > 1 && s.charAt(0) == '*' && s.charAt(1) == ' ') {
                s = s.substring(2);
            }
            s = s.trim();
            if (line == lines.length - 1) {
                if (s.length() > 0) {
                    if (line > 0) {
                        sb.append("\n");
                    }
                    sb.append(s.trim());
                }
            } else {
                if (line > 0) {
                    sb.append("\n");
                }
                sb.append(s.trim());
            }
            ++line;
        }
        return sb.toString().trim();
    }

    private int fastDecodeIntOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            int result = Integer.valueOf(nm.substring(index), 8);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            return Integer.parseInt(constant, 8);
        }
    }

    private short fastDecodeShortOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            short result = Short.parseShort(nm.substring(index, nm.length() - 1), 8);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index, nm.length() - 1) : nm.substring(index, nm.length() - 1);
            return Short.parseShort(constant, 8);
        }
    }

    private long fastDecodeLongOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            long result = Long.parseLong(nm.substring(index, nm.length() - 1), 8);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index, nm.length() - 1) : nm.substring(index, nm.length() - 1);
            return Long.parseLong(constant, 8);
        }
    }

    private BigInteger fastDecodeBigIntOctal(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        ++index;
        try {
            BigInteger result = new BigInteger(nm.substring(index, nm.length() - 1), 8);
            if (negative) {
                return result.negate();
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index, nm.length() - 1) : nm.substring(index, nm.length() - 1);
            return new BigInteger(constant, 8);
        }
    }

    private int fastDecodeIntHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            int result = Integer.parseInt(nm.substring(index), 16);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            int result = Integer.parseInt(constant, 16);
            return result;
        }
    }

    private int fastDecodeIntBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            int result = Integer.parseInt(nm.substring(index), 2);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            int result = Integer.parseInt(constant, 2);
            return result;
        }
    }

    private short fastDecodeShortHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            short result = Short.parseShort(nm.substring(index), 16);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            short result = Short.parseShort(constant, 16);
            return result;
        }
    }

    private short fastDecodeShortBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            short result = Short.parseShort(nm.substring(index), 2);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            short result = Short.parseShort(constant, 2);
            return result;
        }
    }

    private long fastDecodeLongHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            long result = Long.parseLong(nm.substring(index), 16);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            long result = Long.parseLong(constant, 16);
            return result;
        }
    }

    private BigInteger fastDecodeBigIntHex(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            BigInteger result = new BigInteger(nm.substring(index), 16);
            if (negative) {
                return result.negate();
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            BigInteger result = new BigInteger(constant, 16);
            return result;
        }
    }

    private long fastDecodeLongBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            long result = Long.parseLong(nm.substring(index), 2);
            if (negative) {
                return -result;
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            long result = Long.parseLong(constant, 2);
            return result;
        }
    }

    private BigInteger fastDecodeBigIntBin(String nm) throws NumberFormatException {
        int index = 0;
        boolean negative = false;
        char firstChar = nm.charAt(0);
        if (firstChar == '-') {
            negative = true;
            ++index;
        } else if (firstChar == '+') {
            ++index;
        }
        index += 2;
        try {
            BigInteger result = new BigInteger(nm.substring(index), 2);
            if (negative) {
                return result.negate();
            }
            return result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? "-" + nm.substring(index) : nm.substring(index);
            BigInteger result = new BigInteger(constant, 2);
            return result;
        }
    }

    public TsonElement parseNaNElem(String s) {
        if (s == null) {
            return Tson.of(Double.NaN);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.NaN);
            }
            case "float": {
                return Tson.of(Float.NaN);
            }
        }
        throw new IllegalArgumentException("Unsupported NaN(" + s + ")");
    }

    public TsonElement parsePosInfElem(String s) {
        if (s == null) {
            return Tson.of(Double.POSITIVE_INFINITY);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.POSITIVE_INFINITY);
            }
            case "float": {
                return Tson.of(Float.POSITIVE_INFINITY);
            }
        }
        throw new IllegalArgumentException("Unsupported +Bound(" + s + ")");
    }

    public TsonElement parseNegInfElem(String s) {
        if (s == null) {
            return Tson.of(Double.NEGATIVE_INFINITY);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.NEGATIVE_INFINITY);
            }
            case "float": {
                return Tson.of(Float.NEGATIVE_INFINITY);
            }
        }
        throw new IllegalArgumentException("Unsupported -Bound(" + s + ")");
    }

    public TsonElement parsePosBoundElem(String s) {
        if (s == null) {
            return Tson.of(Double.MAX_VALUE);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.MAX_VALUE);
            }
            case "float": {
                return Tson.of(Float.MAX_VALUE);
            }
            case "byte": {
                return Tson.of((byte)127);
            }
            case "short": {
                return Tson.of((short)Short.MAX_VALUE);
            }
            case "int": {
                return Tson.of(Integer.MAX_VALUE);
            }
            case "long": {
                return Tson.of(Long.MAX_VALUE);
            }
        }
        throw new IllegalArgumentException("Unsupported +Inf(" + s + ")");
    }

    public TsonElement parseNegBoundElem(String s) {
        if (s == null) {
            return Tson.of(Double.MIN_VALUE);
        }
        switch (s) {
            case "double": {
                return Tson.of(Double.MIN_VALUE);
            }
            case "float": {
                return Tson.of(Float.MIN_VALUE);
            }
            case "byte": {
                return Tson.of((byte)-128);
            }
            case "short": {
                return Tson.of((short)Short.MIN_VALUE);
            }
            case "int": {
                return Tson.of(Integer.MIN_VALUE);
            }
            case "long": {
                return Tson.of(Long.MIN_VALUE);
            }
        }
        throw new IllegalArgumentException("Unsupported -Inf(" + s + ")");
    }

    @Override
    public TsonElement parseNumber(String s) {
        TsonNumberHelper parse = TsonNumberHelper.parse(s);
        return parse.toTson();
    }

    private static TsonElementType resolveType(Object value) {
        if (value == null) {
            return TsonElementType.NULL;
        }
        switch (value.getClass().getName()) {
            case "java.lang.Byte": {
                return TsonElementType.BYTE;
            }
            case "java.lang.Short": {
                return TsonElementType.SHORT;
            }
            case "java.lang.Integer": {
                return TsonElementType.INTEGER;
            }
            case "java.lang.Long": {
                return TsonElementType.LONG;
            }
            case "java.math.BigInteger": {
                return TsonElementType.BIG_INTEGER;
            }
            case "java.lang.Float": {
                return TsonElementType.FLOAT;
            }
            case "java.lang.Double": {
                return TsonElementType.DOUBLE;
            }
            case "java.math.BigDecimal": {
                return TsonElementType.BIG_DECIMAL;
            }
            case "java.lang.String": 
            case "java.lang.StringBuilder": 
            case "java.lang.StringBuffer": {
                return TsonElementType.DOUBLE_QUOTED_STRING;
            }
            case "java.util.Date": 
            case "java.time.Instant": {
                return TsonElementType.INSTANT;
            }
            case "java.time.LocalDateTime": {
                return TsonElementType.LOCAL_DATETIME;
            }
            case "java.time.LocalDate": {
                return TsonElementType.LOCAL_DATE;
            }
            case "java.time.LocalTime": {
                return TsonElementType.LOCAL_TIME;
            }
            case "java.lang.Boolean": {
                return TsonElementType.BOOLEAN;
            }
        }
        if (value instanceof TsonDoubleComplex) {
            return TsonElementType.DOUBLE_COMPLEX;
        }
        if (value instanceof TsonFloatComplex) {
            return TsonElementType.FLOAT_COMPLEX;
        }
        if (value instanceof TsonBigComplex) {
            return TsonElementType.BIG_COMPLEX;
        }
        if (value instanceof Number) {
            return TsonElementType.DOUBLE;
        }
        if (value instanceof CharSequence) {
            return TsonElementType.DOUBLE_QUOTED_STRING;
        }
        return TsonElementType.OBJECT;
    }
}

