/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson.bundled;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.Date;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.CharStreamCodeSupport;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotationBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArrayBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBinaryStreamBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocumentHeaderBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementsFactory;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormat;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFormatBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonMatrixBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObjectBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOp;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOpType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPrimitiveBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonProcessor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUpletBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.TsonElementsFactoryImpl;

public class Tson {
    private static String VERSION = "1.0";
    private static TsonElementsFactory factory = new TsonElementsFactoryImpl();
    public static final TsonFormat COMPACT_FORMAT = Tson.format().compact(true).build();
    public static final TsonFormat DEFAULT_FORMAT = Tson.format().build();

    public static String getVersion() {
        return VERSION;
    }

    public static TsonElement ofTrue() {
        return Tson.of(true);
    }

    public static TsonElement ofFalse() {
        return Tson.of(false);
    }

    public static TsonElement ofNull() {
        return factory.ofNull();
    }

    public static TsonElement ofBoolean(boolean val) {
        return factory.ofBoolean(val);
    }

    public static TsonElement ofString(TsonElementType stringType, String value) {
        return factory.ofString(stringType, value);
    }

    public static TsonElement ofString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofDoubleQuotedString(value);
    }

    public static TsonElement ofDoubleQuotedString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofDoubleQuotedString(value);
    }

    public static TsonElement ofSingleQuotedString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofSingleQuotedString(value);
    }

    public static TsonElement ofAntiQuotedString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofAntiQuotedString(value);
    }

    public static TsonElement ofTripleDoubleQuotedString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofTripleDoubleQuotedString(value);
    }

    public static TsonElement ofTripleSingleQuotedString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofTripleSingleQuotedString(value);
    }

    public static TsonElement ofTripleAntiQuotedString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofTripleAntiQuotedString(value);
    }

    public static TsonElement ofLineString(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofLineString(value);
    }

    public static TsonElement ofElement(TsonElementBase value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return value.build();
    }

    public static TsonElementBase ofElementBase(TsonElementBase value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return value;
    }

    public static TsonElement ofInstant(Instant value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofInstant(value);
    }

    public static TsonElement ofLocalDatetime(Instant value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofLocalDatetime(value);
    }

    public static TsonElement ofLocalDatetime(java.util.Date value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofLocalDatetime(Instant.ofEpochMilli(value.getTime()));
    }

    public static TsonElement ofLocalDatetime(LocalDateTime value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofLocalDatetime(value);
    }

    public static TsonElement ofLocalDate(LocalDate value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofLocalDate(value);
    }

    public static TsonElement ofLocalTime(LocalTime value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofLocalTime(value);
    }

    public static TsonElement ofLocalTime(Time value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofLocalTime(value.toLocalTime());
    }

    public static TsonElement ofLocalDate(Date value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofLocalDate(value.toLocalDate());
    }

    public static TsonElement ofRegex(Pattern value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofRegex(value);
    }

    public static TsonElement ofRegex(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofRegex(Pattern.compile(value));
    }

    public static TsonPrimitiveBuilder ofPrimitiveBuilder() {
        return factory.ofPrimitiveBuilder();
    }

    public static TsonElement ofChar(char value) {
        return factory.ofChar(value);
    }

    public static TsonElement ofNumber(Number value, TsonNumberLayout layout, String unit) {
        return factory.ofNumber(value, layout, unit);
    }

    public static TsonElement ofInt(int value) {
        return Tson.ofInt(value, TsonNumberLayout.DECIMAL);
    }

    public static TsonElement ofInt(int value, TsonNumberLayout layout) {
        return factory.ofInt(value, layout, null);
    }

    public static TsonElement ofInt(int value, TsonNumberLayout layout, String unit) {
        return factory.ofInt(value, layout, unit);
    }

    public static TsonElement ofLong(long value) {
        return Tson.ofLong(value, TsonNumberLayout.DECIMAL);
    }

    public static TsonElement ofLong(long value, TsonNumberLayout layout) {
        return factory.ofLong(value, layout, null);
    }

    public static TsonElement ofLong(long value, TsonNumberLayout layout, String unit) {
        return factory.ofLong(value, layout, unit);
    }

    public static TsonElement ofByte(byte value, TsonNumberLayout layout) {
        return factory.ofByte(value, layout, null);
    }

    public static TsonElement ofByte(byte value, TsonNumberLayout layout, String unit) {
        return factory.ofByte(value, layout, unit);
    }

    public static TsonElement ofByte(byte value) {
        return Tson.ofByte(value, TsonNumberLayout.DECIMAL);
    }

    public static TsonElement ofShort(short value, TsonNumberLayout layout) {
        return factory.ofShort(value, layout, null);
    }

    public static TsonElement ofShort(short value, TsonNumberLayout layout, String unit) {
        return factory.ofShort(value, layout, unit);
    }

    public static TsonElement ofShort(short value) {
        return Tson.ofShort(value, TsonNumberLayout.DECIMAL);
    }

    public static TsonElement ofFloat(float value) {
        return factory.ofFloat(value, null);
    }

    public static TsonElement ofFloat(float value, String unit) {
        return factory.ofFloat(value, unit);
    }

    public static TsonElement ofBigInt(BigInteger value) {
        return Tson.ofBigInt(value, TsonNumberLayout.DECIMAL);
    }

    public static TsonElement ofBigInt(BigInteger value, TsonNumberLayout layout) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBigInt(value, layout, null);
    }

    public static TsonElement ofBigInt(BigInteger value, TsonNumberLayout layout, String unit) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBigInt(value, layout, unit);
    }

    public static TsonElement ofBigDecimal(BigDecimal value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBigDecimal(value, null);
    }

    public static TsonElement ofBigDecimal(BigDecimal value, String unit) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBigDecimal(value, unit);
    }

    public static TsonElement ofBigComplex(BigDecimal real, BigDecimal imag) {
        if (real == null && imag == null) {
            return Tson.ofNull();
        }
        if (real == null || imag == null) {
            throw new IllegalArgumentException("Null real or imag");
        }
        return factory.ofBigComplex(real, imag, null);
    }

    public static TsonElement ofBigComplex(BigDecimal real, BigDecimal imag, String unit) {
        if (real == null && imag == null) {
            return Tson.ofNull();
        }
        if (real == null || imag == null) {
            throw new IllegalArgumentException("Null real or imag");
        }
        return factory.ofBigComplex(real, imag, unit);
    }

    public static TsonElement ofFloatComplex(float real, float imag) {
        return factory.ofFloatComplex(real, imag, null);
    }

    public static TsonElement ofFloatComplex(float real, float imag, String unit) {
        return factory.ofFloatComplex(real, imag, unit);
    }

    public static TsonElement ofDoubleComplex(double real, double imag) {
        return factory.ofDoubleComplex(real, imag, null);
    }

    public static TsonElement ofDoubleComplex(double real, double imag, String unit) {
        return factory.ofDoubleComplex(real, imag, unit);
    }

    public static TsonElement ofDouble(double value) {
        return factory.ofDouble(value, null);
    }

    public static TsonElement ofDouble(double value, String unit) {
        return factory.ofDouble(value, unit);
    }

    public static TsonElement ofName(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofName(value);
    }

    public static TsonElement ofAlias(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofAlias(value);
    }

    public static TsonPair ofPair(TsonElementBase key, TsonElementBase value) {
        return factory.ofPairBuilder().key(Tson.of(key)).value(Tson.of(value)).build();
    }

    public static TsonOp binOp(String op, TsonElementBase key, TsonElementBase value) {
        return factory.ofOpBuilder().opName(op).opType(TsonOpType.BINARY).first(Tson.of(key)).second(Tson.of(value)).build();
    }

    public static TsonPair ofPair(String key, TsonElementBase value) {
        return factory.ofPairBuilder().key(Tson.ofName(key)).value(Tson.of(value)).build();
    }

    public static TsonElement of(boolean value) {
        return Tson.ofBoolean(value);
    }

    public static TsonElement of(Number value) {
        if (value == null) {
            return Tson.ofNull();
        }
        switch (value.getClass().getName()) {
            case "byte": 
            case "java.lang.Byte": {
                return Tson.of(value.byteValue());
            }
            case "short": 
            case "java.lang.Short": {
                return Tson.of(value.shortValue());
            }
            case "int": 
            case "java.lang.Integer": {
                return Tson.of(value.intValue());
            }
            case "long": 
            case "java.lang.Long": {
                return Tson.of(value.longValue());
            }
            case "float": 
            case "java.lang.Float": {
                return Tson.of(value.floatValue());
            }
            case "double": 
            case "java.lang.Double": {
                return Tson.of(value.doubleValue());
            }
            case "java.math.BigInteger": {
                return Tson.of((BigInteger)value);
            }
            case "java.math.BigDecimal": {
                return Tson.of((BigDecimal)value);
            }
        }
        throw new IllegalArgumentException("Unsupported number type: " + value.getClass().getName());
    }

    public static TsonElement of(char value) {
        return Tson.ofChar(value);
    }

    public static TsonElement of(byte value) {
        return Tson.ofByte(value);
    }

    public static TsonElement of(short value) {
        return Tson.ofShort(value);
    }

    public static TsonElement of(int value) {
        return Tson.ofInt(value);
    }

    public static TsonElement of(long value) {
        return Tson.ofLong(value);
    }

    public static TsonElement of(float value) {
        return Tson.ofFloat(value);
    }

    public static TsonElement of(double value) {
        return Tson.ofDouble(value);
    }

    public static TsonElement of(BigInteger value) {
        return Tson.ofBigInt(value);
    }

    public static TsonElement of(BigDecimal value) {
        return Tson.ofBigDecimal(value);
    }

    public static TsonElement of(byte[] value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofBinStream(value);
    }

    public static TsonElement of(InputStream value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofBinStream(value);
    }

    public static TsonBinaryStreamBuilder ofBinStream() {
        return factory.ofBinStreamBuilder();
    }

    public static TsonElement ofBinStream(byte[] value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBinStream(value);
    }

    public static TsonElement ofBinStream(InputStream value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBinStream(value);
    }

    public static TsonElement ofBinStream(File value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBinStream(value);
    }

    public static TsonElement ofBinStream(Path value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofBinStream(value);
    }

    private static TsonElement ofCharStream(char[] value, String type) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, type);
    }

    private static TsonElement ofCharStream(Reader value, String type) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, type);
    }

    private static TsonElement ofCharStream(File value, String type) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, type);
    }

    public static TsonElement ofCharStream(String value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, "");
    }

    public static TsonElement ofCharStream(char[] value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, "");
    }

    public static TsonElement ofCharStream(Reader value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, "");
    }

    public static TsonElement ofCharStream(File value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, "");
    }

    public static TsonElement ofCharStream(Path value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, "");
    }

    public static TsonElement ofCharStream(String value, String language) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, language);
    }

    public static TsonElement ofCharStream(Path value, String language) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, language);
    }

    public static TsonElement ofStopStream(String value, String stopWord) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, stopWord);
    }

    public static TsonElement ofStopStream(char[] value, String stopWord) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, stopWord);
    }

    public static TsonElement ofStopStream(Reader value, String stopWord) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, stopWord);
    }

    public static TsonElement ofStopStream(File value, String stopWord) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, stopWord);
    }

    public static TsonElement ofStopStream(Path value, String stopWord) {
        if (value == null) {
            return Tson.ofNull();
        }
        return factory.ofStopStream(value, stopWord);
    }

    public static TsonElement of(Boolean value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofBoolean(value);
    }

    public static TsonElement of(Character value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofChar(value.charValue());
    }

    public static TsonElement of(Byte value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofByte(value);
    }

    public static TsonElement of(Short value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofShort(value);
    }

    public static TsonElement of(Integer value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofInt(value);
    }

    public static TsonElement of(Long value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofLong(value);
    }

    public static TsonElement of(Float value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofFloat(value.floatValue());
    }

    public static TsonElement of(Double value) {
        if (value == null) {
            return Tson.ofNull();
        }
        return Tson.ofDouble(value);
    }

    public static TsonElement of(java.util.Date value) {
        if (value == null) {
            return Tson.ofNull();
        }
        if (value instanceof Time) {
            return Tson.ofLocalTime((Time)value);
        }
        if (value instanceof Date) {
            return Tson.ofLocalDate(((Date)value).toLocalDate());
        }
        return Tson.ofLocalDatetime(Instant.ofEpochMilli(value.getTime()));
    }

    public static TsonElement of(Instant value) {
        return Tson.ofInstant(value);
    }

    public static TsonElement of(LocalDate value) {
        return Tson.ofLocalDate(value);
    }

    public static TsonElement of(LocalDateTime value) {
        return Tson.ofLocalDatetime(value);
    }

    public static TsonElement of(Date value) {
        return Tson.ofLocalDate(value);
    }

    public static TsonElement of(Time value) {
        return Tson.ofLocalTime(value);
    }

    public static TsonElement of(LocalTime value) {
        return Tson.ofLocalTime(value);
    }

    public static TsonElement of(Pattern value) {
        return Tson.ofRegex(value);
    }

    public static TsonElement of(String value) {
        return Tson.ofString(value);
    }

    public static TsonElement of(String[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).map(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(boolean[] value) {
        if (value == null) {
            return Tson.ofNull();
        }
        TsonArrayBuilder a = Tson.ofArrayBuilder();
        for (boolean b : value) {
            a.add(Tson.of(b));
        }
        return a.build();
    }

    public static TsonElement of(short[] value) {
        if (value == null) {
            return Tson.ofNull();
        }
        TsonArrayBuilder a = Tson.ofArrayBuilder();
        for (short b : value) {
            a.add(Tson.of(b));
        }
        return a.build();
    }

    public static TsonElement of(float[] value) {
        if (value == null) {
            return Tson.ofNull();
        }
        TsonArrayBuilder a = Tson.ofArrayBuilder();
        for (float b : value) {
            a.add(Tson.of(b));
        }
        return a.build();
    }

    public static TsonElement of(int[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).mapToObj(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(long[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).mapToObj(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(double[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).mapToObj(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(Boolean[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).map(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(Short[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).map(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(Float[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).map(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(Integer[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).map(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(Long[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).map(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonElement of(Double[] value) {
        return value == null ? Tson.ofNull() : Tson.ofArray((TsonElementBase[])Arrays.stream(value).map(x -> Tson.of(x)).toArray(TsonElementBase[]::new)).build();
    }

    public static TsonPrimitiveBuilder of() {
        return factory.of();
    }

    public static TsonArray ofArray(TsonElementBase ... elements) {
        return Tson.ofArrayBuilder().addAll(elements).build();
    }

    public static TsonArrayBuilder ofArrayBuilder() {
        return factory.ofArrayBuilder();
    }

    public static TsonArrayBuilder ofArrayBuilder(String name) {
        return Tson.ofArrayBuilder().name(name);
    }

    public static TsonArray ofArray(String name, TsonElementBase[] params, TsonElementBase ... elems) {
        return Tson.ofArrayBuilder().name(name).addParams(params).addAll(elems).build();
    }

    public static TsonArray ofArray(String name, TsonElementBase ... elems) {
        return Tson.ofArrayBuilder().name(name).addAll(elems).build();
    }

    public static TsonMatrixBuilder ofMatrixBuilder() {
        return factory.ofMatrixBuilder();
    }

    public static TsonMatrixBuilder ofMatrixBuilder(String name) {
        return Tson.ofMatrixBuilder().name(name);
    }

    public static TsonMatrixBuilder ofMatrixBuilder(String name, TsonElementBase[] params) {
        return Tson.ofMatrixBuilder().name(name).addParams(params);
    }

    public static TsonElementBuilder ofPair() {
        return factory.ofPairBuilder();
    }

    public static TsonObjectBuilder ofObjectBuilder() {
        return factory.ofObjBuilder();
    }

    public static TsonObjectBuilder ofObjectBuilder(TsonElementBase ... elems) {
        return Tson.ofObjectBuilder().addAll(elems);
    }

    public static TsonObject ofObject(TsonElementBase ... elems) {
        return Tson.ofObjectBuilder().addAll(elems).build();
    }

    public static TsonObjectBuilder ofObjectBuilder(String name) {
        TsonObjectBuilder e = Tson.ofObjectBuilder();
        e.name(name);
        return e;
    }

    public static TsonObjectBuilder ofObjectBuilder(String name, TsonElementBase[] params, TsonElementBase ... elems) {
        TsonObjectBuilder o = Tson.ofObjectBuilder();
        o.name(name).addParams(params);
        return o.addAll(elems);
    }

    public static TsonObjectBuilder ofObjectBuilder(String name, TsonElementBase ... elems) {
        TsonObjectBuilder o = Tson.ofObjectBuilder();
        o.name(name);
        return o.addAll(elems);
    }

    public static TsonUpletBuilder ofUpletBuilder() {
        return factory.ofUpletBuilder();
    }

    public static TsonUplet ofUplet(TsonElementBase ... elements) {
        return factory.ofUpletBuilder().addAll(elements).build();
    }

    public static TsonUplet ofUplet(String name, TsonElementBase ... elems) {
        return factory.ofUpletBuilder().name(name).addAll(elems).build();
    }

    public static TsonAnnotationBuilder ofAnnotationBuilder() {
        return factory.ofAnnotationBuilder();
    }

    public static TsonAnnotation ofAnnotation(String name, TsonElementBase ... elements) {
        return Tson.ofAnnotationBuilder().name(name).addAll(elements).build();
    }

    public static TsonFormatBuilder format() {
        return factory.format();
    }

    public static TsonDocumentBuilder ofDocument() {
        return factory.ofDocument();
    }

    public static TsonDocumentHeaderBuilder ofDocumentHeader() {
        return factory.ofDocumentHeader();
    }

    public static TsonProcessor processor() {
        return factory.processor();
    }

    public static TsonElement of(Enum b) {
        return b == null ? Tson.ofNull() : Tson.ofName(b.name());
    }

    public static TsonElement of(TsonElementBase b) {
        return b == null ? Tson.ofNull() : b.build();
    }

    public static TsonElement parseLocalDateTime(String image) {
        return factory.parseLocalDateTime(image);
    }

    public static TsonElement parseInstant(String image) {
        return factory.parseInstant(image);
    }

    public static TsonElement parseNumber(String image) {
        return factory.parseNumber(image);
    }

    public static TsonElement parseChar(String image) {
        return factory.parseChar(image);
    }

    public static TsonElement parseString(String image) {
        return factory.parseString(image);
    }

    public static TsonElement parseAlias(String image) {
        return factory.parseAlias(image);
    }

    public static TsonElement parseLocalDate(String image) {
        return factory.parseLocalDate(image);
    }

    public static TsonElement parseLocalTime(String image) {
        return factory.parseLocalTime(image);
    }

    public static TsonElement parseRegex(String image) {
        return factory.parseRegex(image);
    }

    public static TsonComment parseComments(String image) {
        return factory.parseComments(image);
    }

    public static CharStreamCodeSupport charStreamCodeSupportOf(String language) {
        return factory.charStreamCodeSupportOf(language);
    }

    public static TsonElement ofCustom(Object o) {
        return factory.ofCustom(o);
    }
}

