/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tson;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementCommentType;
import net.thevpc.nuts.elem.NElementComments;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NElementUtils;
import net.thevpc.nuts.elem.NElements;
import net.thevpc.nuts.elem.NNumberElement;
import net.thevpc.nuts.elem.NNumberLayout;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NOperatorElementBuilder;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.elem.NPrimitiveElementBuilder;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.math.NBigComplex;
import net.thevpc.nuts.math.NDoubleComplex;
import net.thevpc.nuts.math.NFloatComplex;
import net.thevpc.nuts.runtime.standalone.elem.NElementStreamFormat;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementAnnotationImpl;
import net.thevpc.nuts.runtime.standalone.elem.item.NElementCommentImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotation;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonAnnotationBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonArray;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonBigComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComment;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonCommentType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonComments;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDocument;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonDoubleComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElement;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBase;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementType;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonElementsFactory;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonFloatComplex;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumber;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonNumberLayout;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonObject;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonOp;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonPair;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonParseException;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonStreamParser;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonStreamParserConfig;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.TsonUplet;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.TsonElementsFactoryImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonAnnotationBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.builders.TsonObjectBuilderImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.elements.TsonPairImpl;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.format.DefaultTsonFormatConfig;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.format.TsonFormatImplBuilder;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.ElementBuilderTsonParserVisitor;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.javacc.JavaccHelper;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.javacc.ParseException;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.javacc.TokenMgrError;
import net.thevpc.nuts.runtime.standalone.format.tson.bundled.impl.parser.javacc.TsonStreamParserImpl;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NUtils;

public class DefaultTsonElementFormat
implements NElementStreamFormat {
    private static TsonElementsFactory factory = new TsonElementsFactoryImpl();

    public NElement parseElement(String string, NElementFactoryContext context, Object readerSource) {
        if (string == null) {
            string = "";
        }
        return this.parseElement(new StringReader(string), context, readerSource);
    }

    public void write(NPrintStream out, NElement data, boolean compact) {
        TsonFormatImplBuilder ts = new TsonFormatImplBuilder();
        DefaultTsonFormatConfig c = new DefaultTsonFormatConfig();
        c.setCompact(compact);
        ts.setConfig(c);
        out.print(ts.build().format(this.toTson(data)));
    }

    @Override
    public NElement normalize(NElement e) {
        return e;
    }

    private NElementAnnotation toNElemAnn(TsonAnnotation elem) {
        List<TsonElement> params;
        return new NElementAnnotationImpl(elem.name().orNull(), (params = elem.params()) == null ? null : (NElement[])params.stream().map(x -> this.toNElem((TsonElement)x)).toArray(NElement[]::new));
    }

    private TsonAnnotation toTsonAnn(NElementAnnotation elem) {
        List<NElement> params = elem.params();
        TsonAnnotationBuilder b = new TsonAnnotationBuilderImpl().name(elem.name()).addAll(params == null ? null : (TsonElementBase[])params.stream().map(x -> this.toTson((NElement)x)).toArray(TsonElementBase[]::new));
        return b.build();
    }

    @Override
    public NElement parseElement(Reader reader, NElementFactoryContext context, Object readerSource) {
        TsonStreamParserConfig config = new TsonStreamParserConfig();
        ElementBuilderTsonParserVisitor r = new ElementBuilderTsonParserVisitor();
        TsonStreamParser source = this.fromReader(reader, readerSource);
        config.setVisitor(r);
        source.setConfig(config);
        try {
            source.parseDocument();
        }
        catch (Exception e) {
            throw new TsonParseException(e, NUtils.firstNonNull(source.source(), readerSource));
        }
        TsonDocument document = r.getDocument();
        TsonElement e = document == null ? null : document.getContent();
        return e == null ? NElement.ofNull() : this.toNElem(e);
    }

    public TsonElement[] toTsonElemArray(List<NElement> elems) {
        if (elems == null) {
            return null;
        }
        return (TsonElement[])elems.stream().map(x -> this.toTson((NElement)x)).toArray(TsonElement[]::new);
    }

    public TsonElement toTson(NElement elem) {
        if (elem == null) {
            return factory.ofNull();
        }
        switch (elem.type()) {
            case NULL: {
                return this.decorateTsonElement(factory.ofNull(), elem);
            }
            case INT: {
                return this.decorateTsonElement(factory.ofInt(elem.asIntValue().get()), elem);
            }
            case LONG: {
                return this.decorateTsonElement(factory.ofLong(elem.asLongValue().get()), elem);
            }
            case FLOAT: {
                return this.decorateTsonElement(factory.ofFloat(elem.asFloatValue().get().floatValue()), elem);
            }
            case DOUBLE: {
                return this.decorateTsonElement(factory.ofDouble(elem.asDoubleValue().get()), elem);
            }
            case BYTE: {
                return this.decorateTsonElement(factory.ofByte(elem.asByteValue().get()), elem);
            }
            case LOCAL_DATE: {
                return this.decorateTsonElement(factory.ofLocalDate(elem.asPrimitive().get().asLocalDateValue().get()), elem);
            }
            case LOCAL_DATETIME: {
                return this.decorateTsonElement(factory.ofLocalDatetime(elem.asPrimitive().get().asLocalDateTimeValue().get()), elem);
            }
            case LOCAL_TIME: {
                return this.decorateTsonElement(factory.ofLocalTime(elem.asPrimitive().get().asLocalTimeValue().get()), elem);
            }
            case REGEX: {
                return this.decorateTsonElement(factory.ofRegex(elem.asStringValue().get()), elem);
            }
            case BIG_INT: {
                return this.decorateTsonElement(factory.ofBigInt(elem.asBigIntValue().get()), elem);
            }
            case BIG_DECIMAL: {
                return this.decorateTsonElement(factory.ofBigDecimal(elem.asBigDecimalValue().get()), elem);
            }
            case SHORT: {
                return this.decorateTsonElement(factory.ofShort(elem.asShortValue().get()), elem);
            }
            case BOOLEAN: {
                return this.decorateTsonElement(factory.ofBoolean(elem.asBooleanValue().get()), elem);
            }
            case CHAR: {
                return this.decorateTsonElement(factory.ofChar(elem.asCharValue().get().charValue()), elem);
            }
            case INSTANT: {
                return this.decorateTsonElement(factory.ofInstant(elem.asInstantValue().get()), elem);
            }
            case BIG_COMPLEX: {
                NBigComplex v = elem.asBigComplexValue().get();
                return this.decorateTsonElement(factory.ofBigComplex(v.real(), v.imag()), elem);
            }
            case DOUBLE_COMPLEX: {
                NDoubleComplex v = elem.asDoubleComplexValue().get();
                return this.decorateTsonElement(factory.ofDoubleComplex(v.real(), v.imag()), elem);
            }
            case FLOAT_COMPLEX: {
                NFloatComplex v = elem.asFloatComplexValue().get();
                return this.decorateTsonElement(factory.ofFloatComplex(v.real(), v.imag()), elem);
            }
            case ARRAY: 
            case NAMED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: {
                NArrayElement ee = elem.asArray().get();
                return this.decorateTsonElement(factory.ofArrayBuilder().name(ee.name().orNull()).addParams(this.toTsonElemArray(ee.params().orNull())).addAll(this.toTsonElemArray(ee.children())).build(), elem);
            }
            case OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: {
                NObjectElement ee = elem.asObject().get();
                return this.decorateTsonElement(new TsonObjectBuilderImpl().name(ee.name().orNull()).addParams(this.toTsonElemArray(ee.params().orNull())).addAll(this.toTsonElemArray(ee.children())).build(), elem);
            }
            case UPLET: 
            case NAMED_UPLET: {
                NUpletElement ee = elem.asUplet().get();
                return this.decorateTsonElement(factory.ofUpletBuilder().name(ee.name().orNull()).addAll(this.toTsonElemArray(ee.children())).build(), elem);
            }
            case PAIR: {
                NPairElement ee = elem.asPair().get();
                return this.decorateTsonElement(new TsonPairImpl(this.toTson(ee.key()), this.toTson(ee.value())), elem);
            }
            case NAME: {
                String s = elem.asStringValue().get();
                if (NElementUtils.isValidElementName(s, NContentType.TSON)) {
                    return this.decorateTsonElement(factory.ofName(s), elem);
                }
                return this.decorateTsonElement(factory.ofDoubleQuotedString(s), elem);
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                return this.decorateTsonElement(factory.ofString(this.toTsonStringLayout(elem.asString().get().type()), elem.asString().get().stringValue()), elem);
            }
        }
        throw new IllegalArgumentException("not implemented");
    }

    private TsonElementType toTsonStringLayout(NElementType layout) {
        if (layout == null) {
            return null;
        }
        switch (layout) {
            case DOUBLE_QUOTED_STRING: {
                return TsonElementType.DOUBLE_QUOTED_STRING;
            }
            case ANTI_QUOTED_STRING: {
                return TsonElementType.ANTI_QUOTED_STRING;
            }
            case TRIPLE_DOUBLE_QUOTED_STRING: {
                return TsonElementType.TRIPLE_DOUBLE_QUOTED_STRING;
            }
            case TRIPLE_SINGLE_QUOTED_STRING: {
                return TsonElementType.TRIPLE_SINGLE_QUOTED_STRING;
            }
            case TRIPLE_ANTI_QUOTED_STRING: {
                return TsonElementType.TRIPLE_ANTI_QUOTED_STRING;
            }
            case SINGLE_QUOTED_STRING: {
                return TsonElementType.SINGLE_QUOTED_STRING;
            }
            case LINE_STRING: {
                return TsonElementType.LINE_STRING;
            }
        }
        throw new IllegalArgumentException("not implemented Tson toTsonStringLayout " + layout);
    }

    private TsonElement decorateTsonElement(TsonElement t, NElement fromElem) {
        if (fromElem instanceof NNumberElement) {
            NNumberElement en = (NNumberElement)fromElem;
            TsonNumberLayout nf = TsonNumberLayout.DECIMAL;
            String nSuffix = null;
            if (en.numberLayout() != null && en.numberLayout() != NNumberLayout.DECIMAL) {
                switch (en.numberLayout()) {
                    case DECIMAL: {
                        nf = TsonNumberLayout.DECIMAL;
                        break;
                    }
                    case HEXADECIMAL: {
                        nf = TsonNumberLayout.HEXADECIMAL;
                        break;
                    }
                    case BINARY: {
                        nf = TsonNumberLayout.BINARY;
                        break;
                    }
                    case OCTAL: {
                        nf = TsonNumberLayout.OCTAL;
                    }
                }
            }
            if (!NBlankable.isBlank(en.numberSuffix())) {
                nSuffix = en.numberSuffix();
            }
            if (nf != null && nf != TsonNumberLayout.DECIMAL || nSuffix != null) {
                t = factory.ofNumber(en.numberValue(), nf, nSuffix);
            }
        }
        List<NElementAnnotation> na = fromElem.annotations();
        NElementComments nc = fromElem.comments();
        if (na.isEmpty() && nc.isEmpty()) {
            return t;
        }
        TsonElementBuilder b = t.builder();
        b.addAnnotations(na.stream().map(x -> this.toTsonAnn((NElementAnnotation)x)).collect(Collectors.toList()));
        TsonComments tc = TsonComments.BLANK;
        tc = tc.addLeading((TsonComment[])nc.leadingComments().stream().map(x -> new TsonComment(x.type() == NElementCommentType.SINGLE_LINE ? TsonCommentType.SINGLE_LINE : (x.type() == NElementCommentType.MULTI_LINE ? TsonCommentType.MULTI_LINE : TsonCommentType.SINGLE_LINE), x.text())).toArray(TsonComment[]::new));
        tc = tc.addTrailing((TsonComment[])nc.trailingComments().stream().map(x -> new TsonComment(x.type() == NElementCommentType.SINGLE_LINE ? TsonCommentType.SINGLE_LINE : (x.type() == NElementCommentType.MULTI_LINE ? TsonCommentType.MULTI_LINE : TsonCommentType.SINGLE_LINE), x.text())).toArray(TsonComment[]::new));
        b.setComments(tc);
        return b.build();
    }

    private NElement decorateNElement(NElement elem, TsonElement fromTson) {
        List<TsonAnnotation> annotations = fromTson.annotations();
        TsonComments comments = fromTson.comments();
        if (annotations.isEmpty() && comments.isEmpty()) {
            return elem;
        }
        NElementBuilder builder = elem.builder();
        return this.decorateNElement(builder, fromTson);
    }

    private NElement decorateNElement(NElementBuilder elem, TsonElement fromTson) {
        List<TsonAnnotation> annotations = fromTson.annotations();
        TsonComments comments = fromTson.comments();
        if (annotations.isEmpty() && comments.isEmpty()) {
            return elem.build();
        }
        NElementBuilder builder = elem;
        builder.addAnnotations(annotations.stream().map(this::toNElemAnn).collect(Collectors.toList())).build();
        for (TsonComment tc : comments.leadingComments()) {
            builder.addLeadingComment(new NElementCommentImpl(tc.type() == TsonCommentType.SINGLE_LINE ? NElementCommentType.SINGLE_LINE : (tc.type() == TsonCommentType.MULTI_LINE ? NElementCommentType.MULTI_LINE : NElementCommentType.SINGLE_LINE), tc.text()));
        }
        for (TsonComment tc : comments.trailingComments()) {
            builder.addLeadingComment(new NElementCommentImpl(tc.type() == TsonCommentType.SINGLE_LINE ? NElementCommentType.SINGLE_LINE : (tc.type() == TsonCommentType.MULTI_LINE ? NElementCommentType.MULTI_LINE : NElementCommentType.SINGLE_LINE), tc.text()));
        }
        if (elem instanceof NNumberElement) {
            TsonNumber tn = (TsonNumber)fromTson;
            NPrimitiveElementBuilder nnb = (NPrimitiveElementBuilder)builder;
            if (tn.numberLayout() != null && tn.numberLayout() != TsonNumberLayout.DECIMAL) {
                switch (tn.numberLayout()) {
                    case DECIMAL: {
                        nnb.numberLayout(NNumberLayout.DECIMAL);
                        break;
                    }
                    case HEXADECIMAL: {
                        nnb.numberLayout(NNumberLayout.HEXADECIMAL);
                        break;
                    }
                    case BINARY: {
                        nnb.numberLayout(NNumberLayout.BINARY);
                        break;
                    }
                    case OCTAL: {
                        nnb.numberLayout(NNumberLayout.OCTAL);
                    }
                }
            }
            if (!NBlankable.isBlank(tn.numberSuffix())) {
                nnb.numberSuffix(tn.numberSuffix());
            }
        }
        return builder.build();
    }

    private NElement toNElem(TsonElement tsonElem) {
        NElements elems = NElements.of();
        switch (tsonElem.type()) {
            case NULL: {
                return this.decorateNElement(NElement.ofNull(), tsonElem);
            }
            case BYTE: {
                return this.decorateNElement(NElement.ofByte(tsonElem.byteValue(), DefaultTsonElementFormat.toTsonNumberLayout(((TsonNumber)tsonElem).numberLayout()), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case SHORT: {
                return this.decorateNElement(NElement.ofShort(tsonElem.shortValue(), DefaultTsonElementFormat.toTsonNumberLayout(((TsonNumber)tsonElem).numberLayout()), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case CHAR: {
                return this.decorateNElement(NElement.ofChar(Character.valueOf(tsonElem.charValue())), tsonElem);
            }
            case INTEGER: {
                return this.decorateNElement(NElement.ofInt(tsonElem.intValue(), DefaultTsonElementFormat.toTsonNumberLayout(((TsonNumber)tsonElem).numberLayout()), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case LONG: {
                return this.decorateNElement(NElement.ofLong(tsonElem.longValue(), DefaultTsonElementFormat.toTsonNumberLayout(((TsonNumber)tsonElem).numberLayout()), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case FLOAT: {
                return this.decorateNElement(NElement.ofFloat(tsonElem.floatValue(), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case DOUBLE: {
                return this.decorateNElement(NElement.ofDouble(tsonElem.doubleValue(), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case BIG_INTEGER: {
                return this.decorateNElement(NElement.ofBigInt(tsonElem.bigIntegerValue(), DefaultTsonElementFormat.toTsonNumberLayout(((TsonNumber)tsonElem).numberLayout()), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case BIG_DECIMAL: {
                return this.decorateNElement(NElement.ofBigDecimal(tsonElem.bigDecimalValue(), ((TsonNumber)tsonElem).numberSuffix()), tsonElem);
            }
            case DOUBLE_QUOTED_STRING: 
            case SINGLE_QUOTED_STRING: 
            case ANTI_QUOTED_STRING: 
            case TRIPLE_DOUBLE_QUOTED_STRING: 
            case TRIPLE_SINGLE_QUOTED_STRING: 
            case TRIPLE_ANTI_QUOTED_STRING: 
            case LINE_STRING: {
                return this.decorateNElement(NElement.ofString(tsonElem.toStr().stringValue(), this.toNStringLayout(tsonElem.toStr().type())), tsonElem);
            }
            case BOOLEAN: {
                return this.decorateNElement(NElement.ofBoolean(tsonElem.booleanValue()), tsonElem);
            }
            case INSTANT: {
                return this.decorateNElement(NElement.ofInstant(tsonElem.instantValue()), tsonElem);
            }
            case LOCAL_DATE: {
                return this.decorateNElement(NElement.ofLocalDate(tsonElem.localDateValue()), tsonElem);
            }
            case LOCAL_TIME: {
                return this.decorateNElement(NElement.ofLocalTime(tsonElem.localTimeValue()), tsonElem);
            }
            case LOCAL_DATETIME: {
                return this.decorateNElement(NElement.ofLocalDateTime(tsonElem.localDateTimeValue()), tsonElem);
            }
            case BIG_COMPLEX: {
                TsonBigComplex v = tsonElem.toBigComplex();
                return this.decorateNElement(NElement.ofBigComplex(v.real(), v.imag()), tsonElem);
            }
            case FLOAT_COMPLEX: {
                TsonFloatComplex v = tsonElem.toFloatComplex();
                return this.decorateNElement(NElement.ofFloatComplex(v.real(), v.imag()), tsonElem);
            }
            case DOUBLE_COMPLEX: {
                TsonDoubleComplex v = tsonElem.toDoubleComplex();
                return this.decorateNElement(NElement.ofDoubleComplex(v.real(), v.imag()), tsonElem);
            }
            case REGEX: {
                return this.decorateNElement(NElement.ofRegex(tsonElem.stringValue()), tsonElem);
            }
            case NAME: {
                return this.decorateNElement(NElement.ofName(tsonElem.stringValue()), tsonElem);
            }
            case ARRAY: 
            case NAMED_ARRAY: 
            case PARAMETRIZED_ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: {
                TsonArray array = tsonElem.toArray();
                NArrayElementBuilder u = NElement.ofArrayBuilder();
                for (TsonElement item : array) {
                    u.add(this.toNElem(item));
                }
                if (array.isNamed()) {
                    u.name(array.name());
                }
                if (array.isParametrized()) {
                    u.addParams(array.params().toList().stream().map(x -> this.toNElem((TsonElement)x)).collect(Collectors.toList()));
                }
                return this.decorateNElement(u.build(), tsonElem);
            }
            case OBJECT: 
            case NAMED_OBJECT: 
            case PARAMETRIZED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: {
                TsonObject obj = tsonElem.toObject();
                NObjectElementBuilder u = NElement.ofObjectBuilder();
                for (TsonElement item : obj) {
                    u.add(this.toNElem(item));
                }
                if (obj.isNamed()) {
                    u.name(obj.name());
                }
                if (obj.isParametrized()) {
                    u.addParams(obj.params().toList().stream().map(x -> this.toNElem((TsonElement)x)).collect(Collectors.toList()));
                }
                return this.decorateNElement(u.build(), tsonElem);
            }
            case UPLET: 
            case NAMED_UPLET: {
                TsonUplet obj = tsonElem.toUplet();
                NUpletElementBuilder u = NElement.ofUpletBuilder();
                for (TsonElement item : obj) {
                    u.add(this.toNElem(item));
                }
                if (obj.isNamed()) {
                    u.name(obj.name());
                }
                return this.decorateNElement(u.build(), tsonElem);
            }
            case PAIR: {
                TsonPair pair = tsonElem.toPair();
                NPairElementBuilder b = NElement.ofPairBuilder(this.toNElem(pair.key()), this.toNElem(pair.value()));
                return this.decorateNElement(b, tsonElem);
            }
            case OP: {
                TsonOp pair = tsonElem.toOp();
                TsonElement s = pair.second();
                NOperatorElementBuilder b = NElement.ofOpBuilder(NElementType.parse(pair.opName()).get(), this.toNElem(pair.first()), s == null ? null : this.toNElem(s));
                return this.decorateNElement(b, tsonElem);
            }
        }
        throw new IllegalArgumentException("not implemented Tson Type " + (Object)((Object)tsonElem.type()) + " in " + tsonElem);
    }

    private static NNumberLayout toTsonNumberLayout(TsonNumberLayout tsonElem) {
        if (tsonElem == null) {
            return null;
        }
        switch (tsonElem) {
            case OCTAL: {
                return NNumberLayout.OCTAL;
            }
            case DECIMAL: {
                return NNumberLayout.DECIMAL;
            }
            case HEXADECIMAL: {
                return NNumberLayout.HEXADECIMAL;
            }
            case BINARY: {
                return NNumberLayout.BINARY;
            }
        }
        throw new IllegalArgumentException("not implemented TsonNumberLayout " + (Object)((Object)tsonElem));
    }

    private NElementType toNStringLayout(TsonElementType layout) {
        if (layout == null) {
            return null;
        }
        switch (layout) {
            case DOUBLE_QUOTED_STRING: {
                return NElementType.DOUBLE_QUOTED_STRING;
            }
            case ANTI_QUOTED_STRING: {
                return NElementType.ANTI_QUOTED_STRING;
            }
            case TRIPLE_DOUBLE_QUOTED_STRING: {
                return NElementType.TRIPLE_DOUBLE_QUOTED_STRING;
            }
            case TRIPLE_SINGLE_QUOTED_STRING: {
                return NElementType.TRIPLE_SINGLE_QUOTED_STRING;
            }
            case TRIPLE_ANTI_QUOTED_STRING: {
                return NElementType.TRIPLE_ANTI_QUOTED_STRING;
            }
            case SINGLE_QUOTED_STRING: {
                return NElementType.SINGLE_QUOTED_STRING;
            }
            case LINE_STRING: {
                return NElementType.LINE_STRING;
            }
        }
        throw new IllegalArgumentException("not implemented Tson Type " + (Object)((Object)layout));
    }

    @Override
    public void printElement(NElement value, NPrintStream out, boolean compact, NElementFactoryContext context) {
        this.write(out, value, compact);
    }

    public TsonStreamParser fromReader(Reader reader, final Object source) {
        final TsonStreamParserImpl p = new TsonStreamParserImpl(reader);
        p.source(source);
        return new TsonStreamParser(){

            @Override
            public Object source() {
                return source;
            }

            @Override
            public void setConfig(TsonStreamParserConfig config) {
                p.setConfig(config);
            }

            @Override
            public void parseElement() {
                try {
                    p.parseElement();
                }
                catch (TokenMgrError e) {
                    throw JavaccHelper.createTsonParseException(e, source);
                }
                catch (ParseException e) {
                    throw JavaccHelper.createTsonParseException(e, source);
                }
            }

            @Override
            public void parseDocument() {
                try {
                    p.parseDocument();
                }
                catch (TokenMgrError e) {
                    throw JavaccHelper.createTsonParseException(e, source);
                }
                catch (ParseException e) {
                    throw JavaccHelper.createTsonParseException(e, source);
                }
            }
        };
    }
}

