/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.tree;

import java.util.AbstractMap;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.NIdFormatHelper;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArt;
import net.thevpc.nuts.text.NTextArtTreeRenderer;
import net.thevpc.nuts.text.NTreeFormat;
import net.thevpc.nuts.text.NTreeNode;
import net.thevpc.nuts.text.NTreeNodeFormat;

public class DefaultSearchFormatTree
extends DefaultSearchFormatBase {
    private Object lastObject;
    NTreeNodeFormat nTreeNodeFormat = new NTreeNodeFormat(){

        @Override
        public NText format(NTreeNode o, int depth) {
            NIdFormatHelper fid = NIdFormatHelper.of(o);
            if (fid != null) {
                return fid.getSingleColumnRow(DefaultSearchFormatTree.this.getDisplayOptions());
            }
            return o.value();
        }
    };

    public DefaultSearchFormatTree(NPrintStream writer, NFetchDisplayOptions options) {
        super(writer, NContentType.TREE, options);
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        return this.getDisplayOptions().configureFirst(cmdLine);
    }

    @Override
    public void start() {
    }

    @Override
    public void next(Object object, long index) {
        if (index > 0L) {
            this.formatElement(this.lastObject, index - 1L, false);
        }
        this.lastObject = object;
    }

    @Override
    public void complete(long count) {
        if (count > 0L) {
            this.formatElement(this.lastObject, count - 1L, true);
        }
    }

    public void formatElement(Object object, long index, boolean last) {
        NTextArtTreeRenderer treeRenderer = NTextArt.of().getTreeRenderer().get().setNodeFormat(this.nTreeNodeFormat).setOmitRoot(true).setInfinite(!last);
        this.getWriter().println(treeRenderer.render(NTreeFormat.of(new AbstractMap.SimpleEntry<String, Object>("ROOT", object)).getModel()));
        this.getWriter().flush();
    }
}

