/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.table;

import java.util.Arrays;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.runtime.standalone.format.NIdFormatHelper;
import net.thevpc.nuts.runtime.standalone.util.CoreEnumUtils;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMutableTableModel;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextArt;

public class DefaultSearchFormatTable
extends DefaultSearchFormatBase {
    private NMutableTableModel model;

    public DefaultSearchFormatTable(NPrintStream writer, NFetchDisplayOptions options) {
        super(writer, NContentType.TABLE, options);
    }

    public NMutableTableModel getTableModel() {
        if (this.model == null) {
            this.model = NMutableTableModel.of();
            NSession session = NSession.of();
            if (session.getOutputFormatOptions() != null) {
                for (String outputFormatOption : session.getOutputFormatOptions()) {
                    if (outputFormatOption == null) continue;
                }
            }
        }
        return this.model;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg a = cmdLine.peek().get();
        if (a == null) {
            return false;
        }
        return this.getDisplayOptions().configureFirst(cmdLine);
    }

    @Override
    public void start() {
        this.getTableModel().addHeaderRow((NText[])Arrays.stream(this.getDisplayOptions().getDisplayProperties()).map(x -> NText.of(CoreEnumUtils.getEnumString(x))).toArray(NText[]::new));
    }

    @Override
    public void next(Object object, long index) {
        NIdFormatHelper fid = NIdFormatHelper.of(object);
        if (fid != null) {
            this.formatElement(fid, index);
        } else {
            this.getTableModel().newRow().addCell(NText.of(object));
        }
        this.getWriter().flush();
    }

    public void formatElement(NIdFormatHelper id, long index) {
        this.getTableModel().newRow().addCells(id.getMultiColumnRow(this.getDisplayOptions()));
    }

    @Override
    public void complete(long count) {
        this.getWriter().println(NTextArt.of().getTableRenderer().get().render(this.getTableModel()));
    }
}

