/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.table;

import java.util.ArrayList;
import java.util.List;
import net.thevpc.nuts.text.NMutableTableModel;
import net.thevpc.nuts.text.NTableCell;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNMutableTableModel
implements NMutableTableModel {
    private final Row header = new Row();
    private final List<Row> rows = new ArrayList<Row>();

    @Override
    public NMutableTableModel newRow() {
        this.rows.add(new Row());
        return this;
    }

    @Override
    public NMutableTableModel clearHeader() {
        this.header.cells.clear();
        return this;
    }

    @Override
    public NMutableTableModel addHeaderRow(NText ... values) {
        for (NText value : values) {
            this.addHeaderCell(value);
        }
        return this;
    }

    @Override
    public NMutableTableModel addHeaderCell(NText value) {
        DefaultCell c = new DefaultCell();
        c.value = value;
        this.header.cells.add(c);
        return this;
    }

    @Override
    public NMutableTableModel addRow(NText ... values) {
        this.newRow();
        this.addCells(values);
        return this;
    }

    @Override
    public NMutableTableModel addCells(NText ... values) {
        for (NText value : values) {
            this.addCell(value);
        }
        return this;
    }

    @Override
    public NMutableTableModel addCell(NText value) {
        if (this.rows.isEmpty()) {
            this.newRow();
        }
        DefaultCell c = new DefaultCell();
        c.value = value;
        this.rows.get((int)(this.rows.size() - 1)).cells.add(c);
        return this;
    }

    @Override
    public int getColumnsCount() {
        int c = this.header.cells.size();
        for (Row row : this.rows) {
            c = Math.max(c, row.cells.size());
        }
        return c;
    }

    @Override
    public NText getCellValue(int row, int column) {
        return this.rows.get((int)row).cells.get((int)column).value;
    }

    @Override
    public int getCellColSpan(int row, int column) {
        return this.rows.get((int)row).cells.get((int)column).colspan;
    }

    @Override
    public int getCellRowSpan(int row, int column) {
        return this.rows.get((int)row).cells.get((int)column).rowspan;
    }

    @Override
    public NText getHeaderValue(int column) {
        return this.header.cells.get((int)column).value;
    }

    @Override
    public int getHeaderColSpan(int column) {
        return this.header.cells.get((int)column).colspan;
    }

    @Override
    public int getRowsCount() {
        return this.rows.size();
    }

    @Override
    public NMutableTableModel setCellValue(int column, int row, NText value) {
        this.rows.get((int)row).cells.get((int)column).value = value;
        return this;
    }

    @Override
    public NMutableTableModel setCellColSpan(int column, int row, int value) {
        this.rows.get((int)row).cells.get((int)column).colspan = value;
        return this;
    }

    @Override
    public NMutableTableModel setCellRowSpan(int column, int row, int value) {
        this.rows.get((int)row).cells.get((int)column).rowspan = value;
        return this;
    }

    @Override
    public NMutableTableModel setHeaderValue(int column, NText value) {
        this.header.cells.get((int)column).value = value;
        return this;
    }

    @Override
    public NMutableTableModel setHeaderColSpan(int column, int value) {
        this.header.cells.get((int)column).colspan = value;
        return this;
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    public static class Row {
        List<DefaultCell> cells = new ArrayList<DefaultCell>();
    }

    public static class DefaultCell
    implements NTableCell {
        int colspan = 1;
        int rowspan = 1;
        int x;
        int y;
        NText value;

        @Override
        public int getColspan() {
            return this.colspan;
        }

        @Override
        public DefaultCell setColspan(int colspan) {
            this.colspan = colspan <= 0 ? 1 : colspan;
            return this;
        }

        @Override
        public int getRowspan() {
            return this.rowspan;
        }

        @Override
        public DefaultCell setRowspan(int rowspan) {
            this.rowspan = rowspan <= 0 ? 1 : rowspan;
            return this;
        }

        @Override
        public int getX() {
            return this.x;
        }

        @Override
        public int getY() {
            return this.y;
        }

        @Override
        public NText getContent() {
            return this.value;
        }

        @Override
        public DefaultCell setContent(NText content) {
            this.value = content;
            return this;
        }

        public String toString() {
            return "Cell{" + this.x + "->" + (this.x + this.colspan) + ", " + this.y + "->" + (this.y + this.rowspan) + ", " + this.value + '}';
        }
    }
}

