/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.plain;

import java.util.ArrayList;
import java.util.Formattable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NContentTypeFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NUnsupportedArgumentException;

public class NFormatPlain
extends DefaultFormatBase<NContentTypeFormat>
implements NContentTypeFormat {
    private final String rootName = "";
    private final List<String> extraConfig = new ArrayList<String>();
    private final Map<String, String> multilineProperties = new HashMap<String, String>();
    private Object value;
    private boolean compact;

    public NFormatPlain() {
        super(NContentType.PLAIN.id() + "-format");
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public NContentTypeFormat setValue(Object value) {
        this.value = value;
        return this;
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg n = cmdLine.peek().orNull();
        if (n != null) {
            boolean enabled = n.isUncommented();
            NArg a = cmdLine.nextEntry("--multiline-property").orNull();
            if (a != null) {
                if (enabled) {
                    NArg i = NArg.of(a.getStringValue().get());
                    this.extraConfig.add(a.asString().get());
                    this.addMultilineProperty(i.key(), i.getStringValue().get());
                }
            } else {
                a = cmdLine.next().get();
                if (!a.isOption() || a.isUncommented()) {
                    this.extraConfig.add(a.asString().get());
                }
            }
            return true;
        }
        return false;
    }

    public NContentTypeFormat addMultilineProperty(String property, String separator) {
        this.multilineProperties.put(property, separator);
        return this;
    }

    private String getFormattedPrimitiveValue(NElement value) {
        switch (value.type()) {
            default: 
        }
        throw new NUnsupportedArgumentException(NMsg.ofC("invalid element type: %s", value.type()));
    }

    @Override
    public void print(NPrintStream w) {
        Object value = this.getValue();
        NText t = NText.of(value);
        NPrintStream out = this.getValidPrintStream(w);
        out.print(t);
        out.flush();
    }

    private NElementWriter ew() {
        return NElementWriter.of().setNtf(this.isNtf()).setCompact(this.isCompact()).configure(true, this.extraConfig.toArray(new String[0]));
    }

    private void collectFlags(Object value, Flags flags, int depth) {
        if (depth < 0) {
            return;
        }
        if (value instanceof Map) {
            flags.map = true;
            for (Map.Entry entry : ((Map)value).entrySet()) {
                this.collectFlags(entry.getKey(), flags, depth - 1);
                this.collectFlags(entry.getValue(), flags, depth - 1);
            }
        } else if (value instanceof List) {
            flags.list = true;
            Flags f2 = new Flags();
            for (Object entry : (List)value) {
                this.collectFlags(entry, f2, depth - 1);
            }
            if (f2.list || f2.map) {
                flags.map = true;
            }
            flags.elems |= f2.elems;
            flags.msg |= f2.msg;
            flags.primitives |= f2.primitives;
            flags.formattable |= f2.formattable;
        } else if (value instanceof Formattable) {
            flags.formattable = true;
        } else if (value instanceof NElement) {
            flags.elems = true;
            if (value instanceof NObjectElement) {
                flags.map = true;
            } else if (value instanceof NArrayElement) {
                flags.list = true;
            }
        } else if (value instanceof NMsg) {
            flags.msg = true;
        } else {
            flags.primitives = true;
        }
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NFormatPlain setNtf(boolean ntf) {
        return (NFormatPlain)super.setNtf(ntf);
    }

    public boolean isCompact() {
        return this.compact;
    }

    public NFormatPlain setCompact(boolean compact) {
        this.compact = compact;
        return this;
    }

    private static class Flags {
        boolean elems;
        boolean list;
        boolean map;
        boolean primitives;
        boolean msg;
        boolean formattable;

        private Flags() {
        }
    }
}

