/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.obj;

import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.runtime.standalone.format.obj.PathAndNbr;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NOptional;

public class RollingFileService {
    public static final String YYYY_M_MDD_H_HMMSS_SSS = "yyyyMMddHHmmssSSSSSS";
    private DecimalFormat doubleFormat;
    private String ps;
    private Pattern p;
    private NPath folder;
    private String fileName;
    private String filePatternSimple;
    private int count;

    public RollingFileService(NPath folder, int count) {
        this.count = count;
        int cc = String.valueOf(count).length();
        StringBuilder df = new StringBuilder();
        for (int i = 0; i < cc; ++i) {
            df.append('0');
        }
        this.doubleFormat = new DecimalFormat(df.toString());
        this.folder = folder.toAbsolute().getParent();
        if (this.folder == null) {
            this.folder = NPath.ofUserDirectory();
        }
        this.fileName = folder.getName();
        if (this.fileName.indexOf(35) < 0) {
            String b = folder.nameParts().getBaseName();
            String e = folder.nameParts().getExtension();
            this.fileName = b + "#" + e;
        }
        char[] t = this.fileName.toCharArray();
        StringBuilder sb1 = new StringBuilder();
        StringBuilder sb2 = new StringBuilder();
        boolean visited = false;
        block5: for (int j = 0; j < t.length; ++j) {
            char c = t[j];
            if (c == '#' || c == '*') {
                char pp;
                if (visited) {
                    throw new NoSuchElementException("already found */#");
                }
                visited = true;
                if (j > 0) {
                    pp = t[j - 1];
                    if (Character.isAlphabetic(pp) || Character.isLetterOrDigit(pp)) {
                        sb1.append('-');
                        sb2.append('-');
                    }
                    sb1.append("(?<t>\\d{" + YYYY_M_MDD_H_HMMSS_SSS.length() + "})-(?<n>\\d{1,10})");
                    sb2.append('#');
                }
                if (j >= t.length - 1 || !Character.isAlphabetic(pp = t[j + 1]) && !Character.isLetterOrDigit(pp)) continue;
                sb1.append('-');
                sb2.append('-');
                continue;
            }
            switch (c) {
                case '$': 
                case '(': 
                case ')': 
                case '/': 
                case ':': 
                case '<': 
                case '>': 
                case '?': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': {
                    throw new NIllegalArgumentException(NMsg.ofC("unsupported %s", Character.valueOf(c)));
                }
                case '.': {
                    sb1.append("[.]");
                    sb2.append(".");
                    continue block5;
                }
                default: {
                    sb1.append(c);
                    sb2.append(c);
                }
            }
        }
        String z = sb1.toString().trim();
        if (z.isEmpty()) {
            z = "(?<t>\\d{17})-(?<n>\\d{1,10})";
        }
        this.ps = z;
        z = sb2.toString().trim();
        if (z.isEmpty()) {
            z = "#";
        }
        this.filePatternSimple = z;
        this.p = Pattern.compile(this.ps);
    }

    public NPath roll() {
        PathAndNbr u;
        int i;
        List r = Arrays.stream(this.load()).map(x -> this.toPathAndNbr((NPath)x).get()).collect(Collectors.toList());
        int max = Math.min(this.count, r.size());
        for (i = r.size() - 1; i >= max; --i) {
            u = (PathAndNbr)r.get(i);
            u.p.delete();
        }
        for (i = max - 1; i >= 0; --i) {
            u = (PathAndNbr)r.get(i);
            if (i == this.count - 1) {
                u.p.delete();
                continue;
            }
            this.rename(u, i + 2);
        }
        return this.folder.resolve(this.nextFileName(Instant.now(), 1));
    }

    private String nextFileName(Instant instant, int number) {
        return this.filePatternSimple.replace("#", new SimpleDateFormat(YYYY_M_MDD_H_HMMSS_SSS).format(Date.from(instant)) + "-" + this.doubleFormat.format(number));
    }

    private void rename(PathAndNbr nPath, int i) {
        nPath.p.moveTo(this.folder.resolve(this.nextFileName(nPath.time, i)), NPathOption.REPLACE_EXISTING);
    }

    private NOptional<PathAndNbr> toPathAndNbr(NPath x) {
        Matcher matcher = this.p.matcher(x.getName());
        if (matcher.matches()) {
            String n = matcher.group("n");
            String t = matcher.group("t");
            Date localDateTime = null;
            try {
                localDateTime = new SimpleDateFormat(YYYY_M_MDD_H_HMMSS_SSS).parse(t);
            }
            catch (ParseException e) {
                return NOptional.ofEmpty();
            }
            Instant instant = localDateTime.toInstant();
            return NOptional.of(new PathAndNbr(x, instant, new BigInteger(n)));
        }
        return NOptional.ofEmpty();
    }

    private NPath[] load() {
        return (NPath[])this.folder.list().stream().map(x -> this.toPathAndNbr((NPath)x).orNull()).filter(x -> x != null).sorted().map(x -> x.p).toArray(NPath[]::new);
    }
}

