/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.json;

import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.text.NMsg;

public class JsonStatus {
    public int countBraces;
    public int openBraces;
    public int openBrackets;
    public boolean openAntiSlash;
    public boolean openSimpleQuotes;
    public boolean openDoubleQuotes;

    public boolean checkValid(boolean throwError) {
        if (!this.checkPartialValid(throwError)) {
            return false;
        }
        if (this.countBraces == 0) {
            if (throwError) {
                throw new NParseException(NMsg.ofPlain("not an object"));
            }
            return false;
        }
        if (this.openBrackets > 0) {
            if (throwError) {
                throw new NParseException(NMsg.ofPlain("unbalanced brackets"));
            }
            return false;
        }
        if (this.openBraces > 0) {
            if (throwError) {
                throw new NParseException(NMsg.ofPlain("unbalanced braces"));
            }
            return false;
        }
        if (this.openAntiSlash && throwError) {
            throw new NParseException(NMsg.ofPlain("unbalanced anti-slash"));
        }
        if (this.openSimpleQuotes) {
            if (throwError) {
                throw new NParseException(NMsg.ofPlain("unbalanced simple quotes"));
            }
            return false;
        }
        if (this.openDoubleQuotes) {
            if (throwError) {
                throw new NParseException(NMsg.ofPlain("unbalanced double quotes"));
            }
            return false;
        }
        return true;
    }

    public boolean checkPartialValid(boolean throwError) {
        if (this.openBrackets < 0) {
            if (throwError) {
                throw new NParseException(NMsg.ofPlain("unbalanced brackets"));
            }
            return false;
        }
        if (this.openBraces < 0) {
            if (throwError) {
                throw new NParseException(NMsg.ofPlain("unbalanced braces"));
            }
            return false;
        }
        return true;
    }
}

