/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format.json;

import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.elem.NElementWriter;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.DefaultSearchFormatBase;
import net.thevpc.nuts.runtime.standalone.format.NFetchDisplayOptions;
import net.thevpc.nuts.spi.NCodeHighlighter;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTexts;

public class DefaultSearchFormatJson
extends DefaultSearchFormatBase {
    private boolean compact;
    NTexts txt = NTexts.of();
    private NCodeHighlighter codeFormat = NTexts.of().getCodeHighlighter("json");

    public DefaultSearchFormatJson(NPrintStream writer, NFetchDisplayOptions options) {
        super(writer, NContentType.JSON, options);
    }

    @Override
    public void start() {
        this.getWriter().println(this.codeFormat.tokenToText("[", "separator", this.txt));
        this.getWriter().flush();
    }

    @Override
    public void complete(long count) {
        this.getWriter().println(this.codeFormat.tokenToText("]", "separator", this.txt));
        this.getWriter().flush();
    }

    @Override
    public boolean configureFirst(NCmdLine cmdLine) {
        NArg aa = cmdLine.peek().get();
        if (aa == null) {
            return false;
        }
        if (this.getDisplayOptions().configureFirst(cmdLine)) {
            return true;
        }
        switch (aa.key()) {
            case "--compact": {
                cmdLine.matcher().matchFlag(v -> {
                    this.compact = v.booleanValue();
                }).anyMatch();
                return true;
            }
        }
        return false;
    }

    @Override
    public void next(Object object, long index) {
        if (index > 0L) {
            this.getWriter().print(", ");
        } else {
            this.getWriter().print("  ");
        }
        String json = NElementWriter.ofJson().setCompact(this.isCompact()).toString(object);
        NText ee = this.codeFormat.stringToText(json, this.txt);
        this.getWriter().println(ee);
        this.getWriter().flush();
    }

    public boolean isCompact() {
        return this.compact;
    }
}

