/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NDependencyBuilder;
import net.thevpc.nuts.artifact.NDescriptor;
import net.thevpc.nuts.artifact.NDescriptorBuilder;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.io.NContentMetadataProviderFormatSPI;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.runtime.standalone.format.NDescriptorInputSourceFormatSPI;
import net.thevpc.nuts.runtime.standalone.format.NDurationFormatSPI;
import net.thevpc.nuts.runtime.standalone.format.impl.NChronometerNFormatSPI;
import net.thevpc.nuts.runtime.standalone.io.path.NCompressedPath;
import net.thevpc.nuts.runtime.standalone.io.path.NCompressedPathBase;
import net.thevpc.nuts.runtime.standalone.io.path.NFormatFromSPI;
import net.thevpc.nuts.runtime.standalone.io.path.NPathBase;
import net.thevpc.nuts.runtime.standalone.io.path.NPathFromSPI;
import net.thevpc.nuts.runtime.standalone.io.printstream.NByteArrayPrintStream;
import net.thevpc.nuts.runtime.standalone.io.printstream.OutputStreamExt;
import net.thevpc.nuts.runtime.standalone.io.printstream.OutputTargetExt;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamExt;
import net.thevpc.nuts.runtime.standalone.io.util.InputStreamTee;
import net.thevpc.nuts.runtime.standalone.io.util.NInputStreamSource;
import net.thevpc.nuts.runtime.standalone.io.util.NNonBlockingInputStreamAdapter;
import net.thevpc.nuts.runtime.standalone.reflect.NUseDefaultUtils;
import net.thevpc.nuts.runtime.standalone.xtra.digest.DefaultNDigest;
import net.thevpc.nuts.spi.NFormatSPI;
import net.thevpc.nuts.spi.NPathSPI;
import net.thevpc.nuts.text.NCmdLineFormat;
import net.thevpc.nuts.text.NDependencyFormat;
import net.thevpc.nuts.text.NDescriptorFormat;
import net.thevpc.nuts.text.NExecCmdFormat;
import net.thevpc.nuts.text.NFormat;
import net.thevpc.nuts.text.NFormats;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NVersionFormat;
import net.thevpc.nuts.time.NChronometer;
import net.thevpc.nuts.time.NDuration;
import net.thevpc.nuts.util.NClassMap;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class NFormatsImpl
implements NFormats {
    private NClassMap<NFormatMapper> mapper = new NClassMap<NFormatMapper>(NFormatMapper.class);

    public NFormatsImpl() {
        this.registerDefaults();
    }

    private void register(Class clz, NFormatMapper mapper) {
        if (mapper == null) {
            this.mapper.remove(clz);
        } else {
            this.mapper.put(clz, mapper);
        }
    }

    @Override
    public NOptional<NFormat> ofFormat(Object t) {
        NFormat n;
        if (t == null) {
            return NOptional.ofNamedEmpty("null");
        }
        if (t instanceof NText) {
            return NOptional.of((NFormat)t);
        }
        Class<?> c = t.getClass();
        NFormatMapper e = this.mapper.get(c);
        if (e != null && (n = e.ofFormat(t, this)) != null) {
            return NOptional.of(n);
        }
        return NOptional.ofNamedEmpty("format for " + t.getClass().getSimpleName());
    }

    private void registerDefaults() {
        this.register(NExecCmd.class, (o, f) -> NExecCmdFormat.of().setValue((NExecCmd)o));
        this.register(NVersion.class, (o, f) -> NVersionFormat.of().setVersion((NVersion)o));
        this.register(NId.class, (o, f) -> NIdFormat.of().setValue((NId)o));
        this.register(NIdBuilder.class, (o, f) -> NIdFormat.of().setValue(((NIdBuilder)o).build()));
        this.register(NDescriptor.class, (o, f) -> NDescriptorFormat.of().setValue((NDescriptor)o));
        this.register(NDescriptorBuilder.class, (o, f) -> NDescriptorFormat.of().setValue(((NDescriptorBuilder)o).build()));
        this.register(NDependency.class, (o, f) -> NDependencyFormat.of().setValue((NDependency)o));
        this.register(NDependencyBuilder.class, (o, f) -> NDependencyFormat.of().setValue(((NDependencyBuilder)o).build()));
        this.register(NCmdLine.class, (o, f) -> NCmdLineFormat.of().setValue((NCmdLine)o));
        this.register(NCompressedPath.class, (o, f) -> new NCompressedPath.MyPathFormat((NCompressedPath)o));
        this.register(NCompressedPathBase.class, (o, f) -> new NCompressedPathBase.MyPathFormat((NCompressedPathBase)o));
        this.register(NPathBase.class, (o, f) -> new NPathBase.PathFormat((NPathBase)o));
        this.register(NFormatSPI.class, (o, f) -> NFormat.of((NFormatSPI)o));
        this.register(NChronometer.class, (o, f) -> NFormat.of(new NChronometerNFormatSPI((NChronometer)o)));
        this.register(NDuration.class, (o, f) -> NFormat.of(new NDurationFormatSPI((NDuration)o)));
        this.register(NByteArrayPrintStream.MyAbstractMultiReadNInputSource.class, (o, f) -> f.ofFormat(((NByteArrayPrintStream.MyAbstractMultiReadNInputSource)o).getValue()).get());
        this.register(InputStreamExt.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((InputStreamExt)o, ((InputStreamExt)o).getSourceName(), "input-stream")));
        this.register(InputStreamTee.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((InputStreamTee)o, null, "input-stream-tee")));
        this.register(OutputStreamExt.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((OutputStreamExt)o, null, "output-stream")));
        this.register(NNonBlockingInputStreamAdapter.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((NNonBlockingInputStreamAdapter)o, ((NNonBlockingInputStreamAdapter)o).getSourceName(), "input-stream")));
        this.register(NInputStreamSource.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((NInputStreamSource)o, null, "input-stream")));
        this.register(NPrintStream.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((NPrintStream)o, null, "print-stream")));
        this.register(OutputTargetExt.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((OutputTargetExt)o, ((OutputTargetExt)o).getSourceName(), "output-stream")));
        this.register(OutputTargetExt.class, (o, f) -> NFormat.of(new NContentMetadataProviderFormatSPI((OutputTargetExt)o, ((OutputTargetExt)o).getSourceName(), "output-stream")));
        this.register(DefaultNDigest.NDescriptorInputSource.class, (o, f) -> NFormat.of(new NDescriptorInputSourceFormatSPI((DefaultNDigest.NDescriptorInputSource)o)));
        this.register(NPathFromSPI.class, (o, f) -> {
            NPathFromSPI b = (NPathFromSPI)o;
            NPathSPI base = ((NPathFromSPI)o).getBase();
            NFormatSPI fspi = null;
            if (!NUseDefaultUtils.isUseDefault(base.getClass(), "formatter", NPath.class)) {
                fspi = base.formatter(b);
            }
            if (fspi != null) {
                return new NFormatFromSPI(fspi);
            }
            return new NPathBase.PathFormat((NPathBase)o);
        });
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    private static interface NFormatMapper {
        public NFormat ofFormat(Object var1, NFormats var2);
    }
}

