/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NDisplayProperty implements NEnum
{
    STATUS,
    INSTALL_DATE,
    INSTALL_USER,
    INSTALL_FOLDER,
    REPOSITORY,
    REPOSITORY_ID,
    ID,
    NAME,
    ARCH,
    PACKAGING,
    PLATFORM,
    PROFILE,
    DESKTOP_ENVIRONMENT,
    OS,
    OSDIST,
    EXEC_ENTRY,
    FILE_NAME,
    FILE,
    VAR_LOCATION,
    TEMP_FOLDER,
    CONF_FOLDER,
    LIB_FOLDER,
    LOG_FOLDER,
    CACHE_FOLDER,
    BIN_FOLDER,
    LONG_STATUS;

    private String id = NNameFormat.ID_NAME.format(this.name());

    @Override
    public String id() {
        return this.id;
    }

    public static NOptional<NDisplayProperty> parse(String value) {
        return NEnumUtils.parseEnum(value, NDisplayProperty.class, s -> {
            switch (s.getNormalizedValue()) {
                case "DE": 
                case "DESKTOP": {
                    return NOptional.of(DESKTOP_ENVIRONMENT);
                }
                case "OSDIST": {
                    return NOptional.of(OSDIST);
                }
                case "REPO": {
                    return NOptional.of(REPOSITORY);
                }
                case "REPO_ID": 
                case "REPOID": {
                    return NOptional.of(REPOSITORY_ID);
                }
            }
            return null;
        });
    }
}

