/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.format;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.Path;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NMemoryPrintStream;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.runtime.standalone.format.DefaultFormatBase0;
import net.thevpc.nuts.text.NFormat;
import net.thevpc.nuts.text.NText;

public abstract class DefaultFormatBase<T extends NFormat>
extends DefaultFormatBase0<T>
implements NFormat {
    public DefaultFormatBase(String name) {
        super(name);
    }

    @Override
    public NPrintStream getValidPrintStream(NPrintStream out) {
        if (out == null) {
            out = NOut.out();
        }
        return out;
    }

    @Override
    public NPrintStream getValidPrintStream() {
        return this.getValidPrintStream(null);
    }

    @Override
    public NText format() {
        if (this.isNtf()) {
            NMemoryPrintStream out = NMemoryPrintStream.of(NTerminalMode.FORMATTED);
            this.print(out);
            return NText.of(out.toString());
        }
        NMemoryPrintStream out = NMemoryPrintStream.of(NTerminalMode.INHERITED);
        this.print(out);
        return NText.ofPlain(out.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String formatPlain() {
        boolean ntf = this.isNtf();
        try {
            NMemoryPrintStream out = NPrintStream.ofMem(NTerminalMode.INHERITED);
            this.print(out);
            String string = out.toString();
            return string;
        }
        finally {
            this.setNtf(ntf);
        }
    }

    @Override
    public void print() {
        NSession session = NSession.of();
        this.print(session.getTerminal());
    }

    @Override
    public void println() {
        NSession session = NSession.of();
        this.println(session.getTerminal());
    }

    @Override
    public abstract void print(NPrintStream var1);

    @Override
    public void print(Writer out) {
        if (out == null) {
            NPrintStream pout = this.getValidPrintStream();
            this.print(pout);
            pout.flush();
        } else {
            NPrintStream pout = NPrintStream.of(out);
            this.print(pout);
            pout.flush();
        }
    }

    @Override
    public void print(OutputStream out) {
        NPrintStream p = out == null ? this.getValidPrintStream() : NPrintStream.of(out);
        this.print(p);
        p.flush();
    }

    @Override
    public void print(Path path) {
        this.print(NPath.of(path));
    }

    @Override
    public void print(NPath path) {
        path.mkParentDirs();
        try (Writer w = path.getWriter();){
            this.print(w);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void print(File file) {
        this.print(NPath.of(file));
    }

    @Override
    public void print(NTerminal terminal) {
        NSession session = NSession.of();
        this.print(terminal == null ? session.getTerminal().out() : terminal.out());
    }

    @Override
    public void println(Writer w) {
        if (w == null) {
            NPrintStream pout = this.getValidPrintStream();
            this.println(pout);
            pout.flush();
        } else {
            NPrintStream pout = NPrintStream.of(w);
            this.println(pout);
            pout.flush();
        }
    }

    @Override
    public void println(NPrintStream out) {
        NPrintStream p = this.getValidPrintStream(out);
        this.print(out);
        p.println();
        p.flush();
    }

    @Override
    public void println(OutputStream out) {
        if (out == null) {
            NPrintStream pout = this.getValidPrintStream();
            this.println(pout);
            pout.flush();
        } else {
            NPrintStream pout = NPrintStream.of(out);
            this.println(pout);
            pout.flush();
        }
    }

    @Override
    public void println(Path path) {
        this.println(NPath.of(path));
    }

    @Override
    public void println(NPath out) {
        out.mkParentDirs();
        try (Writer w = out.getWriter();){
            this.println(w);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public void println(NTerminal terminal) {
        NSession session = NSession.of();
        this.println(terminal == null ? session.getTerminal().out() : terminal.out());
    }

    @Override
    public void println(File file) {
        this.println(file.toPath());
    }

    @Override
    public String toString() {
        return this.formatPlain();
    }
}

