/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;

public class NExtensionListHelper {
    private List<NWorkspaceConfigBoot.ExtensionConfig> initial = new ArrayList<NWorkspaceConfigBoot.ExtensionConfig>();
    private List<NWorkspaceConfigBoot.ExtensionConfig> list = new ArrayList<NWorkspaceConfigBoot.ExtensionConfig>();
    private NId apiId;

    public NExtensionListHelper(NId apiId, List<NWorkspaceConfigBoot.ExtensionConfig> old) {
        this.apiId = apiId;
        if (old != null) {
            for (NWorkspaceConfigBoot.ExtensionConfig a : old) {
                if (a == null) continue;
                this.list.add(a);
            }
        }
    }

    public NExtensionListHelper save() {
        this.initial = new ArrayList<NWorkspaceConfigBoot.ExtensionConfig>(this.list);
        this.compress();
        return this;
    }

    public boolean hasChanged() {
        return !this.initial.equals(this.list);
    }

    public NExtensionListHelper copy() {
        return new NExtensionListHelper(this.apiId, this.list);
    }

    public NExtensionListHelper compress() {
        LinkedHashMap<String, NWorkspaceConfigBoot.ExtensionConfig> m = new LinkedHashMap<String, NWorkspaceConfigBoot.ExtensionConfig>();
        for (NWorkspaceConfigBoot.ExtensionConfig id : this.list) {
            m.put(id.getId().getShortName(), new NWorkspaceConfigBoot.ExtensionConfig(id.getId().getLongId(), id.getDependencies(), id.isEnabled()));
        }
        this.list.clear();
        this.list.addAll(m.values());
        return this;
    }

    public boolean add(NId id, List<NDependency> dependencies) {
        String dependenciesString = dependencies.stream().map(Object::toString).collect(Collectors.joining(";"));
        for (int i = 0; i < this.list.size(); ++i) {
            NWorkspaceConfigBoot.ExtensionConfig z;
            NWorkspaceConfigBoot.ExtensionConfig o;
            NWorkspaceConfigBoot.ExtensionConfig a = this.list.get(i);
            if (!a.getId().getShortName().equals(id.getShortName()) || Objects.equals(o = this.list.get(i), z = new NWorkspaceConfigBoot.ExtensionConfig(id, dependenciesString, true))) continue;
            this.list.set(i, z);
            return true;
        }
        NWorkspaceConfigBoot.ExtensionConfig z = new NWorkspaceConfigBoot.ExtensionConfig(id, dependenciesString, true);
        this.list.add(z);
        return true;
    }

    public boolean remove(NId id) {
        for (int i = 0; i < this.list.size(); ++i) {
            NWorkspaceConfigBoot.ExtensionConfig a = this.list.get(i);
            if (!a.getId().getShortName().equals(id.getShortName())) continue;
            this.list.remove(i);
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + Objects.hashCode(this.list);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NExtensionListHelper other = (NExtensionListHelper)obj;
        return Objects.equals(this.list, other.list);
    }

    public List<NId> getIds() {
        ArrayList<NId> ids = new ArrayList<NId>();
        for (NWorkspaceConfigBoot.ExtensionConfig i : this.list) {
            ids.add(i.getId());
        }
        return ids;
    }

    public List<NWorkspaceConfigBoot.ExtensionConfig> getConfs() {
        ArrayList<NWorkspaceConfigBoot.ExtensionConfig> copy = new ArrayList<NWorkspaceConfigBoot.ExtensionConfig>();
        for (NWorkspaceConfigBoot.ExtensionConfig i : this.list) {
            copy.add(new NWorkspaceConfigBoot.ExtensionConfig(i.getId(), i.getDependencies(), i.isEnabled()));
        }
        return copy;
    }
}

