/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdType;
import net.thevpc.nuts.boot.NBootWorkspaceFactory;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.command.NSearchCmd;
import net.thevpc.nuts.core.NBootOptions;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceExtension;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.ext.NExtensionAlreadyRegisteredException;
import net.thevpc.nuts.ext.NExtensionInformation;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NServiceLoader;
import net.thevpc.nuts.io.NTerminal;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.net.NWebCli;
import net.thevpc.nuts.runtime.standalone.dependency.util.NClassLoaderUtils;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNClassLoader;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNExtensionInformation;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNServiceLoader;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNWorkspaceExtension;
import net.thevpc.nuts.runtime.standalone.id.util.CoreNIdUtils;
import net.thevpc.nuts.runtime.standalone.io.printstream.NFormattedPrintStream;
import net.thevpc.nuts.runtime.standalone.io.terminal.DefaultNTerminalFromSystem;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.filters.CoreFilterUtils;
import net.thevpc.nuts.runtime.standalone.workspace.DefaultNWorkspaceFactory;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceFactory;
import net.thevpc.nuts.runtime.standalone.workspace.config.NWorkspaceConfigBoot;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringTokenizerUtils;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.spi.NDefaultTerminalSpec;
import net.thevpc.nuts.spi.NDescriptorContentParserComponent;
import net.thevpc.nuts.spi.NExecutorComponent;
import net.thevpc.nuts.spi.NExtensionLifeCycle;
import net.thevpc.nuts.spi.NInstallerComponent;
import net.thevpc.nuts.spi.NRepositoryFactoryComponent;
import net.thevpc.nuts.spi.NSystemTerminalBase;
import net.thevpc.nuts.spi.NTerminalSpec;
import net.thevpc.nuts.spi.NWorkspaceArchetypeComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NListValueMap;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;

public class DefaultNWorkspaceExtensionModel {
    private static Set<String> JRE_JAR_FILE_NAMES = new HashSet<String>(Arrays.asList("rt.jar", "charsets.jar", "jce.jar", "jfr.jar", "jsse.jar", "management-agent.jar", "resources.jar"));
    private NLog LOG;
    private final Set<Class> SUPPORTED_EXTENSION_TYPES = new HashSet<Class>(Arrays.asList(NFormattedPrintStream.class, NSystemTerminalBase.class, NTerminal.class, NDescriptorContentParserComponent.class, NExecutorComponent.class, NInstallerComponent.class, NRepositoryFactoryComponent.class, NWebCli.class, NWorkspace.class, NWorkspaceArchetypeComponent.class));
    private final NListValueMap<String, String> defaultWiredComponents = new NListValueMap();
    private final Set<String> exclusions = new HashSet<String>();
    private final NWorkspace workspace;
    private final NBootWorkspaceFactory bootFactory;
    private final NWorkspaceFactory objectFactory;
    private DefaultNClassLoader workspaceExtensionsClassLoader;
    private Map<NURLClassLoaderKey, DefaultNClassLoader> cachedClassLoaders = new HashMap<NURLClassLoaderKey, DefaultNClassLoader>();
    private Map<NId, NWorkspaceExtension> extensions = new HashMap<NId, NWorkspaceExtension>();
    private Set<NId> loadedExtensionIds = new LinkedHashSet<NId>();
    private Set<URL> loadedExtensionURLs = new LinkedHashSet<URL>();
    private Set<NId> unloadedExtensions = new LinkedHashSet<NId>();

    public DefaultNWorkspaceExtensionModel(NWorkspace workspace, NBootWorkspaceFactory bootFactory, List<String> excludedExtensions) {
        this.workspace = workspace;
        this.objectFactory = new DefaultNWorkspaceFactory(workspace);
        this.bootFactory = bootFactory;
        this.setExcludedExtensions(excludedExtensions);
    }

    protected NLog _LOG() {
        return NLog.of(DefaultNWorkspaceExtensionModel.class);
    }

    public boolean isExcludedExtension(NId excluded) {
        return this.exclusions.contains(excluded.getShortName());
    }

    public void setExcludedExtensions(List<String> excluded) {
        this.exclusions.clear();
        if (excluded != null) {
            for (String ex : excluded) {
                for (String e : StringTokenizerUtils.splitDefault(ex)) {
                    NId ee = NId.get(e).orNull();
                    if (ee == null) continue;
                    this.exclusions.add(ee.getShortName());
                }
            }
        }
    }

    public List<NExtensionInformation> findWorkspaceExtensions() {
        return this.findWorkspaceExtensions(this.workspace.getApiVersion().toString());
    }

    public List<NExtensionInformation> findWorkspaceExtensions(String version) {
        if (version == null) {
            version = this.workspace.getApiVersion().toString();
        }
        NId id = this.workspace.getApiId().builder().setVersion(version).build();
        return this.findExtensions(id, "extensions");
    }

    public List<NExtensionInformation> findExtensions(String id, String extensionType) {
        return this.findExtensions(NId.get(id).get(), extensionType);
    }

    public List<NExtensionInformation> findExtensions(NId id, String extensionType) {
        NAssert.requireNonBlank(id.getVersion(), "version");
        ArrayList<NExtensionInformation> ret = new ArrayList<NExtensionInformation>();
        ArrayList<String> allUrls = new ArrayList<String>();
        for (String r : this.getExtensionRepositoryLocations(id)) {
            String url = r + "/" + id.getMavenPath(extensionType);
            allUrls.add(url);
            URL u = this.expandURL(url);
            if (u == null) continue;
            NExtensionInformation[] s = new NExtensionInformation[]{};
            try (InputStreamReader rr = new InputStreamReader(NPath.of(u).getInputStream());){
                s = NElementParser.ofJson().parse(rr, DefaultNExtensionInformation[].class);
            }
            catch (IOException ex) {
                this._LOG().log(NMsg.ofC("failed to parse NutsExtensionInformation from %s : %s", u, ex).asError(ex));
            }
            if (s == null) continue;
            for (NExtensionInformation nutsExtensionInfo : s) {
                ((DefaultNExtensionInformation)nutsExtensionInfo).setSource(u.toString());
                ret.add(nutsExtensionInfo);
            }
        }
        boolean latestVersion = true;
        if (latestVersion && ret.size() > 1) {
            return CoreFilterUtils.filterNutsExtensionInfoByLatestVersion(ret);
        }
        return ret;
    }

    public List<RegInfo> buildRegInfos() {
        ArrayList<RegInfo> a = new ArrayList<RegInfo>();
        Set<Class<NComponent>> loadedExtensions = this.getExtensionTypes(NComponent.class);
        for (Class<NComponent> extensionImpl : loadedExtensions) {
            for (Class<? extends NComponent> extensionPointType : this.resolveComponentTypes(extensionImpl)) {
                a.add(new RegInfo(extensionPointType, extensionImpl, null));
            }
        }
        return a;
    }

    private boolean isJRELib(NPath path) {
        String jh = System.getProperty("java.home");
        try {
            String p;
            File f;
            if (path.isFile() && (f = path.toFile().orNull()) != null && ((p = f.getPath()).startsWith(jh + "/") || p.startsWith(jh + "\\"))) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void onInitializeWorkspace(NBootOptions bOptions, ClassLoader bootClassLoader) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        boolean resolveClassPathUrls = false;
        if (resolveClassPathUrls) {
            URL[] urls = NClassLoaderUtils.resolveClasspathURLs(contextClassLoader);
            class PathAndUrl {
                URL url;
                NPath path;

                public PathAndUrl(URL url, NPath path) {
                    this.url = url;
                    this.path = path;
                }
            }
            PathAndUrl[] valid = (PathAndUrl[])Arrays.stream(urls).map(url -> {
                try {
                    NPath path = NPath.of(url);
                    if (!this.isJRELib(path)) {
                        return new PathAndUrl((URL)url, path);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }).filter(Objects::nonNull).toArray(x$0 -> new PathAndUrl[x$0]);
            this._LOG().log(NMsg.ofC("initialize workspace extensions from %s/%s urls : %s", valid.length, urls.length, Arrays.asList(urls)).asFine().withIntent(NMsgIntent.NOTICE));
            for (PathAndUrl v : valid) {
                this.objectFactory.discoverTypes(CoreNIdUtils.resolveOrGenerateIdFromFileName(v.path), v.url, bootClassLoader);
            }
        }
        this.objectFactory.discoverTypes(null, null, bootClassLoader);
        if (!bOptions.getRuntimeBootDependencyNode().isBlank()) {
            this.objectFactory.discoverTypes(bOptions.getRuntimeBootDependencyNode().get().getId(), bOptions.getRuntimeBootDependencyNode().get().getURL(), bootClassLoader);
        }
        for (NClassLoaderNode idurl : bOptions.getExtensionBootDependencyNodes().orElseGet(Collections::emptyList)) {
            if (idurl.getId() == null) continue;
            this.objectFactory.discoverTypes(idurl.getId(), idurl.getURL(), bootClassLoader);
        }
        this.workspaceExtensionsClassLoader = new DefaultNClassLoader("workspaceExtensionsClassLoader", bootClassLoader);
    }

    public <T extends NComponent> boolean installWorkspaceExtensionComponent(Class<T> extensionPointType, T extensionImpl) {
        if (NComponent.class.isAssignableFrom(extensionPointType)) {
            if (extensionPointType.isInstance(extensionImpl)) {
                return this.registerInstance(extensionPointType, extensionImpl);
            }
            throw new ClassCastException(extensionImpl.getClass().getName());
        }
        throw new ClassCastException(NComponent.class.getName());
    }

    public Set<Class<? extends NComponent>> discoverTypes(NId id, ClassLoader classLoader) {
        URL url = NFetchCmd.of(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultContent().toURL().get();
        return this.objectFactory.discoverTypes(id, url, classLoader);
    }

    public <T extends NComponent, B> NServiceLoader<T> createServiceLoader(Class<T> serviceType, Class<B> criteriaType) {
        return this.createServiceLoader(serviceType, criteriaType, null);
    }

    public <T extends NComponent, B> NServiceLoader<T> createServiceLoader(Class<T> serviceType, Class<B> criteriaType, ClassLoader classLoader) {
        return new DefaultNServiceLoader<T, B>(this.workspace, serviceType, criteriaType, classLoader);
    }

    public <T extends NComponent, V> NOptional<T> createSupported(Class<T> type, V supportCriteria) {
        return this.objectFactory.createComponent(type, supportCriteria);
    }

    public <T extends NComponent, V> List<T> createAllSupported(Class<T> type, V supportCriteria) {
        return this.objectFactory.createComponents(type, supportCriteria);
    }

    public <T extends NComponent> List<T> createAll(Class<T> type) {
        return this.objectFactory.createAll(type);
    }

    public <T extends NComponent> Set<Class<? extends T>> getExtensionTypes(Class<T> extensionPoint) {
        return this.objectFactory.getExtensionTypes(extensionPoint);
    }

    public <T extends NComponent> List<T> getExtensionObjects(Class<T> extensionPoint) {
        return this.objectFactory.getExtensionObjects(extensionPoint);
    }

    public <T extends NComponent> boolean isRegisteredType(Class<T> extensionPointType, String name) {
        return this.objectFactory.isRegisteredType(extensionPointType, name);
    }

    public <T extends NComponent> boolean isRegisteredInstance(Class<T> extensionPointType, T extensionImpl) {
        return this.objectFactory.isRegisteredInstance(extensionPointType, extensionImpl);
    }

    public <T extends NComponent> boolean registerInstance(Class<T> extensionPointType, T extensionImpl) {
        if (!this.isRegisteredType(extensionPointType, extensionImpl.getClass().getName()) && !this.isRegisteredInstance(extensionPointType, extensionImpl)) {
            this.objectFactory.registerInstance(extensionPointType, extensionImpl);
            return true;
        }
        this._LOG().log(NMsg.ofC("Bootstrap Extension Point %s => %s ignored. Already registered", extensionPointType.getName(), extensionImpl.getClass().getName()).asFineAlert());
        return false;
    }

    public boolean registerType(Class extensionPointType, Class extensionType, NId source) {
        if (!this.isRegisteredType(extensionPointType, extensionType.getName()) && !this.isRegisteredType(extensionPointType, extensionType)) {
            this.objectFactory.registerType(extensionPointType, extensionType, source);
            return true;
        }
        this._LOG().log(NMsg.ofC("Bootstrap Extension Point %s => %s ignored. Already registered", extensionPointType.getName(), extensionType.getName()).withLevel(Level.FINE).withIntent(NMsgIntent.ALERT));
        return false;
    }

    public boolean isRegisteredType(Class extensionPointType, Class extensionType) {
        return this.objectFactory.isRegisteredType(extensionPointType, extensionType);
    }

    public boolean isLoadedExtensions(NId id) {
        return this.loadedExtensionIds.stream().anyMatch(x -> x.getShortName().equals(id.getShortName()));
    }

    public List<NId> getLoadedExtensions() {
        return new ArrayList<NId>(this.loadedExtensionIds);
    }

    public void loadExtension(NId extension) {
        this.loadExtensions(extension);
    }

    public void unloadExtension(NId extension) {
        this.unloadExtensions(new NId[]{extension});
    }

    public List<NId> getConfigExtensions() {
        if (this.getStoredConfig().getExtensions() != null) {
            return Collections.unmodifiableList(new ArrayList<NWorkspaceConfigBoot.ExtensionConfig>(this.getStoredConfig().getExtensions()).stream().map(NWorkspaceConfigBoot.ExtensionConfig::getId).collect(Collectors.toList()));
        }
        return Collections.emptyList();
    }

    public void loadExtensions(NId ... extensions) {
        boolean someUpdates = false;
        for (NId extension : extensions) {
            if (extension == null || this.loadedExtensionIds.contains(extension = extension.builder().setVersion("").build())) continue;
            if (this.unloadedExtensions.contains(extension)) {
                this.loadedExtensionIds.add(extension);
                someUpdates = true;
                continue;
            }
            NDefinition def = NSearchCmd.of().addId(extension).setTargetApiVersion(this.workspace.getApiVersion()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).getResultDefinitions().findFirst().get();
            if (def == null || def.getContent().isNotPresent()) {
                throw new NIllegalArgumentException(NMsg.ofC("extension not found: %s", extension));
            }
            if (def.getDescriptor().getIdType() != NIdType.EXTENSION) {
                throw new NIllegalArgumentException(NMsg.ofC("not an extension: %s", extension));
            }
            this.workspaceExtensionsClassLoader.add(NClassLoaderUtils.definitionToClassLoaderNode(def, null));
            Set<Class<? extends NComponent>> classes = this.objectFactory.discoverTypes(def.getId(), (URL)def.getContent().flatMap(NPath::toURL).orNull(), this.workspaceExtensionsClassLoader);
            for (Class<? extends NComponent> aClass : classes) {
                ((NWorkspaceExt)((Object)this.workspace)).getModel().configModel.onNewComponent(aClass);
            }
            this.loadedExtensionIds.add(extension);
            this._LOG().log(NMsg.ofC("extension %s loaded", def.getId()).withIntent(NMsgIntent.SUCCESS).withLevel(Level.CONFIG));
            someUpdates = true;
        }
        if (someUpdates) {
            this.updateLoadedExtensionURLs();
        }
    }

    private void updateLoadedExtensionURLs() {
        this.loadedExtensionURLs.clear();
        for (NDefinition def : NSearchCmd.of().addIds(this.loadedExtensionIds.toArray(new NId[0])).setTargetApiVersion(this.workspace.getApiVersion()).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).getResultDefinitions().toList()) {
            this.loadedExtensionURLs.add((URL)def.getContent().flatMap(NPath::toURL).orNull());
        }
    }

    public void unloadExtensions(NId[] extensions) {
        boolean someUpdates = false;
        for (NId extension : extensions) {
            NId u = this.loadedExtensionIds.stream().filter(x -> x.getShortName().equals(extension.getShortName())).findFirst().orElse(null);
            if (u == null) continue;
            NSession session = this.getWorkspace().currentSession();
            if (session.isPlainTrace()) {
                NOut.println(NMsg.ofC("extensions %s unloaded", u));
            }
            this.loadedExtensionIds.remove(u);
            this.unloadedExtensions.add(u);
            someUpdates = true;
        }
        if (someUpdates) {
            this.updateLoadedExtensionURLs();
        }
    }

    public NWorkspaceExtension[] getWorkspaceExtensions() {
        return this.extensions.values().toArray(new NWorkspaceExtension[0]);
    }

    public NWorkspaceExtension wireExtension(NId id, NFetchCmd options) {
        NTerminal newTerminal;
        NSession session = this.workspace.currentSession();
        NAssert.requireNonNull(id, "extension id");
        NId wired = CoreNUtils.findNutsIdBySimpleName(id, this.extensions.keySet());
        if (wired != null) {
            throw new NExtensionAlreadyRegisteredException(id, wired.toString());
        }
        this._LOG().log(NMsg.ofC("installing extension %s", id).withLevel(Level.FINE).withIntent(NMsgIntent.ADD));
        NDefinition nDefinitions = NSearchCmd.of().copyFrom(options).addId(id).setDependencyFilter(NDependencyFilters.of().byRunnable()).setLatest(true).getResultDefinitions().findFirst().get();
        if (!this.isLoadedClassPath(nDefinitions)) {
            this.workspaceExtensionsClassLoader.add(NClassLoaderUtils.definitionToClassLoaderNode(nDefinitions, null));
        }
        DefaultNWorkspaceExtension workspaceExtension = new DefaultNWorkspaceExtension(id, nDefinitions.getId(), this.workspaceExtensionsClassLoader);
        Set<Class<? extends NComponent>> discoveredTypes = this.objectFactory.discoverTypes(nDefinitions.getId(), (URL)nDefinitions.getContent().flatMap(NPath::toURL).orNull(), workspaceExtension.getClassLoader());
        this.extensions.put(id, workspaceExtension);
        this._LOG().log(NMsg.ofC("extension %s installed successfully", id).withLevel(Level.FINE).withIntent(NMsgIntent.ADD));
        NDefaultTerminalSpec spec = new NDefaultTerminalSpec();
        if (session.getTerminal() != null) {
            spec.setProperty("ignoreClass", session.getTerminal().getClass());
        }
        if ((newTerminal = this.createTerminal(spec)) != null) {
            this._LOG().log(NMsg.ofC("extension %s changed Terminal configuration. Reloading Session Terminal", id).withLevel(Level.FINE).withIntent(NMsgIntent.UPDATE));
            session.setTerminal(newTerminal);
        }
        for (Class<? extends NComponent> discoveredType : discoveredTypes) {
            if (!NExtensionLifeCycle.class.isAssignableFrom(discoveredType)) continue;
            workspaceExtension.getEvents().add((NExtensionLifeCycle)this.objectFactory.createComponent(discoveredType, null).get());
        }
        for (NExtensionLifeCycle event : workspaceExtension.getEvents()) {
            event.onInitExtension(workspaceExtension);
        }
        return workspaceExtension;
    }

    /*
     * Exception decompiling
     */
    private boolean isLoadedClassPath(NDefinition file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 18[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<Class<? extends NComponent>> resolveComponentTypes(Class<?> o) {
        ArrayList<Class<? extends NComponent>> a = new ArrayList<Class<? extends NComponent>>();
        if (o != null) {
            HashSet<Class> v = new HashSet<Class>();
            Stack s = new Stack();
            s.push(o);
            while (!s.isEmpty()) {
                Class c = (Class)s.pop();
                v.add(c);
                if (this.SUPPORTED_EXTENSION_TYPES.contains(c)) {
                    a.add(c);
                }
                for (Class<?> aa : c.getInterfaces()) {
                    if (v.contains(aa)) continue;
                    s.push(aa);
                }
                Class sc = c.getSuperclass();
                if (sc == null || v.contains(sc)) continue;
                s.push(sc);
            }
        }
        return a;
    }

    public NTerminal createTerminal(NTerminalSpec spec) {
        NSystemTerminalBase termb = this.createSupported(NSystemTerminalBase.class, spec).get();
        if (spec != null && spec.get("ignoreClass") != null && spec.get("ignoreClass").equals(termb.getClass())) {
            return null;
        }
        return new DefaultNTerminalFromSystem(termb);
    }

    public URL[] getExtensionURLLocations(NId nutsId, String appId, String extensionType) {
        ArrayList<URL> bootUrls = new ArrayList<URL>();
        for (String r : this.getExtensionRepositoryLocations(nutsId)) {
            String url = r + "/" + nutsId.getMavenPath(extensionType);
            URL u = this.expandURL(url);
            bootUrls.add(u);
        }
        return bootUrls.toArray(new URL[0]);
    }

    public String[] getExtensionRepositoryLocations(NId appId) {
        String repos = this.workspace.getConfigProperty("nuts.bootstrap-repository-locations").flatMap(NLiteral::asString).orElse("") + ";";
        ArrayList<String> urls = new ArrayList<String>();
        for (String r : StringTokenizerUtils.splitDefault(repos)) {
            if (NBlankable.isBlank(r)) continue;
            urls.add(r);
        }
        return urls.toArray(new String[0]);
    }

    protected URL expandURL(String url) {
        return NPath.of(url).toAbsolute(NWorkspace.of().getWorkspaceLocation()).toURL().get();
    }

    private NWorkspaceConfigBoot getStoredConfig() {
        return NWorkspaceExt.of(this.workspace).getConfigModel().getStoredConfigBoot();
    }

    public synchronized DefaultNClassLoader getNutsURLClassLoader(String name, ClassLoader parent) {
        if (parent == null) {
            parent = this.workspaceExtensionsClassLoader;
        }
        return new DefaultNClassLoader(name, parent);
    }

    public NWorkspace getWorkspace() {
        return this.workspace;
    }

    public <T extends NComponent> T createFirst(Class<T> type) {
        return this.objectFactory.createFirst(type);
    }

    public NWorkspaceFactory getObjectFactory() {
        return this.objectFactory;
    }

    public static class RegInfo {
        Class extensionPointType;
        Class extensionTypeImpl;
        NId extensionId;

        public RegInfo(Class extensionPointType, Class extensionTypeImpl, NId extensionId) {
            this.extensionPointType = extensionPointType;
            this.extensionTypeImpl = extensionTypeImpl;
            this.extensionId = extensionId;
        }

        public NId getExtensionId() {
            return this.extensionId;
        }

        public Class getExtensionPointType() {
            return this.extensionPointType;
        }

        public Class getExtensionTypeImpl() {
            return this.extensionTypeImpl;
        }
    }

    private static class NURLClassLoaderKey {
        private final URL[] urls;
        private final ClassLoader parent;

        public NURLClassLoaderKey(URL[] urls, ClassLoader parent) {
            this.urls = urls;
            this.parent = parent;
        }

        public int hashCode() {
            int hash = 3;
            hash = 13 * hash + Arrays.deepHashCode(this.urls);
            hash = 13 * hash + Objects.hashCode(this.parent);
            return hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NURLClassLoaderKey other = (NURLClassLoaderKey)obj;
            if (!Arrays.deepEquals(this.urls, other.urls)) {
                return false;
            }
            return Objects.equals(this.parent, other.parent);
        }
    }
}

