/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.util.List;
import java.util.ServiceLoader;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NServiceLoader;
import net.thevpc.nuts.runtime.standalone.util.NScorableNScorableQueryImpl;
import net.thevpc.nuts.spi.NComponent;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNServiceLoader<T extends NComponent, B>
implements NServiceLoader<T> {
    private final ClassLoader classLoader;
    private final Class<T> serviceType;
    private final Class<B> criteriaType;
    private final ServiceLoader<T> loader;
    private final NWorkspace workspace;

    public DefaultNServiceLoader(NWorkspace workspace, Class<T> serviceType, Class<B> criteriaType, ClassLoader classLoader) {
        this.workspace = workspace;
        this.classLoader = classLoader;
        this.serviceType = serviceType;
        this.criteriaType = criteriaType;
        this.loader = ServiceLoader.load(serviceType, classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader);
    }

    @Override
    public List<T> loadAll(Object criteria) {
        return new NScorableNScorableQueryImpl<T>(NScorableContext.of(criteria)).fromIterable(this.loader).withName(NMsg.ofC("component %s", this.serviceType)).getAll();
    }

    @Override
    public NOptional<T> loadBest(Object criteria) {
        return new NScorableNScorableQueryImpl<T>(NScorableContext.of(criteria)).fromIterable(this.loader).withName(NMsg.ofC("component %s", this.serviceType)).getBest();
    }
}

