/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedHashMap;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.core.NClassLoaderNode;

public class DefaultNClassLoader
extends URLClassLoader {
    private String name;
    private LinkedHashMap<String, NClassLoaderNode> nodes = new LinkedHashMap();
    private LinkedHashMap<String, NClassLoaderNode> effective = new LinkedHashMap();

    public DefaultNClassLoader(String name, ClassLoader parent) {
        super(new URL[0], parent);
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean contains(NClassLoaderNode node, boolean deep) {
        return this.search(node, deep) != null;
    }

    public NClassLoaderNode search(NClassLoaderNode node, boolean deep) {
        NId ii = node.getId();
        String sn = ii.getShortName();
        NClassLoaderNode o = this.nodes.get(sn);
        if (o != null) {
            return o;
        }
        if (deep && (o = this.effective.get(sn)) != null) {
            return o;
        }
        ClassLoader p = this.getParent();
        if (p instanceof DefaultNClassLoader) {
            return ((DefaultNClassLoader)p).search(node, deep);
        }
        return null;
    }

    public boolean add(NClassLoaderNode node) {
        String sn;
        NId ii = node.getId();
        String string = sn = ii == null ? null : ii.getShortName();
        if (!this.nodes.containsKey(sn)) {
            this.nodes.put(sn, node);
            return this.add(node, true);
        }
        return false;
    }

    protected boolean add(NClassLoaderNode node, boolean deep) {
        String sn;
        NId ii = node.getId();
        String string = sn = ii == null ? null : ii.getShortName();
        if (!this.effective.containsKey(sn)) {
            this.effective.put(sn, node);
            super.addURL(node.getURL());
            if (deep) {
                for (NClassLoaderNode dependency : node.getDependencies()) {
                    this.add(dependency, true);
                }
            }
            return true;
        }
        if (deep) {
            for (NClassLoaderNode dependency : node.getDependencies()) {
                this.add(dependency, true);
            }
        }
        return false;
    }

    @Override
    public void addURL(URL url) {
        throw new IllegalArgumentException("unsupported addURL");
    }

    public String toString() {
        return "NutsURLClassLoader{name='" + this.name + '\'' + '}';
    }
}

