/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.extension;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.runtime.standalone.io.urlpart.URLPart;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.io.util.ZipUtils;
import net.thevpc.nuts.runtime.standalone.xtra.web.DefaultNWebCli;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NVisitResult;
import net.thevpc.nuts.util.NCollections;
import net.thevpc.nuts.util.NException;

public final class CoreServiceUtils {
    private CoreServiceUtils() {
    }

    private static Set<String> loadZipServiceClassNamesFromJarStream(InputStream jarStream, Class service) {
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        if (jarStream != null) {
            ZipUtils.visitZipStream(jarStream, (path, inputStream) -> {
                if (path.equals("META-INF/services/" + service.getName())) {
                    try (InputStreamReader reader = new InputStreamReader(inputStream);){
                        found.addAll(CoreIOUtils.confLines(reader).map(String::trim).collect(Collectors.toSet()));
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                    return NVisitResult.TERMINATE;
                }
                return NVisitResult.CONTINUE;
            });
        }
        return found;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> loadZipServiceClassNamesFromClassLoader(ClassLoader classLoader, Class service) {
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        try {
            List<URL> found2 = NCollections.list(classLoader.getResources("META-INF/services/" + service.getName()));
            for (URL url : found2) {
                try (InputStreamReader reader = new InputStreamReader(DefaultNWebCli.prepareGlobalOpenStream(url));){
                    found.addAll(CoreIOUtils.confLines(reader).map(String::trim).collect(Collectors.toSet()));
                }
                catch (IOException ex) {
                    throw new NIOException(ex);
                    return found;
                }
            }
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private static Set<String> loadZipServiceClassNamesFromFolder(File file, Class service) {
        LinkedHashSet<String> found = new LinkedHashSet<String>();
        File dir = new File(file, "META-INF/services/");
        File[] files = dir.listFiles();
        if (files != null) {
            for (File f : files) {
                Set<String> set;
                if (!f.getName().equals(service.getName())) continue;
                FileReader reader = new FileReader(f);
                try {
                    set = CoreIOUtils.confLines(reader).map(String::trim).collect(Collectors.toSet());
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                ((Reader)reader).close();
                return set;
            }
        }
        return found;
    }

    public static Set<String> loadZipServiceClassNames(URL url, Class service) {
        LinkedHashSet<String> found;
        block18: {
            Set<String> set;
            block16: {
                block17: {
                    Set<String> set2;
                    found = new LinkedHashSet<String>();
                    URLPart lastPart = URLPart.of(url);
                    File file = lastPart.getFile().orNull();
                    if (file == null) break block17;
                    if (file.isDirectory()) {
                        return CoreServiceUtils.loadZipServiceClassNamesFromFolder(file, service);
                    }
                    if (!file.isFile()) break block18;
                    FileInputStream jarStream = new FileInputStream(file);
                    try {
                        set2 = CoreServiceUtils.loadZipServiceClassNamesFromJarStream(jarStream, service);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                ((InputStream)jarStream).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new NIOException(ex);
                        }
                    }
                    ((InputStream)jarStream).close();
                    return set2;
                }
                InputStream jarStream = DefaultNWebCli.prepareGlobalOpenStream(url);
                try {
                    set = CoreServiceUtils.loadZipServiceClassNamesFromJarStream(jarStream, service);
                    if (jarStream == null) break block16;
                }
                catch (Throwable throwable) {
                    try {
                        if (jarStream != null) {
                            try {
                                jarStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ex) {
                        throw new NIOException(ex);
                    }
                }
                jarStream.close();
            }
            return set;
        }
        return found;
    }

    public static List<String> loadServiceClassNames(URL u, Class<?> service) {
        List<String> list;
        InputStreamReader ir = new InputStreamReader(CoreIOUtils.openStream(u).get(), StandardCharsets.UTF_8);
        try {
            list = CoreIOUtils.confLines(ir).map(String::trim).collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ir.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new NIOException(ex);
            }
        }
        ir.close();
        return list;
    }

    public static List<Class> loadServiceClasses(Class service, ClassLoader classLoader) {
        Enumeration<URL> configs;
        String fullName = "META-INF/services/" + service.getName();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        try {
            configs = classLoader == null ? ClassLoader.getSystemResources(fullName) : classLoader.getResources(fullName);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
        while (configs.hasMoreElements()) {
            names.addAll(CoreServiceUtils.loadServiceClassNames(configs.nextElement(), service));
        }
        ArrayList<Class> classes = new ArrayList<Class>();
        for (String n : names) {
            Class<?> c = null;
            try {
                c = Class.forName(n, false, classLoader);
            }
            catch (ClassNotFoundException x) {
                throw new NException(NMsg.ofC("unable to load service class %s", n), (Throwable)x);
            }
            if (!service.isAssignableFrom(c)) {
                throw new NException(NMsg.ofC("not a valid type %s <> %s", c, service));
            }
            classes.add(c);
        }
        return classes;
    }
}

