/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.system;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.runtime.standalone.executor.java.JavaExecutorComponent;
import net.thevpc.nuts.runtime.standalone.executor.system.ProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.io.util.IProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NExecutorComponent;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NScorableContext;

@NComponentScope(value=NScopeType.WORKSPACE)
public class ProcessExecutorComponent
implements NExecutorComponent {
    public static NId ID;

    @Override
    public NId getId() {
        return ID;
    }

    @Override
    public int getScore(NScorableContext nutsDefinition) {
        if (ID == null) {
            ID = NId.get("net.thevpc.nuts.exec:exec-native").get();
        }
        return 10;
    }

    @Override
    public int exec(NExecutionContext executionContext) {
        return this.execHelper(executionContext).exec();
    }

    public IProcessExecHelper execHelper(NExecutionContext executionContext) {
        NDefinition nutMainFile = executionContext.getDefinition();
        NPath storeFolder = nutMainFile.getInstallInformation().get().getInstallFolder();
        List<String> execArgs = executionContext.getExecutorOptions();
        List<String> appArgs = executionContext.getArguments();
        ArrayList<String> app = new ArrayList<String>(appArgs);
        if (app.isEmpty()) {
            if (storeFolder == null) {
                app.add("${nuts.file}");
            } else {
                app.add("${nuts.store}/run");
            }
        }
        HashMap<String, String> osEnv = new HashMap<String, String>();
        String bootArgumentsString = JavaExecutorComponent.createChildOptions(executionContext).toCmdLine(new NWorkspaceOptionsConfig().setCompact(true)).toString();
        osEnv.put("nuts_boot_args", bootArgumentsString);
        String dir = null;
        boolean showCommand = CoreNUtils.isShowCommand();
        for (int i = 0; i < execArgs.size(); ++i) {
            String arg = execArgs.get(i);
            if (arg.equals("--show-command") || arg.equals("-show-command")) {
                showCommand = true;
                continue;
            }
            if (arg.equals("--dir") || arg.equals("-dir")) {
                dir = execArgs.get(++i);
                continue;
            }
            if (!arg.startsWith("--dir=") && !arg.startsWith("-dir=")) continue;
            dir = execArgs.get(i).substring(arg.indexOf(61) + 1);
        }
        String directory = NBlankable.isBlank(dir) ? null : NPath.of(dir).toAbsolute().toString();
        return ProcessExecHelper.ofDefinition(nutMainFile, app.toArray(new String[0]), osEnv, directory, showCommand, true, executionContext.getSleepMillis(), executionContext.getIn(), executionContext.getOut(), executionContext.getErr(), executionContext.getRunAs(), executionContext.getExecutorOptions().toArray(new String[0]), executionContext.isDry(), executionContext.getSession());
    }
}

