/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.system;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.Function;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NDependencyFilters;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.command.NFetchCmd;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NIOException;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathPermission;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.executor.AbstractSyncIProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.executor.system.NSysExecUtils;
import net.thevpc.nuts.runtime.standalone.executor.system.ProcessBuilder2;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.jclass.NJavaSdkUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.NRecommendationPhase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;
import net.thevpc.nuts.runtime.standalone.xtra.expr.StringPlaceHolderParser;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NStringUtils;

public class ProcessExecHelper
extends AbstractSyncIProcessExecHelper {
    private NDefinition definition;
    private ProcessBuilder2 pb;
    private NPrintStream trace;
    private NExecInput in;
    private NExecOutput out;
    private NExecOutput err;
    private boolean dry;

    public ProcessExecHelper(NDefinition definition, ProcessBuilder2 pb, NPrintStream trace, NExecInput in, NExecOutput out, NExecOutput err, boolean dry) {
        this.pb = pb;
        this.trace = trace;
        this.definition = definition;
        this.in = in;
        this.out = out;
        this.err = err;
        this.dry = dry;
    }

    public static ProcessExecHelper ofArgs(NDefinition definition, String[] args, Map<String, String> env, Path directory, boolean showCommand, boolean failFast, long sleep, NExecInput in, NExecOutput out, NExecOutput err, NRunAs runAs, String[] executorOptions, boolean dry) {
        List<String> newCommands = NSysExecUtils.buildEffectiveCommandLocal(args, runAs, executorOptions);
        ProcessBuilder2 pb = new ProcessBuilder2();
        pb.setCommand(newCommands).setEnv(env).setDirectory(directory == null ? null : directory.toFile()).setSleepMillis(sleep).setFailFast(failFast);
        pb.setIn(CoreIOUtils.validateIn(in));
        pb.setOut(CoreIOUtils.validateOut(out));
        pb.setErr(CoreIOUtils.validateErr(err));
        NLog _LL = NLog.of(NWorkspaceUtils.class);
        if (_LL.isLoggable(Level.FINEST)) {
            _LL.log(NMsg.ofC("[exec] %s", NText.ofCode("system", pb.getCommandString())).asFinest().withIntent(NMsgIntent.START));
        }
        if (showCommand || CoreNUtils.isShowCommand()) {
            if (NOut.getTerminalMode() == NTerminalMode.FORMATTED) {
                NOut.print(NMsg.ofC("%s ", NText.ofStyled("[exec]", NTextStyle.primary4())));
                NOut.println(NText.ofCode("system", pb.getCommandString()));
            } else {
                NOut.print("exec ");
                NOut.println(NMsg.ofPlain(pb.getCommandString()));
            }
        }
        return new ProcessExecHelper(definition, pb, NSession.of().out(), in, out, err, dry);
    }

    public static ProcessExecHelper ofDefinition(NDefinition nutMainFile, String[] args, Map<String, String> env, String directory, boolean showCommand, boolean failFast, long sleep, NExecInput in, NExecOutput out, NExecOutput err, NRunAs runAs, String[] executorOptions, boolean dry, NSession session) throws NExecutionException {
        final NWorkspace workspace = session.getWorkspace();
        NId id = nutMainFile.getId();
        Path installerFile = (Path)nutMainFile.getContent().flatMap(NPath::toPath).orNull();
        NPath storeFolder = nutMainFile.getInstallInformation().get().getInstallFolder();
        final HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> envmap = new HashMap<String, String>();
        NPath nutsJarFile = NFetchCmd.ofNutsApi().setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultPath();
        if (nutsJarFile != null) {
            map.put("nuts.jar", nutsJarFile.normalize().toString());
        }
        map.put("nuts.artifact", id.toString());
        map.put("nuts.file", nutMainFile.getContent().flatMap(NPath::toPath).map(Object::toString).orNull());
        final String defaultJavaCommand = NJavaSdkUtils.of(workspace).resolveJavaCommandByVersion("", false);
        if (defaultJavaCommand == null) {
            throw new NExecutionException(NMsg.ofPlain("no java version was found"), 1);
        }
        map.put("nuts.java", defaultJavaCommand);
        if (map.containsKey("nuts.jar")) {
            map.put("nuts.cmd", (String)map.get("nuts.java") + " -jar " + (String)map.get("nuts.jar"));
        }
        map.put("nuts.workspace", NWorkspace.of().getWorkspaceLocation().toString());
        if (installerFile != null) {
            map.put("nuts.installer", installerFile.toString());
        }
        if (storeFolder == null && installerFile != null) {
            map.put("nuts.store", installerFile.getParent().toString());
        } else if (storeFolder != null) {
            map.put("nuts.store", storeFolder.toString());
        }
        if (env != null) {
            map.putAll(env);
        }
        Function<String, String> mapper = new Function<String, String>(){

            @Override
            public String apply(String skey) {
                if (skey.equals("java") || skey.startsWith("java#")) {
                    String javaVer = skey.substring(5);
                    if (NBlankable.isBlank(javaVer)) {
                        return defaultJavaCommand;
                    }
                    String s = NJavaSdkUtils.of(workspace).resolveJavaCommandByVersion(javaVer, false);
                    if (s == null) {
                        throw new NExecutionException(NMsg.ofC("no java version %s was found", javaVer), 1);
                    }
                    return s;
                }
                if (skey.equals("javaw") || skey.startsWith("javaw#")) {
                    String javaVer = skey.substring(6);
                    if (NBlankable.isBlank(javaVer)) {
                        return defaultJavaCommand;
                    }
                    String s = NJavaSdkUtils.of(workspace).resolveJavaCommandByVersion(javaVer, true);
                    if (s == null) {
                        throw new NExecutionException(NMsg.ofC("no java version %s was found", javaVer), 1);
                    }
                    return s;
                }
                if (skey.equals("nuts") || skey.equals("nuts-app")) {
                    NDefinition nDefinition = NFetchCmd.ofNutsApp().setDependencyFilter(NDependencyFilters.of().byRunnable()).getResultDefinition();
                    if (nDefinition.getContent().isPresent()) {
                        return "<::expand::> " + this.apply("java") + " -jar " + nDefinition.getContent();
                    }
                    return null;
                }
                return (String)map.get(skey);
            }
        };
        for (Map.Entry entry : map.entrySet()) {
            String k = (String)entry.getKey();
            if (NBlankable.isBlank(k)) continue;
            k = k.replace('.', '_').toUpperCase();
            if (NBlankable.isBlank((String)entry.getValue())) continue;
            envmap.put(k, (String)entry.getValue());
        }
        ArrayList<String> args2 = new ArrayList<String>();
        for (String arg : args) {
            String s = NStringUtils.trim(StringPlaceHolderParser.replaceDollarPlaceHolders(arg, mapper));
            if (s.startsWith("<::expand::>")) {
                Collections.addAll(args2, NCmdLine.of(s, NShellFamily.BASH).setExpandSimpleOptions(false).toStringArray());
                continue;
            }
            args2.add(s);
        }
        args = args2.toArray(new String[0]);
        Path path = NWorkspace.of().getWorkspaceLocation().toPath().get();
        Path path2 = path.resolve(args[0]).normalize();
        if (Files.exists(path2, new LinkOption[0])) {
            NPath.of(path2).addPermissions(NPathPermission.CAN_EXECUTE);
        }
        Path pdirectory = null;
        pdirectory = NBlankable.isBlank(directory) ? path : path.resolve(directory);
        return ProcessExecHelper.ofArgs(nutMainFile, args, envmap, pdirectory, showCommand, failFast, sleep, in, out, err, runAs, executorOptions, dry);
    }

    @Override
    public int exec() {
        NSession session = NSession.of();
        if (session.isDry()) {
            if (this.trace.getTerminalMode() == NTerminalMode.FORMATTED) {
                this.trace.print("[dry] ==[exec]== ");
                this.trace.println(this.pb.getFormattedCommandString());
            } else {
                this.trace.print("[dry] exec ");
                this.trace.println(NMsg.ofPlain(this.pb.getCommandString()));
            }
            return 0;
        }
        try {
            if (this.trace != null) {
                this.trace.resetLine();
            }
            ProcessBuilder2 p = this.pb.start();
            return this.waitResult(p);
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    @Override
    public Future<Integer> execAsync() {
        try {
            if (this.trace != null) {
                this.trace.run(NTerminalCmd.MOVE_LINE_START);
            }
            ProcessBuilder2 p = this.pb.start();
            return new FutureTask<Integer>(() -> this.waitResult(p));
        }
        catch (IOException ex) {
            throw new NIOException(ex);
        }
    }

    private int waitResult(ProcessBuilder2 p) {
        Exception err = null;
        try {
            int a = p.waitFor().getResult();
            if (a != 0) {
                err = new NExecutionException(NMsg.ofC("process returned error code %s", a), (Throwable)err);
            }
            int n = a;
            return n;
        }
        catch (Exception ex) {
            err = ex;
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)err;
            }
            throw new NExecutionException(NMsg.ofPlain("error executing process"), (Throwable)err);
        }
        finally {
            if (err != null && this.definition != null) {
                NWorkspaceExt.of().getModel().recomm.getRecommendations(new RequestQueryInfo(this.definition.getId().toString(), err), NRecommendationPhase.EXEC, false);
            }
        }
    }
}

