/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.system;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.thevpc.nuts.cmdline.DefaultNArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.cmdline.NCmdLineFormatStrategy;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.io.DefaultNContentMetadata;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NIO;
import net.thevpc.nuts.io.NInputSource;
import net.thevpc.nuts.io.NInputSourceBuilder;
import net.thevpc.nuts.io.NNonBlockingInputStream;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPathOption;
import net.thevpc.nuts.io.NRedirectType;
import net.thevpc.nuts.io.NullInputStream;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.NWorkspaceProfilerImpl;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NCmdLineShellOptions;
import net.thevpc.nuts.runtime.standalone.executor.system.NExecInput2;
import net.thevpc.nuts.runtime.standalone.executor.system.NExecOutput2;
import net.thevpc.nuts.runtime.standalone.executor.system.NSysExecUtils;
import net.thevpc.nuts.runtime.standalone.executor.system.PipeRunnable;
import net.thevpc.nuts.runtime.standalone.util.CoreStringUtils;
import net.thevpc.nuts.runtime.standalone.xtra.shell.NShellHelper;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextBuilder;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NIllegalStateException;
import net.thevpc.nuts.util.NStringUtils;
import net.thevpc.nuts.util.NUnexpectedException;

public class ProcessBuilder2 {
    private List<String> command = new ArrayList<String>();
    private Map<String, String> env;
    private File directory;
    private boolean failFast;
    private long sleepMillis = 1000L;
    private NExecInput2 in = new NExecInput2(NExecInput.ofInherit());
    private NExecOutput2 out = new NExecOutput2(NExecOutput.ofInherit());
    private NExecOutput2 err = new NExecOutput2(NExecOutput.ofInherit());
    private ProcessBuilder base = new ProcessBuilder(new String[0]);
    private List<PipeRunnable> pipesList = new ArrayList<PipeRunnable>();
    private ExecutorService pipes = null;
    private int result;
    private Process proc;
    private Long pid;

    private static String formatArg(String s) {
        DefaultNArg a = new DefaultNArg(s);
        StringBuilder sb = new StringBuilder();
        NTexts factory = NTexts.of();
        if (a.isKeyValue()) {
            if (a.isOption()) {
                sb.append(factory.ofStyled(NStringUtils.formatStringLiteral(a.key()), NTextStyle.option()));
                sb.append("=");
                sb.append(NStringUtils.formatStringLiteral(a.getStringValue().get()));
            } else {
                sb.append(factory.ofStyled(NStringUtils.formatStringLiteral(a.key()), NTextStyle.primary4()));
                sb.append("=");
                sb.append(NStringUtils.formatStringLiteral(a.getStringValue().get()));
            }
        } else if (a.isOption()) {
            sb.append(factory.ofStyled(NStringUtils.formatStringLiteral(a.image()), NTextStyle.option()));
        } else {
            sb.append(NStringUtils.formatStringLiteral(a.image()));
        }
        return sb.toString();
    }

    public long getProcessId() {
        if (this.pid != null) {
            return this.pid;
        }
        try {
            if (this.proc.getClass().getName().equals("java.lang.Win32Process") || this.proc.getClass().getName().equals("java.lang.ProcessImpl")) {
                Field f = this.proc.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                long l = f.getLong(this.proc);
            } else if (this.proc.getClass().getName().equals("java.lang.UNIXProcess")) {
                Field f = this.proc.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                return f.getLong(this.proc);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1L;
    }

    public long getSleepMillis() {
        return this.sleepMillis;
    }

    public ProcessBuilder2 setSleepMillis(long sleepMillis) {
        this.sleepMillis = sleepMillis;
        return this;
    }

    public Process getProc() {
        return this.proc;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public ProcessBuilder2 setCommand(String ... command) {
        this.setCommand(Arrays.asList(command));
        return this;
    }

    public ProcessBuilder2 setCommand(List<String> command) {
        this.command = command == null ? null : new ArrayList<String>(command);
        return this;
    }

    public ProcessBuilder2 addCommand(String ... command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.addAll(Arrays.asList(command));
        return this;
    }

    public ProcessBuilder2 addCommand(List<String> command) {
        if (this.command == null) {
            this.command = new ArrayList<String>();
        }
        this.command.addAll(command);
        return this;
    }

    public Map<String, String> getEnv() {
        return this.env;
    }

    public ProcessBuilder2 setEnv(Map<String, String> env) {
        this.env = env == null ? null : new HashMap<String, String>(env);
        return this;
    }

    public ProcessBuilder2 addEnv(Map<String, String> env) {
        if (env != null) {
            if (this.env == null) {
                this.env = new HashMap<String, String>(env);
            } else {
                this.env.putAll(env);
            }
        }
        return this;
    }

    public ProcessBuilder2 setEnv(String k, String val) {
        if (this.env == null) {
            this.env = new HashMap<String, String>();
        }
        this.env.put(k, val);
        return this;
    }

    public File getDirectory() {
        return this.directory;
    }

    public ProcessBuilder2 setDirectory(File directory) {
        this.directory = directory;
        return this;
    }

    public NExecInput getIn() {
        return this.in.base;
    }

    public ProcessBuilder2 setIn(NExecInput in) {
        this.in.base = in == null ? NExecInput.ofInherit() : in;
        return this;
    }

    public NExecOutput getOut() {
        return this.out.base;
    }

    public ProcessBuilder2 setOut(NExecOutput out) {
        this.out.base = out == null ? NExecOutput.ofInherit() : out;
        return this;
    }

    public NExecOutput getErr() {
        return this.err.base;
    }

    public ProcessBuilder2 setErr(NExecOutput err) {
        this.err.base = err == null ? NExecOutput.ofInherit() : err;
        return this;
    }

    public byte[] getOutputBytes() {
        return this.out.base.getResultBytes();
    }

    public byte[] getErrorBytes() {
        switch (this.err.base.getType()) {
            case REDIRECT: {
                return this.getOutputBytes();
            }
        }
        return this.err.base.getResultBytes();
    }

    public String getOutputString() {
        return new String(this.getOutputBytes());
    }

    public String getErrorString() {
        return new String(this.getErrorBytes());
    }

    public ProcessBuilder2 start() throws IOException {
        Set<NPathOption> options;
        Path file;
        NPath path;
        if (this.proc != null) {
            throw new NIllegalStateException(NMsg.ofPlain("already started"));
        }
        NLog.of(ProcessBuilder2.class).log(NMsg.ofNtf(NText.ofCode("system", this.getCommandString())).asFinest().withIntent(NMsgIntent.START));
        switch (this.in.base.getType()) {
            case PIPE: 
            case STREAM: 
            case NULL: {
                this.base.redirectInput(ProcessBuilder.Redirect.PIPE);
                break;
            }
            case PATH: {
                path = this.in.base.getPath();
                file = path.toPath().get();
                if (file == null) {
                    this.in.tempPath = NPath.ofTempFile();
                    this.in.file = this.in.tempPath.toFile().get();
                    path.copyTo(this.in.tempPath, new NPathOption[0]);
                } else {
                    this.in.file = file.toFile();
                }
                this.base.redirectInput(ProcessBuilder.Redirect.from(this.in.file));
            }
            case INHERIT: {
                this.base.redirectInput(ProcessBuilder.Redirect.INHERIT);
                break;
            }
            case REDIRECT: 
            case GRAB_STREAM: 
            case GRAB_FILE: {
                throw new NIllegalArgumentException(NMsg.ofC("unsupported in mode : %s", this.in.base.getType()));
            }
        }
        switch (this.out.base.getType()) {
            case PIPE: 
            case STREAM: 
            case NULL: {
                this.base.redirectOutput(ProcessBuilder.Redirect.PIPE);
                break;
            }
            case INHERIT: {
                this.base.redirectOutput(ProcessBuilder.Redirect.INHERIT);
                break;
            }
            case GRAB_STREAM: {
                this.base.redirectOutput(ProcessBuilder.Redirect.PIPE);
                this.out.tempStream = new ByteArrayOutputStream();
                break;
            }
            case GRAB_FILE: {
                this.out.tempPath = NPath.ofTempFile();
                this.out.file = this.out.tempPath.toFile().get();
                this.base.redirectOutput(ProcessBuilder.Redirect.to(this.out.file));
            }
            case PATH: {
                path = this.out.base.getPath();
                file = path.toPath().get();
                options = Arrays.stream(this.out.base.getOptions()).filter(Objects::nonNull).collect(Collectors.toSet());
                if (file == null) {
                    this.base.redirectOutput(ProcessBuilder.Redirect.PIPE);
                    this.out.tempStream = this.out.base.getPath().getOutputStream(options.toArray(new NPathOption[0]));
                    break;
                }
                if (options.isEmpty()) {
                    this.in.file = file.toFile();
                    this.base.redirectOutput(ProcessBuilder.Redirect.to(this.out.file));
                    break;
                }
                if (options.size() == 1 && options.contains(NPathOption.APPEND)) {
                    this.in.file = file.toFile();
                    this.base.redirectOutput(ProcessBuilder.Redirect.appendTo(this.out.file));
                    break;
                }
                this.base.redirectOutput(ProcessBuilder.Redirect.PIPE);
                this.out.tempStream = this.out.base.getPath().getOutputStream(options.toArray(new NPathOption[0]));
                break;
            }
            case REDIRECT: {
                throw new NIllegalArgumentException(NMsg.ofC("unsupported in mode : %s", this.out.base.getType()));
            }
        }
        switch (this.err.base.getType()) {
            case PIPE: 
            case STREAM: 
            case NULL: {
                this.base.redirectError(ProcessBuilder.Redirect.PIPE);
                break;
            }
            case INHERIT: {
                this.base.redirectError(ProcessBuilder.Redirect.INHERIT);
                break;
            }
            case GRAB_STREAM: {
                this.base.redirectError(ProcessBuilder.Redirect.PIPE);
                this.err.tempStream = new ByteArrayOutputStream();
                break;
            }
            case GRAB_FILE: {
                this.err.tempPath = NPath.ofTempFile();
                this.err.file = this.err.tempPath.toFile().get();
                this.base.redirectError(ProcessBuilder.Redirect.to(this.err.file));
            }
            case PATH: {
                path = this.err.base.getPath();
                file = path.toPath().get();
                options = Arrays.stream(this.err.base.getOptions()).filter(Objects::nonNull).collect(Collectors.toSet());
                if (file == null) {
                    this.base.redirectError(ProcessBuilder.Redirect.PIPE);
                    this.err.tempStream = this.err.base.getPath().getOutputStream(options.toArray(new NPathOption[0]));
                    break;
                }
                if (options.isEmpty()) {
                    this.in.file = file.toFile();
                    this.base.redirectError(ProcessBuilder.Redirect.to(this.err.file));
                    break;
                }
                if (options.size() == 1 && options.contains(NPathOption.APPEND)) {
                    this.in.file = file.toFile();
                    this.base.redirectError(ProcessBuilder.Redirect.appendTo(this.err.file));
                    break;
                }
                this.base.redirectError(ProcessBuilder.Redirect.PIPE);
                this.err.tempStream = this.err.base.getPath().getOutputStream(options.toArray(new NPathOption[0]));
                break;
            }
            case REDIRECT: {
                this.base.redirectErrorStream(true);
            }
        }
        this.base.directory(this.directory);
        this.base.command(this.command);
        if (this.env != null) {
            Map<String, String> environment = this.base.environment();
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) continue;
                if (v == null) {
                    v = "";
                }
                environment.put(k, v);
            }
        }
        this.proc = this.base.start();
        return this;
    }

    public ProcessBuilder2 waitFor() throws IOException {
        PipeRunnable t;
        Object procInput;
        String pname;
        if (this.proc == null) {
            this.start();
        }
        if (this.proc == null) {
            throw new IOException("Not started");
        }
        long ppid = this.getProcessId();
        String procString = NPath.of(this.command.get(0)).getName() + "-" + (ppid < 0L ? "unknown-pid" + String.valueOf(-ppid) : String.valueOf(ppid));
        String cmdStr = String.join((CharSequence)" ", this.command);
        switch (this.in.base.getType()) {
            case NULL: {
                pname = "pipe-in-proc-" + procString;
                this.in.termIn = this.createNonBlockingInput(NullInputStream.INSTANCE, pname, true);
                PipeRunnable t2 = NSysExecUtils.pipe(pname, cmdStr, "in", this.in.termIn, this.proc.getOutputStream());
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t2);
                this.pipesList.add(t2);
                break;
            }
            case STREAM: {
                pname = "pipe-in-proc-" + procString;
                this.in.termIn = this.createNonBlockingInput(this.in.base.getStream(), pname, true);
                PipeRunnable t2 = NSysExecUtils.pipe(pname, cmdStr, "in", this.in.termIn, this.proc.getOutputStream());
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t2);
                this.pipesList.add(t2);
                break;
            }
        }
        switch (this.out.base.getType()) {
            case NULL: {
                pname = "pipe-out-proc-" + procString;
                procInput = this.createNonBlockingInput(this.proc.getInputStream(), pname, false);
                t = NSysExecUtils.pipe(pname, cmdStr, "out", (NNonBlockingInputStream)procInput, NIO.ofNullRawOutputStream());
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t);
                this.pipesList.add(t);
                break;
            }
            case STREAM: {
                pname = "pipe-out-proc-" + procString;
                procInput = this.createNonBlockingInput(this.proc.getInputStream(), pname, false);
                t = NSysExecUtils.pipe(pname, cmdStr, "out", (NNonBlockingInputStream)procInput, this.out.base.getStream());
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t);
                this.pipesList.add(t);
                break;
            }
            case GRAB_STREAM: {
                pname = "pipe-out-proc-" + procString;
                procInput = this.createNonBlockingInput(this.proc.getInputStream(), pname, false);
                t = NSysExecUtils.pipe(pname, cmdStr, "out", (NNonBlockingInputStream)procInput, this.out.tempStream);
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t);
                this.pipesList.add(t);
                break;
            }
            case PATH: {
                if (this.out.tempStream == null) break;
                pname = "pipe-out-proc-" + procString;
                procInput = this.createNonBlockingInput(this.proc.getInputStream(), pname, false);
                t = NSysExecUtils.pipe(pname, cmdStr, "out", (NNonBlockingInputStream)procInput, this.out.tempStream);
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t);
                this.pipesList.add(t);
            }
        }
        switch (this.err.base.getType()) {
            case STREAM: {
                pname = "pipe-err-proc-" + procString;
                procInput = this.createNonBlockingInput(this.proc.getErrorStream(), pname, false);
                t = NSysExecUtils.pipe(pname, cmdStr, "err", (NNonBlockingInputStream)procInput, this.err.base.getStream());
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t);
                this.pipesList.add(t);
                break;
            }
            case GRAB_STREAM: {
                pname = "pipe-err-proc-" + procString;
                procInput = this.createNonBlockingInput(this.proc.getErrorStream(), pname, false);
                t = NSysExecUtils.pipe(pname, cmdStr, "err", (NNonBlockingInputStream)procInput, this.err.tempStream);
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t);
                this.pipesList.add(t);
                break;
            }
            case PATH: {
                if (this.err.tempStream == null) break;
                pname = "pipe-err-proc-" + procString;
                procInput = this.createNonBlockingInput(this.proc.getErrorStream(), pname, false);
                t = NSysExecUtils.pipe(pname, cmdStr, "err", (NNonBlockingInputStream)procInput, this.err.tempStream);
                if (this.pipes == null) {
                    this.pipes = Executors.newCachedThreadPool();
                }
                this.pipes.submit(t);
                this.pipesList.add(t);
            }
        }
        if (this.in.termIn != null || this.pipesList.isEmpty()) {
            while (this.proc.isAlive()) {
                if (this.in.termIn != null && !this.in.termIn.hasMoreBytes() && this.in.termIn.available() == 0) {
                    this.in.termIn.close();
                    this.in.termIn = null;
                }
                boolean allFinished = true;
                for (PipeRunnable pipe : this.pipesList) {
                    if (!pipe.isStopped()) {
                        allFinished = false;
                        continue;
                    }
                    pipe.getOut().close();
                }
                if (allFinished) break;
                if (this.sleepMillis <= 0L) continue;
                NWorkspaceProfilerImpl.sleep(this.sleepMillis, "ProcessBuilder2::waitFor");
            }
        }
        try {
            boolean b;
            while (!(b = this.proc.waitFor(10L, TimeUnit.SECONDS))) {
            }
            this.result = this.proc.exitValue();
        }
        catch (InterruptedException e) {
            throw new IOException(CoreStringUtils.exceptionToString(e));
        }
        if (this.pipes != null) {
            for (PipeRunnable pipe : this.pipesList) {
                pipe.requestStop();
            }
            this.pipes.shutdown();
            try {
                this.pipes.awaitTermination(5L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                throw new NUnexpectedException(NMsg.ofPlain("unable to await termination"));
            }
        }
        this.proc.getInputStream().close();
        this.proc.getErrorStream().close();
        this.proc.getOutputStream().close();
        switch (this.out.base.getType()) {
            case PATH: {
                if (this.out.tempStream == null) break;
                this.out.tempStream.close();
                break;
            }
            case GRAB_STREAM: {
                this.out.tempStream.close();
                this.out.base.setResult(NInputSource.of(((ByteArrayOutputStream)this.out.tempStream).toByteArray()));
                break;
            }
            case GRAB_FILE: {
                if (this.out.tempPath == null) break;
                this.out.tempStream.close();
                this.out.tempPath.setUserTemporary(true);
                this.out.tempPath.setDeleteOnDispose(true);
                this.out.base.setResult(this.out.tempPath);
            }
        }
        switch (this.err.base.getType()) {
            case PATH: {
                if (this.err.tempStream == null) break;
                this.err.tempStream.close();
                break;
            }
            case GRAB_STREAM: {
                this.err.tempStream.close();
                this.err.base.setResult(NInputSource.of(((ByteArrayOutputStream)this.err.tempStream).toByteArray()));
                break;
            }
            case GRAB_FILE: {
                if (this.err.tempPath == null) break;
                this.err.tempStream.close();
                this.err.tempPath.setUserTemporary(true);
                this.err.tempPath.setDeleteOnDispose(true);
                this.err.base.setResult(this.err.tempPath);
            }
        }
        if (this.result != 0 && this.isFailFast()) {
            if (this.base.redirectErrorStream()) {
                if (this.out.base.getType() == NRedirectType.GRAB_FILE || this.out.base.getType() == NRedirectType.GRAB_STREAM) {
                    throw new NExecutionException(NMsg.ofC("process execution failed with code %d and message : %s. Command was %s", this.result, this.getOutputString(), NCmdLine.of(this.getCommand())), this.result);
                }
            } else {
                if (this.err.base.getType() == NRedirectType.GRAB_FILE || this.err.base.getType() == NRedirectType.GRAB_STREAM) {
                    throw new NExecutionException(NMsg.ofC("process execution failed with code %d and message : %s. Command was %s", this.result, this.getOutputString(), NCmdLine.of(this.getCommand())), this.result);
                }
                if (this.out.base.getType() == NRedirectType.GRAB_FILE || this.out.base.getType() == NRedirectType.GRAB_STREAM) {
                    throw new NExecutionException(NMsg.ofC("process execution failed with code %d and message : %s. Command was %s", this.result, this.getOutputString(), NCmdLine.of(this.getCommand())), this.result);
                }
            }
            throw new NExecutionException(NMsg.ofC("process execution failed with code %d. Command was %s", this.result, NCmdLine.of(this.getCommand())), this.result);
        }
        return this;
    }

    private NNonBlockingInputStream createNonBlockingInput(InputStream proc, String pname, boolean closeFast) {
        return NInputSourceBuilder.of(proc).setMetadata(new DefaultNContentMetadata().setMessage(NMsg.ofPlain(pname))).createNonBlockingInputStream();
    }

    public int getResult() {
        return this.result;
    }

    public Process getProcess() {
        return this.proc;
    }

    public String getCommandString() {
        return this.getCommandString(null);
    }

    public String getCommandString(CommandStringFormat f) {
        ArrayList<String> fullCommandString = new ArrayList<String>();
        File ff = this.getDirectory();
        if (ff == null) {
            ff = new File(".");
        }
        try {
            ff = ff.getCanonicalFile();
        }
        catch (Exception ex) {
            ff = ff.getAbsoluteFile();
        }
        fullCommandString.add("cwd=" + ff.getPath());
        if (this.env != null) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) {
                    k = "";
                }
                if (v == null) {
                    v = "";
                }
                if (f != null) {
                    String v2;
                    if (!f.acceptEnvName(k, v)) continue;
                    String k2 = f.replaceEnvName(k, v);
                    if (k2 != null) {
                        k = k2;
                    }
                    if ((v2 = f.replaceEnvValue(k, v)) != null) {
                        v = v2;
                    }
                }
                fullCommandString.add(k + "=" + v);
            }
        }
        for (int i = 0; i < this.command.size(); ++i) {
            String s = this.command.get(i);
            if (f != null) {
                if (!f.acceptArgument(i, s)) continue;
                String k2 = f.replaceArgument(i, s);
                if (k2 != null) {
                    s = k2;
                }
            }
            fullCommandString.add(s);
        }
        StringBuilder sb = new StringBuilder().append(NShellHelper.of(NShellFamily.getCurrent()).escapeArguments(fullCommandString.toArray(new String[0]), new NCmdLineShellOptions().setExpectEnv(true).setFormatStrategy(NCmdLineFormatStrategy.SUPPORT_QUOTES)));
        switch (this.out.base.getType()) {
            case PATH: {
                if (Arrays.stream(this.out.base.getOptions()).anyMatch(x -> x == NPathOption.APPEND)) {
                    sb.append(" >> ");
                } else {
                    sb.append(" > ");
                }
                sb.append(NStringUtils.formatStringLiteral(this.out.base.getPath().toString()));
            }
        }
        switch (this.out.base.getType()) {
            case REDIRECT: {
                sb.append(" 2>&1");
                break;
            }
            case PATH: {
                if (Arrays.stream(this.err.base.getOptions()).anyMatch(x -> x == NPathOption.APPEND)) {
                    sb.append(" 2>> ");
                } else {
                    sb.append(" 2> ");
                }
                sb.append(NStringUtils.formatStringLiteral(this.err.base.getPath().toString()));
            }
        }
        switch (this.out.base.getType()) {
            case PATH: {
                sb.append(" < ").append(NStringUtils.formatStringLiteral(this.out.base.getPath().toString()));
            }
        }
        return sb.toString();
    }

    public String getFormattedCommandString() {
        return this.getFormattedCommandString(null);
    }

    private String escape(String f) {
        return NText.ofPlain(f).toString();
    }

    public String getFormattedCommandString(CommandStringFormat f) {
        File ff = this.getDirectory();
        if (ff == null) {
            ff = new File(".");
        }
        try {
            ff = ff.getCanonicalFile();
        }
        catch (Exception ex) {
            ff = ff.getAbsoluteFile();
        }
        ArrayList<String> fullCommandString = new ArrayList<String>();
        fullCommandString.add("cwd=" + ff.getPath());
        if (this.env != null) {
            for (Map.Entry<String, String> e : this.env.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                if (k == null) {
                    k = "";
                }
                if (v == null) {
                    v = "";
                }
                if (f != null) {
                    String v2;
                    if (!f.acceptEnvName(k, v)) continue;
                    String k2 = f.replaceEnvName(k, v);
                    if (k2 != null) {
                        k = k2;
                    }
                    if ((v2 = f.replaceEnvValue(k, v)) != null) {
                        v = v2;
                    }
                }
                fullCommandString.add(k + "=" + v);
            }
        }
        boolean commandFirstTokenVisited = false;
        for (int i = 0; i < this.command.size(); ++i) {
            String s = this.command.get(i);
            if (f != null) {
                if (!f.acceptArgument(i, s)) continue;
                String k2 = f.replaceArgument(i, s);
                if (k2 != null) {
                    s = k2;
                }
            }
            fullCommandString.add(s);
        }
        NTexts txt = NTexts.of();
        NTextBuilder sb = txt.ofBlank().builder().append(txt.ofCode("system", NShellHelper.of(NShellFamily.getCurrent()).escapeArguments(fullCommandString.toArray(new String[0]), new NCmdLineShellOptions().setFormatStrategy(NCmdLineFormatStrategy.SUPPORT_QUOTES).setExpectEnv(true))));
        switch (this.out.base.getType()) {
            case PATH: {
                sb.append(" ");
                if (Arrays.stream(this.out.base.getOptions()).anyMatch(x -> x == NPathOption.APPEND)) {
                    sb.append((Object)">>", NTextStyle.separator());
                } else {
                    sb.append((Object)">", NTextStyle.separator());
                }
                sb.append(" ");
                sb.append(this.out.base.getPath());
            }
        }
        switch (this.err.base.getType()) {
            case PATH: {
                sb.append(" ");
                if (Arrays.stream(this.out.base.getOptions()).anyMatch(x -> x == NPathOption.APPEND)) {
                    sb.append((Object)">>", NTextStyle.separator());
                } else {
                    sb.append((Object)">", NTextStyle.separator());
                }
                sb.append(" ");
                sb.append((Object)this.err.base.getPath(), NTextStyle.path());
                break;
            }
            case REDIRECT: {
                sb.append(" ");
                sb.append((Object)"2", NTextStyle.number());
                sb.append((Object)">", NTextStyle.separator());
                sb.append((Object)"&1", NTextStyle.number());
            }
        }
        switch (this.in.base.getType()) {
            case PATH: {
                sb.append(" ");
                sb.append((Object)"<", NTextStyle.separator());
                sb.append(" ");
                sb.append((Object)this.in.base.getPath(), NTextStyle.path());
            }
        }
        return sb.toString();
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public ProcessBuilder2 setFailFast(boolean failFast) {
        this.failFast = failFast;
        return this;
    }

    public ProcessBuilder2 setFailFast() {
        return this.setFailFast(true);
    }

    public String toString() {
        return "ProcessBuilder2{command=" + this.command + ", env=" + this.env + ", directory=" + this.directory + ", failFast=" + this.failFast + ", sleepMillis=" + this.sleepMillis + ", in=" + this.in + ", out=" + this.out + ", err=" + this.err + ", result=" + this.result + ", pid=" + this.getProcessId() + '}';
    }

    public static interface CommandStringFormat {
        default public boolean acceptArgument(int argIndex, String arg) {
            return true;
        }

        default public String replaceArgument(int argIndex, String arg) {
            return null;
        }

        default public boolean acceptEnvName(String envName, String envValue) {
            return true;
        }

        default public boolean acceptRedirectInput() {
            return true;
        }

        default public boolean acceptRedirectOutput() {
            return true;
        }

        default public boolean acceptRedirectError() {
            return true;
        }

        default public String replaceEnvName(String envName, String envValue) {
            return null;
        }

        default public String replaceEnvValue(String envName, String envValue) {
            return null;
        }
    }
}

