/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.system;

import java.io.File;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.thevpc.nuts.app.NApp;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NNonBlockingInputStream;
import net.thevpc.nuts.platform.NDesktopEnvironmentFamily;
import net.thevpc.nuts.platform.NOsFamily;
import net.thevpc.nuts.runtime.standalone.executor.system.PipeRunnable;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NRef;

public class NSysExecUtils {
    public static Path sysWhich(String commandName) {
        Path[] p = NSysExecUtils.sysWhichAll(commandName);
        if (p.length > 0) {
            return p[0];
        }
        return null;
    }

    public static Path[] sysWhichAll(String commandName) {
        if (commandName == null || commandName.isEmpty()) {
            return new Path[0];
        }
        ArrayList<Path> all = new ArrayList<Path>();
        String p = NWorkspace.of().getSysEnv("PATH").orNull();
        if (p != null) {
            for (String s : p.split(File.pathSeparator)) {
                try {
                    Path c;
                    if (s.trim().isEmpty() || !Files.isRegularFile(c = Paths.get(s, commandName), new LinkOption[0]) || !Files.isExecutable(c)) continue;
                    all.add(c);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return all.toArray(new Path[0]);
    }

    public static PipeRunnable pipe(String name, String cmd, String desc, NNonBlockingInputStream in, OutputStream out) {
        return new PipeRunnable(name, cmd, desc, in, out, true);
    }

    public static String resolveRootUserName() {
        NOsFamily sysFamily = NWorkspace.of().getOsFamily();
        switch (sysFamily) {
            case WINDOWS: {
                String s = (String)NApp.of().getProperty("nuts.windows.root-user", NScopeType.SESSION).orNull();
                if (s == null) {
                    s = (String)NWorkspace.of().getConfigProperty("nuts.windows.root-user").flatMap(NLiteral::asString).orNull();
                }
                if (NBlankable.isBlank(s)) {
                    s = "Administrator";
                }
                return s;
            }
        }
        return "root";
    }

    public static String resolveRootUserName(NOsFamily sysFamily) {
        switch (sysFamily) {
            case WINDOWS: {
                String s = (String)NApp.of().getProperty("nuts.windows.root-user", NScopeType.SESSION).orNull();
                if (s == null) {
                    s = (String)NWorkspace.of().getConfigProperty("nuts.windows.root-user").flatMap(NLiteral::asString).orNull();
                }
                if (NBlankable.isBlank(s)) {
                    s = "Administrator";
                }
                return s;
            }
        }
        return "root";
    }

    public static List<String> buildEffectiveCommandLocal(String[] args, NRunAs runAsMode, String[] executionOptions) {
        NSession session = NSession.of();
        return NSysExecUtils.buildEffectiveCommand(args, runAsMode, NWorkspace.of().getDesktopEnvironmentFamilies(), n -> {
            Path path = NSysExecUtils.sysWhich(n);
            if (path != null) {
                return path.toString();
            }
            return null;
        }, session.isGui() && NWorkspace.of().isGraphicalDesktopEnvironment(), NSysExecUtils.resolveRootUserName(), System.getProperty("user.name"), executionOptions);
    }

    private static List<String> prepareCommand(String[] cmd, Function<String, String[]> patterns) {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : cmd) {
            String[] a;
            if (s.matches("[$][a-zA-Z]+")) {
                a = patterns.apply(s.substring(1));
                if (a == null) {
                    throw new NIllegalArgumentException(NMsg.ofC("invalid pattern %s", s));
                }
                ret.addAll(Arrays.asList(a));
                continue;
            }
            if (s.matches("[$][{][a-zA-Z]+[}]")) {
                a = patterns.apply(s.substring(2, s.length() - 1));
                if (a == null) {
                    throw new NIllegalArgumentException(NMsg.ofC("invalid pattern %s", s));
                }
                ret.addAll(Arrays.asList(a));
                continue;
            }
            ret.add(NMsg.ofV(s, r -> {
                String[] qq = (String[])patterns.apply((String)r);
                if (qq == null) {
                    throw new NIllegalArgumentException(NMsg.ofC("invalid pattern %s", r));
                }
                if (qq.length > 1) {
                    throw new NIllegalArgumentException(NMsg.ofC("invalid pattern %s, toot many values", r));
                }
                return qq[0];
            }).toString());
        }
        return ret;
    }

    public static List<String> buildEffectiveCommand(String[] cmd, NRunAs runAsMode, Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich, Boolean gui, String rootName, String userName, String[] executorOptions) {
        String currentUserName;
        NOsFamily sysFamily = NWorkspace.of().getOsFamily();
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(cmd));
        if (runAsMode == null) {
            runAsMode = NRunAs.CURRENT_USER;
        }
        NSession session = NSession.of();
        boolean runWithGui = gui != null ? gui : session.isGui() && NWorkspace.of().isGraphicalDesktopEnvironment();
        String rootUserName = rootName != null ? rootName : NSysExecUtils.resolveRootUserName();
        String string = currentUserName = userName != null ? userName : System.getProperty("user.name");
        if (sysWhich == null) {
            sysWhich = n -> {
                Path path = NSysExecUtils.sysWhich(n);
                if (path != null) {
                    return path.toString();
                }
                return null;
            };
        }
        switch (runAsMode.getMode()) {
            case ROOT: {
                if (!rootUserName.equals(currentUserName)) break;
                runAsMode = NRunAs.currentUser();
                break;
            }
            case USER: {
                String s2 = runAsMode.getUser();
                s2 = s2.trim();
                if (currentUserName.equals(s2)) {
                    runAsMode = NRunAs.currentUser();
                }
                if (s2.equals(runAsMode.getUser())) break;
                runAsMode = NRunAs.user(s2);
                break;
            }
        }
        NRunAs finalRunAsMode = runAsMode;
        Function<String, String[]> cm = s -> {
            switch (s) {
                case "user": {
                    return new String[]{finalRunAsMode.getMode() == NRunAs.Mode.USER ? finalRunAsMode.getUser() : rootUserName};
                }
                case "command": {
                    return command.toArray(new String[0]);
                }
                case "rootUser": {
                    return new String[]{rootUserName};
                }
            }
            return null;
        };
        switch (runAsMode.getMode()) {
            case CURRENT_USER: {
                ArrayList<String> cc = new ArrayList<String>();
                cc.addAll(command);
                return cc;
            }
            case ROOT: 
            case USER: {
                ArrayList<String> cc = new ArrayList<String>();
                switch (sysFamily) {
                    case LINUX: 
                    case MACOS: 
                    case UNIX: {
                        if (runWithGui) {
                            cc.addAll(NSysExecUtils.prepareCommand(NSysExecUtils.guiPosixSu(de, sysWhich).get(), cm));
                            break;
                        }
                        cc.addAll(NSysExecUtils.prepareCommand(NSysExecUtils.termPosixSu(de, sysWhich).get(), cm));
                        break;
                    }
                    case WINDOWS: {
                        cc.addAll(NSysExecUtils.prepareCommand(NSysExecUtils.guiWindowsSu(de, sysWhich).get(), cm));
                        break;
                    }
                    default: {
                        throw new NIllegalArgumentException(NMsg.ofC("cannot run as %s on unknown system OS family", finalRunAsMode.getMode() == NRunAs.Mode.USER ? finalRunAsMode.getUser() : rootUserName));
                    }
                }
                return cc;
            }
            case SUDO: {
                ArrayList<String> cc = new ArrayList<String>();
                switch (sysFamily) {
                    case LINUX: 
                    case MACOS: 
                    case UNIX: {
                        if (runWithGui) {
                            cc.addAll(NSysExecUtils.prepareCommand(NSysExecUtils.guiPosixSudo(de, sysWhich).get(), cm));
                            break;
                        }
                        cc.addAll(NSysExecUtils.prepareCommand(NSysExecUtils.termPosixSudo(executorOptions, de, sysWhich).get(), cm));
                        break;
                    }
                    case WINDOWS: {
                        cc.addAll(NSysExecUtils.prepareCommand(NSysExecUtils.guiWindowsSudo(de, sysWhich).get(), cm));
                        break;
                    }
                    default: {
                        throw new NIllegalArgumentException(NMsg.ofC("cannot run sudo %s on unknown system OS family", currentUserName));
                    }
                }
                return cc;
            }
        }
        throw new NIllegalArgumentException(NMsg.ofPlain("cannot run as admin/root on unknown system OS family"));
    }

    private static NOptional<String[]> guiWindowsSudo(Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich) {
        return NOptional.of(new String[]{"runas", "/noprofile", "/user:$rootUser", "$command"});
    }

    private static NOptional<String[]> guiWindowsSu(Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich) {
        return NOptional.of(new String[]{"runas", "/noprofile", "/user:$user", "$command"});
    }

    private static NOptional<String[]> termPosixSu(Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich) {
        String su = sysWhich.apply("su");
        if (NBlankable.isBlank(su)) {
            return NOptional.ofNamedEmpty("su application");
        }
        return NOptional.of(new String[]{su, "-", "$user", "-c", "$command"});
    }

    private static NOptional<String[]> termPosixSudo(String[] executorOptions, Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich) {
        NCmdLine cmdLine = NCmdLine.of(executorOptions);
        NRef<Boolean> changePrompt = NRef.of(false);
        NRef<String> newPromptValue = NRef.of("");
        block6: while (cmdLine.hasNext()) {
            NArg ac = cmdLine.peek().get();
            switch (ac.key()) {
                case "--sudo-prompt": {
                    if (ac.getValue().isNull()) {
                        cmdLine.matcher().matchFlag(v -> {
                            if (v.booleanValue()) {
                                changePrompt.set(false);
                                newPromptValue.set(null);
                            } else {
                                changePrompt.set(true);
                                newPromptValue.set("");
                            }
                        }).anyMatch();
                        continue block6;
                    }
                    if (ac.getValue().isString()) {
                        cmdLine.matcher().matchEntry(v -> {
                            changePrompt.set(true);
                            newPromptValue.set(v.stringValue());
                        }).anyMatch();
                        continue block6;
                    }
                    cmdLine.skip();
                    continue block6;
                }
            }
            cmdLine.skip();
        }
        String su = sysWhich.apply("sudo");
        if (NBlankable.isBlank(su)) {
            return NOptional.ofNamedEmpty("sudo application");
        }
        ArrayList<String> rr = new ArrayList<String>();
        rr.add(su);
        rr.add("-S");
        if (changePrompt.get().booleanValue()) {
            rr.add("-p");
            rr.add(newPromptValue.get());
        }
        rr.add("$command");
        return NOptional.of(rr.toArray(new String[0]));
    }

    private static NOptional<String[]> guiPosixSu(Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich) {
        if (de == null) {
            de = NWorkspace.of().getDesktopEnvironmentFamilies();
        }
        String currSu = null;
        currSu = sysWhich.apply("pkexec");
        if (currSu != null) {
            return NOptional.of(new String[]{currSu, "sudo", "-u", "$user", "$command"});
        }
        if (de.contains(NDesktopEnvironmentFamily.KDE) ? (currSu = sysWhich.apply("kdesu")) != null : de.contains(NDesktopEnvironmentFamily.GNOME) && (currSu = sysWhich.apply("gksu")) != null) {
            return NOptional.of(new String[]{currSu, "-u", "$user", "$command"});
        }
        if (currSu == null && (currSu = sysWhich.apply("gksu")) != null) {
            return NOptional.of(new String[]{currSu, "-u", "$user", "$command"});
        }
        if (currSu == null && (currSu = sysWhich.apply("kdesu")) != null) {
            return NOptional.of(new String[]{currSu, "-u", "$user", "$command"});
        }
        return NOptional.ofNamedEmpty("gui su application (pkexec,kdesu,gksu,...)");
    }

    private static NOptional<String[]> guiPosixSudo(Set<NDesktopEnvironmentFamily> de, Function<String, String> sysWhich) {
        if (de == null) {
            de = NWorkspace.of().getDesktopEnvironmentFamilies();
        }
        String currSu = null;
        currSu = sysWhich.apply("pkexec");
        if (currSu != null) {
            return NOptional.of(new String[]{currSu, "$command"});
        }
        if (de.contains(NDesktopEnvironmentFamily.KDE) ? (currSu = sysWhich.apply("kdesudo")) != null : de.contains(NDesktopEnvironmentFamily.GNOME) && (currSu = sysWhich.apply("gksudo")) != null) {
            return NOptional.of(new String[]{currSu, "$command"});
        }
        if (currSu == null && (currSu = sysWhich.apply("gksudo")) != null) {
            return NOptional.of(new String[]{currSu, "$command"});
        }
        if (currSu == null && (currSu = sysWhich.apply("kdesudo")) != null) {
            return NOptional.of(new String[]{currSu, "$command"});
        }
        return NOptional.ofNamedEmpty("gui su application (pkexec,kdesudo,gksudo,...)");
    }
}

