/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.java;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NIdFormat;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.cmdline.NArg;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecutionContext;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NClassLoaderNode;
import net.thevpc.nuts.core.NIsolationLevel;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceCmdLineParser;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.core.NWorkspaceOptionsBuilder;
import net.thevpc.nuts.core.NWorkspaceOptionsConfig;
import net.thevpc.nuts.ext.NExtensions;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLogConfig;
import net.thevpc.nuts.platform.NShellFamily;
import net.thevpc.nuts.runtime.standalone.executor.AbstractSyncIProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.executor.NExecutionContextUtils;
import net.thevpc.nuts.runtime.standalone.executor.embedded.ClassloaderAwareRunnableImpl;
import net.thevpc.nuts.runtime.standalone.executor.java.JavaExecutorOptions;
import net.thevpc.nuts.runtime.standalone.executor.java.JavaProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNClassLoader;
import net.thevpc.nuts.runtime.standalone.extension.DefaultNExtensions;
import net.thevpc.nuts.runtime.standalone.io.net.util.NetUtils;
import net.thevpc.nuts.runtime.standalone.io.util.IProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.util.CoreNUtils;
import net.thevpc.nuts.runtime.standalone.util.NDebugString;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.DefaultNExecutionContext;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.NRecommendationPhase;
import net.thevpc.nuts.runtime.standalone.workspace.cmd.recom.RequestQueryInfo;
import net.thevpc.nuts.spi.NComponentScope;
import net.thevpc.nuts.spi.NExecutorComponent;
import net.thevpc.nuts.spi.NScopeType;
import net.thevpc.nuts.text.NCmdLineFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.text.NTexts;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NMapStrategy;
import net.thevpc.nuts.util.NScorableContext;
import net.thevpc.nuts.util.NStringUtils;

@NComponentScope(value=NScopeType.WORKSPACE)
public class JavaExecutorComponent
implements NExecutorComponent {
    public static NId ID;

    @Override
    public NId getId() {
        return ID;
    }

    @Override
    public int exec(NExecutionContext executionContext) {
        return this.execHelper(executionContext).exec();
    }

    @Override
    public int getScore(NScorableContext ctx) {
        NDefinition def;
        if (ID == null) {
            ID = NId.get("net.thevpc.nuts.exec:java").get();
        }
        if ((def = ctx.getCriteria(NDefinition.class)) != null) {
            String shortName = def.getId().getShortName();
            if ("net.thevpc.nuts.exec:exec-java".equals(shortName)) {
                return 20;
            }
            if ("java".equals(shortName)) {
                return 20;
            }
            if ("jar".equals(def.getDescriptor().getPackaging())) {
                return 20;
            }
        }
        return -1;
    }

    public static NWorkspaceOptionsBuilder createChildOptions(NExecutionContext executionContext) {
        NSession session = executionContext.getSession();
        NWorkspaceOptionsBuilder options = NWorkspace.of().getBootOptions().toWorkspaceOptions().builder();
        options.setDry(executionContext.isDry());
        options.setBot(executionContext.isBot());
        options.setShowStacktrace(session.getShowStacktrace().orDefault());
        options.setGui(session.isGui());
        options.setOutLinePrefix(session.getOutLinePrefix());
        options.setErrLinePrefix(session.getErrLinePrefix());
        options.setDebug(session.getDebug().orDefault());
        options.setTrace(session.isTrace());
        options.setPreviewRepo(session.isPreviewRepo());
        options.setCached(session.isCached());
        options.setIndexed(session.isIndexed());
        options.setConfirm(session.getConfirm().orDefault());
        options.setTransitive(session.isTransitive());
        options.setOutputFormat(session.getOutputFormat().orDefault());
        switch (options.getTerminalMode().orElse(NTerminalMode.DEFAULT)) {
            case DEFAULT: {
                options.setTerminalMode(session.getTerminal().out().getTerminalMode());
            }
            case FILTERED: {
                break;
            }
            case INHERITED: {
                break;
            }
            default: {
                options.setTerminalMode(session.getTerminal().out().getTerminalMode());
            }
        }
        options.setExpireTime(session.getExpireTime().orNull());
        Level logTermLevel = session.getLogTermLevel();
        Level logFileLevel = session.getLogFileLevel();
        if (logTermLevel != null || logFileLevel != null) {
            NLogConfig lc = options.getLogConfig().orNull();
            lc = lc == null ? new NLogConfig() : lc.copy();
            if (logTermLevel != null) {
                lc.setLogTermLevel(logTermLevel);
            }
            if (logFileLevel != null) {
                lc.setLogFileLevel(logFileLevel);
            }
        }
        Iterator<String> iterator = executionContext.getExecutorOptions().iterator();
        while (iterator.hasNext()) {
            String a = iterator.next();
            if (!a.startsWith("-Dnuts.args=")) continue;
            executionContext.getWorkspaceOptions().add(a.substring("-Dnuts.args=".length()));
            iterator.remove();
        }
        for (String a : executionContext.getWorkspaceOptions()) {
            NWorkspaceOptions extraOptions = NWorkspaceOptionsBuilder.of().setCmdLine(NCmdLine.parseDefault(a).get().toStringArray()).build();
            options.copyFrom(extraOptions, NMapStrategy.SOURCE_NON_NULL);
        }
        if (options.getIsolationLevel().orNull() == NIsolationLevel.SANDBOX) {
            options.setIsolationLevel(NIsolationLevel.CONFINED);
        }
        options.unsetCreationOptions().unsetRuntimeOptions();
        return options;
    }

    public IProcessExecHelper execHelper(NExecutionContext executionContext) {
        String bootArgumentsString;
        NId d;
        NDefinition def = executionContext.getDefinition();
        Path contentFile = (Path)def.getContent().flatMap(NPath::toPath).orNull();
        NSession session = executionContext.getSession();
        JavaExecutorOptions joptions = new JavaExecutorOptions(def, executionContext.isTemporary(), executionContext.getArguments(), executionContext.getExecutorOptions(), NBlankable.isBlank(executionContext.getDirectory()) ? NPath.ofUserDirectory() : executionContext.getDirectory());
        switch (executionContext.getExecutionType()) {
            case EMBEDDED: {
                return new EmbeddedProcessExecHelper(def, joptions, session.out(), executionContext);
            }
        }
        HashMap<String, String> osEnv = new HashMap<String, String>();
        NVersion nutsDependencyVersion = null;
        Iterator<Object> iterator = CoreNUtils.resolveNutsApiIdsFromDefinition(executionContext.getDefinition()).iterator();
        while (iterator.hasNext() && (nutsDependencyVersion = (d = iterator.next()).getVersion()) == null) {
        }
        if (nutsDependencyVersion == null) {
            for (String s : joptions.getClassPathNidStrings()) {
                NId sid = NId.get(s).orNull();
                if (sid != null && sid.equalsShortId(NId.getApi("").orNull())) {
                    nutsDependencyVersion = sid.getVersion();
                    continue;
                }
                Pattern pp = Pattern.compile(".*[/\\\\]nuts-(?<v>[0-9.]+)[.]jar");
                Matcher mm = pp.matcher(s);
                if (!mm.find()) continue;
                String v = mm.group("v");
                nutsDependencyVersion = NVersion.get(v).get();
                break;
            }
        }
        NWorkspaceOptionsBuilder options = JavaExecutorComponent.createChildOptions(executionContext);
        NWorkspaceOptionsConfig config = new NWorkspaceOptionsConfig().setCompact(true);
        if (nutsDependencyVersion != null) {
            config.setApiVersion(nutsDependencyVersion);
            options.setApiVersion(null);
            options.setRuntimeId(null);
        }
        NCmdLine ncmdLine = options.toCmdLine(config);
        if (!joptions.getExtraNutsOptions().isEmpty()) {
            NCmdLine zzz = NCmdLine.of(joptions.getExtraNutsOptions());
            while (!zzz.isEmpty()) {
                List<NArg> z = NWorkspaceCmdLineParser.nextNutsArgument(zzz, options).orNull();
                if (z != null) continue;
                zzz.skip();
            }
        }
        ArrayList<String> extraStartWithAppArgs = new ArrayList<String>();
        if (def.getId().equalsShortId(session.getWorkspace().getApiId())) {
            extraStartWithAppArgs.addAll(ncmdLine.toStringList());
        }
        if (!NBlankable.isBlank(bootArgumentsString = NCmdLineFormat.ofPlain(ncmdLine.add(executionContext.getDefinition().getId().getLongName())).setShellFamily(NShellFamily.SH).toString())) {
            osEnv.put("NUTS_BOOT_ARGS", bootArgumentsString);
            joptions.getJvmArgs().add("-Dnuts.boot.args=" + bootArgumentsString);
        }
        Properties sysProperties = System.getProperties();
        for (Object k : sysProperties.keySet()) {
            String sk = (String)k;
            if (!sk.startsWith("nuts.export.")) continue;
            joptions.getJvmArgs().add("-D" + sk + "=" + sysProperties.getProperty(sk));
        }
        int maxDepth = Math.abs(NLiteral.of(sysProperties.getProperty("nuts.export.watchdog.max-depth")).asInt().orElse(24));
        if (maxDepth > 64) {
            maxDepth = 64;
        }
        int currentDepth = NLiteral.of(sysProperties.getProperty("nuts.export.watchdog.depth")).asInt().orElse(-1);
        if (++currentDepth > maxDepth) {
            session.err().println("[[Process Stack Overflow Error]]");
            session.err().println("It's very likely that you executed an infinite process creation recursion in your program.");
            session.err().println("at least " + currentDepth + " (>=" + maxDepth + ") processes were created.");
            session.err().println("are you aware of such misconception ?");
            session.err().println("sorry but we need to end all of this disgracefully...");
            System.exit(233);
        }
        ArrayList<NText> xargs = new ArrayList<NText>();
        ArrayList<String> args = new ArrayList<String>();
        NTexts txt = NTexts.of();
        xargs.add(txt.ofPlain(joptions.getJavaCommand()));
        xargs.addAll(joptions.getJvmArgs().stream().map(txt::ofPlain).collect(Collectors.toList()));
        args.add(joptions.getJavaCommand());
        args.addAll(joptions.getJvmArgs());
        NDebugString jdb = NDebugString.of(session.getDebug().orDefault());
        if (jdb.isEnabled()) {
            int maxPort;
            int port = jdb.getPort();
            if (port <= 0) {
                port = 5005;
            }
            if ((maxPort = jdb.getMaxPort()) < port) {
                maxPort = port + 1000;
            }
            if ((port = NetUtils.detectRandomFreeTcpPort(port, maxPort + 1)) < 0) {
                throw new NIllegalArgumentException(NMsg.ofC("unable to resolve valid debug port %d-%d", port, port + 1000));
            }
            String ds = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + (jdb.isSuspend() ? (char)'y' : 'n') + ",address=" + port;
            xargs.add(txt.ofPlain(ds));
            args.add(ds);
        }
        if (joptions.isJar()) {
            xargs.add(txt.ofPlain("-jar"));
            xargs.add(NIdFormat.of(def.getId()).format());
            args.add("-jar");
            args.add(contentFile.toString());
        } else {
            List<String> classPathStrings;
            xargs.add(txt.ofPlain("--nuts-path"));
            xargs.add(txt.ofBuilder().appendJoined(";", joptions.getClassPathNidStrings()).immutable());
            xargs.add(txt.ofPlain(joptions.getMainClass()));
            if (!joptions.getJ9_modulePath().isEmpty()) {
                args.add("--module-path");
                args.add(joptions.getJ9_modulePath().stream().distinct().collect(Collectors.joining(File.pathSeparator)));
            }
            if (!joptions.getJ9_upgradeModulePath().isEmpty()) {
                args.add("--upgradable-module-path");
                args.add(joptions.getJ9_upgradeModulePath().stream().distinct().collect(Collectors.joining(",")));
            }
            if (!joptions.getJ9_addModules().isEmpty()) {
                args.add("--add-modules");
                args.add(joptions.getJ9_addModules().stream().distinct().collect(Collectors.joining(",")));
            }
            if (!NBlankable.isBlank(joptions.getSplash())) {
                args.add("-splash:" + NStringUtils.trim(joptions.getSplash()));
            }
            if (!(classPathStrings = joptions.getClassPath()).isEmpty()) {
                args.add("-classpath");
                args.add(classPathStrings.stream().distinct().collect(Collectors.joining(File.pathSeparator)));
            }
            args.add(joptions.getMainClass());
        }
        xargs.addAll(extraStartWithAppArgs.stream().map(txt::ofPlain).collect(Collectors.toList()));
        xargs.addAll(joptions.getAppArgs().stream().map(txt::ofPlain).collect(Collectors.toList()));
        args.addAll(extraStartWithAppArgs);
        args.addAll(joptions.getAppArgs());
        return new JavaProcessExecHelper(xargs, joptions, executionContext, def, args, osEnv);
    }

    static class EmbeddedProcessExecHelper
    extends AbstractSyncIProcessExecHelper {
        private final NDefinition def;
        private final JavaExecutorOptions joptions;
        private final NPrintStream out;
        private final NExecutionContext executionContext;

        public EmbeddedProcessExecHelper(NDefinition def, JavaExecutorOptions joptions, NPrintStream out, NExecutionContext executionContext) {
            this.def = def;
            this.joptions = joptions;
            this.out = out;
            this.executionContext = executionContext;
        }

        @Override
        public int exec() {
            NSession session = NSession.of();
            if (this.executionContext.isDry()) {
                NTexts text = NTexts.of();
                ArrayList<String> cmdLine = new ArrayList<String>();
                cmdLine.add("embedded-java");
                cmdLine.add("-cp");
                cmdLine.add(this.joptions.getClassPathNodes().stream().map(NClassLoaderNode::getId).filter(NBlankable::isNonBlank).map(Object::toString).collect(Collectors.joining(":")));
                cmdLine.add(this.joptions.getMainClass());
                cmdLine.addAll(this.joptions.getAppArgs());
                NOut.println(NMsg.ofC("[dry] %s", text.ofBuilder().append((Object)"exec", NTextStyle.pale()).append(" ").append(NCmdLine.of(cmdLine))));
                return 0;
            }
            if (session.out() != null) {
                NOut.resetLine();
            }
            Throwable th = null;
            try {
                DefaultNClassLoader classLoader = ((DefaultNExtensions)NExtensions.of()).getModel().getNutsURLClassLoader(this.def.getId().toString(), null);
                for (NClassLoaderNode n : this.joptions.getClassPathNodes()) {
                    classLoader.add(n);
                }
                if (this.joptions.getMainClass() == null) {
                    if (this.joptions.isJar()) {
                        throw new NIllegalArgumentException(NMsg.ofC("jar mode and embedded mode are exclusive for %s", this.def.getId()));
                    }
                    throw new NIllegalArgumentException(NMsg.ofC("unable resolve class name for %s", this.def.getId()));
                }
                Class<?> cls = Class.forName(this.joptions.getMainClass(), true, classLoader);
                HashMap<String, String> newEnv = new HashMap<String, String>(NWorkspaceExt.of().getConfigModel().sysEnv());
                newEnv.putAll(this.executionContext.getEnv());
                newEnv.putAll(NExecutionContextUtils.defaultEnv(this.def));
                ((DefaultNExecutionContext)this.executionContext).setEnv(newEnv);
                th = session.copy().callWith(() -> {
                    Throwable th2 = null;
                    try {
                        new ClassloaderAwareRunnableImpl(this.def.getId(), classLoader, cls, session, this.joptions, this.executionContext).runAndWaitFor();
                    }
                    catch (InvocationTargetException e) {
                        th2 = e.getTargetException();
                    }
                    catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | MalformedURLException e) {
                        th2 = e;
                    }
                    catch (Throwable ex) {
                        th2 = ex;
                    }
                    return th2;
                });
            }
            catch (Throwable ex) {
                th = ex;
            }
            if (th != null) {
                if (!(th instanceof NExecutionException)) {
                    NWorkspaceExt.of().getModel().recomm.getRecommendations(new RequestQueryInfo(this.def.getId().toString(), th), NRecommendationPhase.EXEC, false);
                    throw new NExecutionException(NMsg.ofC("error executing %s : %s", this.def.getId(), th), th);
                }
                NExecutionException nex = (NExecutionException)th;
                if (nex.getExitCode() != 0) {
                    if (this.def != null) {
                        NWorkspaceExt.of().getModel().recomm.getRecommendations(new RequestQueryInfo(this.def.getId().toString(), nex), NRecommendationPhase.EXEC, false);
                    }
                    throw new NExecutionException(NMsg.ofC("error executing %s : %s", this.def == null ? null : this.def.getId(), th), th);
                }
            }
            return 0;
        }
    }
}

