/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.exec;

import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.logging.Level;
import net.thevpc.nuts.artifact.NDefinition;
import net.thevpc.nuts.cmdline.NCmdLine;
import net.thevpc.nuts.command.NExecCmd;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.core.NRunAs;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.io.NExecInput;
import net.thevpc.nuts.io.NExecOutput;
import net.thevpc.nuts.io.NOut;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.io.NPrintStream;
import net.thevpc.nuts.io.NTerminalMode;
import net.thevpc.nuts.log.NLog;
import net.thevpc.nuts.log.NMsgIntent;
import net.thevpc.nuts.runtime.standalone.app.cmdline.NCmdLineUtils;
import net.thevpc.nuts.runtime.standalone.executor.AbstractSyncIProcessExecHelper;
import net.thevpc.nuts.runtime.standalone.io.util.CoreIOUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.text.NExecCmdFormat;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.text.NTerminalCmd;
import net.thevpc.nuts.text.NText;
import net.thevpc.nuts.text.NTextStyle;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NLiteral;

public class NExecHelper
extends AbstractSyncIProcessExecHelper {
    NExecCmd pb;
    NPrintStream out;

    public NExecHelper(NExecCmd pb, NPrintStream out) {
        this.pb = pb;
        this.out = out;
    }

    public static NExecHelper ofArgs(String[] args, Map<String, String> env, Path directory, boolean showCommand, boolean failFast, long sleep, NExecInput in, NExecOutput out, NExecOutput err, NRunAs runAs) {
        NExecCmd pb = NExecCmd.of();
        NCmdLineUtils.OptionsAndArgs optionsAndArgs = NCmdLineUtils.parseOptionsFirst(args);
        pb.setCommand(optionsAndArgs.getArgs()).addExecutorOptions(optionsAndArgs.getOptions()).setRunAs(runAs).setEnv(env).setDirectory(directory == null ? null : NPath.of(directory)).setSleepMillis((int)sleep).setFailFast(failFast);
        pb.setIn(CoreIOUtils.validateIn(in));
        pb.setOut(CoreIOUtils.validateOut(out));
        pb.setErr(CoreIOUtils.validateErr(err));
        NLog _LL = NLog.of(NWorkspaceUtils.class);
        NCmdLine commandOut = NCmdLine.of(pb.getCommand());
        if (_LL.isLoggable(Level.FINEST)) {
            _LL.log(NMsg.ofC("[exec] %s", commandOut).asFinest().withIntent(NMsgIntent.START));
        }
        NSession session = NSession.of();
        if (showCommand || NWorkspace.of().getCustomBootOption("---show-command").flatMap(NLiteral::asBoolean).orElse(false).booleanValue()) {
            if (NOut.getTerminalMode() == NTerminalMode.FORMATTED) {
                NOut.print(NMsg.ofC("%s ", NText.ofStyled("[exec]", NTextStyle.primary4())));
                NOut.println(NText.of(commandOut));
            } else {
                NOut.print("exec ");
                NOut.println(commandOut);
            }
        }
        return new NExecHelper(pb, session.out());
    }

    public static NExecHelper ofDefinition(NDefinition nutMainFile, String[] args, Map<String, String> env, String directory, boolean showCommand, boolean failFast, long sleep, NExecInput in, NExecOutput out, NExecOutput err, NRunAs runAs) throws NExecutionException {
        Path wsLocation = NWorkspace.of().getWorkspaceLocation().toPath().get();
        Path pdirectory = null;
        pdirectory = NBlankable.isBlank(directory) ? wsLocation : wsLocation.resolve(directory);
        return NExecHelper.ofArgs(args, env, pdirectory, showCommand, failFast, sleep, in, out, err, runAs);
    }

    @Override
    public int exec() {
        NSession session = NSession.of();
        if (session.isDry()) {
            if (this.out.getTerminalMode() == NTerminalMode.FORMATTED) {
                this.out.print("[dry] ==[exec]== ");
                this.out.println(NExecCmdFormat.of(this.pb).format());
            } else {
                this.out.print("[dry] exec ");
                this.out.println(NExecCmdFormat.of(this.pb).format());
            }
            return 0;
        }
        if (this.out != null) {
            this.out.resetLine();
        }
        return this.pb.getResultCode();
    }

    @Override
    public Future<Integer> execAsync() {
        if (this.out != null) {
            this.out.run(NTerminalCmd.MOVE_LINE_START);
        }
        return NConcurrent.of().executorService().submit(() -> this.pb.getResultCode());
    }
}

