/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.embedded;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.core.NWorkspaceException;
import net.thevpc.nuts.text.NMsg;

public class CoreNApplications {
    private CoreNApplications() {
    }

    public static <T> T createApplicationInstance(Class<T> appType, NSession session, String[] args) {
        try {
            for (Method declaredMethod : appType.getDeclaredMethods()) {
                if (!Modifier.isStatic(declaredMethod.getModifiers()) || !declaredMethod.getName().equals("createApplicationInstance") || declaredMethod.getParameterCount() != 2 || !declaredMethod.getParameterTypes()[0].equals(NSession.class) || !declaredMethod.getParameterTypes()[1].equals(String[].class)) continue;
                if (appType.isAssignableFrom(declaredMethod.getReturnType())) {
                    declaredMethod.setAccessible(true);
                    Object o = declaredMethod.invoke(null, session, args);
                    if (o == null) break;
                    return appType.cast(o);
                }
                throw new NWorkspaceException(NMsg.ofC("createApplicationInstance must return %s", appType.getName()));
            }
            Constructor<?> dconstructor = null;
            for (Constructor<?> constructor : appType.getConstructors()) {
                if (constructor.getParameterCount() == 2 && constructor.getParameterTypes()[0].equals(NSession.class) && constructor.getParameterTypes()[1].equals(String[].class)) {
                    return (T)constructor.newInstance(session, args);
                }
                if (constructor.getParameterCount() != 0) continue;
                dconstructor = constructor;
            }
            if (dconstructor != null) {
                return dconstructor.newInstance(new Object[0]);
            }
        }
        catch (InstantiationException ex) {
            Throwable c = ex.getCause();
            if (c instanceof RuntimeException) {
                throw (RuntimeException)c;
            }
            if (c instanceof Error) {
                throw (Error)c;
            }
            throw new NWorkspaceException(NMsg.ofC("unable to instantiate application %s", appType.getName()), (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new NWorkspaceException(NMsg.ofC("illegal access to default constructor for %s", appType.getName()), (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new NWorkspaceException(NMsg.ofC("invocation exception for %s", appType.getName()), (Throwable)ex);
        }
        throw new NWorkspaceException(NMsg.ofC("missing application constructor one of : \n\t static createApplicationInstance(NSession,String[])\n\t Constructor(NSession,String[])\n\t Constructor()", appType.getName()));
    }

    public static String getNutsAppVersion(Class cls) {
        int m;
        Method method = null;
        try {
            method = cls.getDeclaredMethod("main", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (method != null && Modifier.isStatic(m = method.getModifiers()) && Modifier.isPublic(m)) {
            return CoreNApplications.getNutsAppVersion0(cls);
        }
        return null;
    }

    private static String getNutsAppVersion0(Class cls) {
        switch (cls.getName()) {
            case "net.thevpc.app.nuts.NutsApplication": {
                return "0.8.0";
            }
            case "net.thevpc.nuts.NutsApplication": {
                if (!cls.isInterface()) {
                    return "0.8.1";
                }
                return "0.8.3";
            }
            case "net.thevpc.nuts.app.NApplication": {
                return "0.8.4";
            }
        }
        for (Class<?> p : cls.getInterfaces()) {
            String y = CoreNApplications.getNutsAppVersion0(p);
            if (y == null) continue;
            return y;
        }
        Class p = cls.getSuperclass();
        if (p != null) {
            String y = CoreNApplications.getNutsAppVersion0(p);
            return y;
        }
        return null;
    }
}

