/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.executor.embedded;

import net.thevpc.nuts.concurrent.NConcurrent;
import net.thevpc.nuts.core.NSession;

public abstract class ClassloaderAwareRunnable
implements Runnable {
    protected Object result;
    protected ClassLoader initialClassLoader;
    protected ClassLoader classLoader;
    protected Throwable error;
    protected NSession session;

    public ClassloaderAwareRunnable(NSession session, ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.session = session;
    }

    public NSession getSession() {
        return this.session;
    }

    public abstract Object runWithContext() throws Throwable;

    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    @Override
    public void run() {
        this.initialClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        try {
            try {
                this.result = this.runWithContext();
            }
            catch (Throwable th) {
                this.error = th;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(this.initialClassLoader);
        }
    }

    public Object getResult() {
        return this.result;
    }

    public void runAndWaitFor() throws Throwable {
        try {
            NConcurrent.of().executorService().submit(this).get();
        }
        catch (InterruptedException ex) {
            this.setError(ex);
        }
        if (this.getError() != null) {
            throw this.getError();
        }
    }
}

