/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.thevpc.nuts.core.NSession;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NElementMapperBuilder;
import net.thevpc.nuts.elem.NElementMapperStore;
import net.thevpc.nuts.elem.NElementType;
import net.thevpc.nuts.elem.NNameSelectorStrategy;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.runtime.standalone.elem.CoreNElementUtils;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.DefaultNElementMapperBuilder;
import net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore.DefaultElementMapperStore;
import net.thevpc.nuts.runtime.standalone.reflect.ReflectUtils;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NAssert;
import net.thevpc.nuts.util.NClassMap;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NNameFormat;

public class UserElementMapperStore
implements NElementMapperStore {
    public static final NElementTypeNElementKeyResolver NELEMENTTYPE_KEY_RESOLVER = new NElementTypeNElementKeyResolver();
    public static final NElementTypeAndNameNElementKeyResolver CASE_SENSITIVE_NAME_RESOLVER = new NElementTypeAndNameNElementKeyResolver();
    public static final NElementTypeAndNameNoCaseNElementKeyResolver CASE_INSENSITIVE_NAME_RESOLVER = new NElementTypeAndNameNoCaseNElementKeyResolver();
    public static final NElementTypeAndNameNoFormatNElementKeyResolver FORMAT_INSENSITIVE_NAME_RESOLVER = new NElementTypeAndNameNoFormatNElementKeyResolver();
    private DefaultElementMapperStore defaultElementMapperStore;
    private final NClassMap<NElementMapper> lvl1_customMappersByType = new NClassMap<NElementMapper>(null, NElementMapper.class);
    private final List<NElementKeyResolverEntry> lvl2_customMappersByKey = new ArrayList<NElementKeyResolverEntry>();
    private List<Predicate<Type>> indestructibleTypesFilters = new ArrayList<Predicate<Type>>();
    private NReflectRepository reflectRepository;

    public UserElementMapperStore() {
        this.defaultElementMapperStore = NWorkspaceExt.of().getModel().defaultElementMapperStore;
    }

    public NReflectRepository getReflectRepository() {
        return this.reflectRepository;
    }

    public UserElementMapperStore setReflectRepository(NReflectRepository reflectRepository) {
        this.reflectRepository = reflectRepository;
        return this;
    }

    @Override
    public NElementMapperStore copyFrom(NElementMapperStore other) {
        if (other != null) {
            if (other instanceof UserElementMapperStore) {
                UserElementMapperStore u = (UserElementMapperStore)other;
                for (Class c : u.lvl1_customMappersByType.keySet()) {
                    this.setMapper((Type)c, u.lvl1_customMappersByType.get(c));
                }
                for (NElementKeyResolverEntry e : u.lvl2_customMappersByKey) {
                    this.lvl2_customMappersByKey.add(e.copy());
                }
            }
            this.indestructibleTypesFilters = new ArrayList<Predicate<Type>>(other.getIndestructibleTypesFilters());
        }
        return this;
    }

    @Override
    public <T> NElementMapperBuilder<T> builderOf(Type type) {
        return new DefaultNElementMapperBuilder(this.reflectRepository, type);
    }

    @Override
    public <T> NElementMapperBuilder<T> builderOf(Class<T> type) {
        return new DefaultNElementMapperBuilder(this.reflectRepository, type);
    }

    @Override
    public List<Predicate<Type>> getIndestructibleTypesFilters() {
        return this.indestructibleTypesFilters;
    }

    @Override
    public NElementMapperStore addIndestructibleTypesFilter(Predicate<Type> destructTypeFilter) {
        if (destructTypeFilter != null && this.indestructibleTypesFilters.contains(destructTypeFilter)) {
            this.indestructibleTypesFilters.add(destructTypeFilter);
        }
        return this;
    }

    @Override
    public NElementMapperStore removeIndestructibleTypesFilter(Predicate<Type> destructTypeFilter) {
        if (destructTypeFilter != null) {
            this.indestructibleTypesFilters.remove(destructTypeFilter);
        }
        return this;
    }

    @Override
    public NElementMapperStore removeAllIndestructibleTypesFilters() {
        this.indestructibleTypesFilters.clear();
        return this;
    }

    @Override
    public NElementMapperStore addIndestructibleTypesFilter(NElementMapperStore.DefaultIndestructibleTypesFilter destructTypeFilter) {
        if (destructTypeFilter != null) {
            switch (destructTypeFilter) {
                case ALL: {
                    this.addIndestructibleTypesFilter(CoreNElementUtils.DEFAULT_INDESTRUCTIBLE);
                    break;
                }
                case PRIMITIVES: {
                    this.addIndestructibleTypesFilter(CoreNElementUtils.DEFAULT_INDESTRUCTIBLE);
                }
            }
        }
        return this;
    }

    @Override
    public NElementMapperStore removeIndestructibleTypesFilter(NElementMapperStore.DefaultIndestructibleTypesFilter destructTypeFilter) {
        if (destructTypeFilter != null) {
            switch (destructTypeFilter) {
                case ALL: {
                    this.removeIndestructibleTypesFilter(CoreNElementUtils.DEFAULT_INDESTRUCTIBLE);
                    break;
                }
                case PRIMITIVES: {
                    this.removeIndestructibleTypesFilter(CoreNElementUtils.DEFAULT_INDESTRUCTIBLE);
                }
            }
        }
        return this;
    }

    public final UserElementMapperStore setMapper(Type cls, NElementMapper instance) {
        if (instance == null) {
            this.lvl1_customMappersByType.remove((Class)cls);
        } else {
            this.lvl1_customMappersByType.put((Class)cls, instance);
        }
        return this;
    }

    @Override
    public final <K, T> NElementMapperStore setMapper(NElementMapperStore.NElementKeyResolver<K> resolver, K key, Type type, NElementMapper<T> instance) {
        NElementKeyResolverEntry ok = null;
        for (NElementKeyResolverEntry e : this.lvl2_customMappersByKey) {
            if (!e.resolver.equals(resolver)) continue;
            ok = e;
            break;
        }
        if (ok == null) {
            ok = new NElementKeyResolverEntry(resolver);
            this.lvl2_customMappersByKey.add(ok);
        }
        if (type instanceof Class) {
            this.lvl1_customMappersByType.put((Class)type, instance);
        }
        ok.byKey.put(key, instance);
        return this;
    }

    @Override
    public <T> NElementMapperStore setMapper(NElementType elementType, Type type, NElementMapper<T> instance) {
        return this.setMapper(NELEMENTTYPE_KEY_RESOLVER, elementType, type, instance);
    }

    @Override
    public final <T> NElementMapperStore setMapper(NElementType elementType, String name, NNameSelectorStrategy nameSelectorStrategy, Type type, NElementMapper<T> instance) {
        if (nameSelectorStrategy == null) {
            nameSelectorStrategy = NNameSelectorStrategy.CASE_SENSITIVE;
        }
        NElementMapperStore.NElementKeyResolver<NElementTypeAndName> resolver = CASE_SENSITIVE_NAME_RESOLVER;
        switch (nameSelectorStrategy) {
            case CASE_INSENSITIVE: {
                resolver = CASE_INSENSITIVE_NAME_RESOLVER;
                break;
            }
            case FORMAT_INSENSITIVE: {
                resolver = FORMAT_INSENSITIVE_NAME_RESOLVER;
            }
        }
        return this.setMapper(resolver, new NElementTypeAndName(elementType, name), type, instance);
    }

    @Override
    public final <T> NElementMapperStore setMapper(NElementType elementType, String name, Type type, NElementMapper<T> instance) {
        return this.setMapper(CASE_SENSITIVE_NAME_RESOLVER, new NElementTypeAndName(elementType, name), type, instance);
    }

    @Override
    public <T> NElementMapperStore setMapper(NElementType[] elementTypes, Type type, NElementMapper<T> instance) {
        for (NElementType elementType : elementTypes) {
            this.setMapper(elementType, type, instance);
        }
        return this;
    }

    @Override
    public <T> NElementMapperStore setMapper(NElementType[] elementTypes, String name, NNameSelectorStrategy nameSelectorStrategy, Type type, NElementMapper<T> instance) {
        for (NElementType elementType : elementTypes) {
            this.setMapper(elementType, name, nameSelectorStrategy, type, instance);
        }
        return this;
    }

    @Override
    public <T> NElementMapperStore setMapper(NElementType[] elementTypes, String name, Type type, NElementMapper<T> instance) {
        for (NElementType elementType : elementTypes) {
            this.setMapper(elementType, name, type, instance);
        }
        return this;
    }

    @Override
    public <T> NElementMapperStore setMapper(NElementType[] elementTypes, String[] names, NNameSelectorStrategy nameSelectorStrategy, Type type, NElementMapper<T> instance) {
        for (NElementType elementType : elementTypes) {
            for (String name : names) {
                this.setMapper(elementType, name, nameSelectorStrategy, type, instance);
            }
        }
        return this;
    }

    @Override
    public <T> NElementMapperStore setMapper(NElementType[] elementTypes, String[] names, Type type, NElementMapper<T> instance) {
        for (NElementType elementType : elementTypes) {
            for (String name : names) {
                this.setMapper(elementType, name, type, instance);
            }
        }
        return this;
    }

    @Override
    public <T> NElementMapper<T> getMapper(NElement element) {
        return this.getMapper(element, false);
    }

    @Override
    public <T> NElementMapper<T> getMapper(Type type) {
        return this.getMapper(type, false);
    }

    @Override
    public <T> NElementMapper<T> getMapper(Type type, boolean defaultOnly) {
        NElementMapper r;
        if (type == null) {
            return DefaultElementMapperStore.F_NULL;
        }
        Class cls = ReflectUtils.getRawClass(type);
        if (NSession.class.isAssignableFrom(cls)) {
            throw new NIllegalArgumentException(NMsg.ofC("%s is not serializable", type));
        }
        if (cls.isArray()) {
            NElementMapper f = this.defaultElementMapperStore.getCoreMappers().getExact(cls);
            if (f != null) {
                return f;
            }
            return DefaultElementMapperStore.F_NUTS_ARR;
        }
        if (!defaultOnly) {
            NElementMapper f = this.lvl1_customMappersByType.get(cls);
            if (f != null) {
                return f;
            }
            NElementMapper r2 = this.defaultElementMapperStore.getCoreMappers().get(cls);
            if (r2 != null) {
                return r2;
            }
        }
        if ((r = this.defaultElementMapperStore.getDefaultMappers().get(cls)) != null) {
            return r;
        }
        throw new NIllegalArgumentException(NMsg.ofC("unable to find element mapper for type : %s", type));
    }

    @Override
    public <T> NElementMapper<T> getMapper(NElement element, boolean defaultOnly) {
        NElementMapper r;
        NAssert.requireNonNull(element, "element");
        if (!defaultOnly) {
            for (NElementKeyResolverEntry e : this.lvl2_customMappersByKey) {
                NElementMapper u;
                Object k = e.resolver.keyOf(element);
                if (k == null || (u = e.byKey.get(k)) == null) continue;
                return u;
            }
        }
        if ((r = this.defaultElementMapperStore.getMapper(element, this)) != null) {
            return r;
        }
        throw new NIllegalArgumentException(NMsg.ofC("unable to find element mapper for element type %s. element is : %s", element.type().id(), element));
    }

    static class NElementKeyResolverEntry<T> {
        NElementMapperStore.NElementKeyResolver<T> resolver;
        Map<T, NElementMapper> byKey = new HashMap<T, NElementMapper>();

        public NElementKeyResolverEntry(NElementMapperStore.NElementKeyResolver<T> resolver) {
            this.resolver = resolver;
        }

        public NElementKeyResolverEntry<T> copy() {
            NElementKeyResolverEntry<T> newInstance = new NElementKeyResolverEntry<T>(this.resolver);
            newInstance.byKey.putAll(this.byKey);
            return newInstance;
        }
    }

    private static class NElementTypeNElementKeyResolver
    implements NElementMapperStore.NElementKeyResolver<NElementType> {
        private NElementTypeNElementKeyResolver() {
        }

        @Override
        public NElementType keyOf(NElement e) {
            return e.type();
        }
    }

    private static class NElementTypeAndNameNElementKeyResolver
    implements NElementMapperStore.NElementKeyResolver<NElementTypeAndName> {
        private NElementTypeAndNameNElementKeyResolver() {
        }

        @Override
        public NElementTypeAndName keyOf(NElement e) {
            String name = null;
            if (e.isNamed()) {
                name = e.asNamed().get().name().orNull();
            }
            return new NElementTypeAndName(e.type(), name);
        }
    }

    private static class NElementTypeAndNameNoCaseNElementKeyResolver
    implements NElementMapperStore.NElementKeyResolver<NElementTypeAndName> {
        private NElementTypeAndNameNoCaseNElementKeyResolver() {
        }

        @Override
        public NElementTypeAndName keyOf(NElement e) {
            String name = null;
            if (e.isNamed()) {
                name = e.asNamed().get().name().orNull();
            }
            if (name != null) {
                name = name.toLowerCase();
            }
            return new NElementTypeAndName(e.type(), name);
        }
    }

    private static class NElementTypeAndNameNoFormatNElementKeyResolver
    implements NElementMapperStore.NElementKeyResolver<NElementTypeAndName> {
        private NElementTypeAndNameNoFormatNElementKeyResolver() {
        }

        @Override
        public NElementTypeAndName keyOf(NElement e) {
            String name = null;
            if (e.isNamed()) {
                name = e.asNamed().get().name().orNull();
            }
            if (name != null) {
                name = NNameFormat.CONST_NAME.format(name);
            }
            return new NElementTypeAndName(e.type(), name);
        }
    }

    private static class NElementTypeAndName {
        private NElementType type;
        private String name;

        public NElementTypeAndName(NElementType type, String name) {
            this.type = type;
            this.name = name;
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NElementTypeAndName that = (NElementTypeAndName)object;
            return this.type == that.type && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.name);
        }
    }
}

