/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.parser;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementMapperStore;
import net.thevpc.nuts.elem.NElementParser;
import net.thevpc.nuts.expr.NParseException;
import net.thevpc.nuts.io.NInputStreamMonitor;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.runtime.standalone.elem.DefaultNElementFactoryContext;
import net.thevpc.nuts.runtime.standalone.elem.parser.mapperstore.UserElementMapperStore;
import net.thevpc.nuts.runtime.standalone.text.DefaultNTextManagerModel;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceExt;
import net.thevpc.nuts.runtime.standalone.workspace.NWorkspaceUtils;
import net.thevpc.nuts.text.NContentType;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.time.NProgressFactory;
import net.thevpc.nuts.util.NException;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NScorableContext;

public class DefaultNElementParser
implements NElementParser {
    private final DefaultNTextManagerModel model;
    private NContentType contentType = NContentType.JSON;
    private boolean logProgress;
    private boolean ntf;
    private boolean traceProgress;
    private NProgressFactory progressFactory;
    private UserElementMapperStore userElementMapperStore;

    public DefaultNElementParser() {
        this.model = NWorkspaceExt.of().getModel().textModel;
        this.userElementMapperStore = new UserElementMapperStore();
        this.userElementMapperStore.setReflectRepository(NReflectRepository.of());
    }

    @Override
    public boolean isNtf() {
        return this.ntf;
    }

    @Override
    public NElementParser setNtf(boolean ntf) {
        this.ntf = ntf;
        return this;
    }

    @Override
    public boolean isLogProgress() {
        return this.logProgress;
    }

    @Override
    public NElementParser setLogProgress(boolean logProgress) {
        this.logProgress = logProgress;
        return this;
    }

    @Override
    public boolean isTraceProgress() {
        return this.traceProgress;
    }

    @Override
    public NElementParser setTraceProgress(boolean traceProgress) {
        this.traceProgress = traceProgress;
        return this;
    }

    @Override
    public NContentType getContentType() {
        return this.contentType;
    }

    @Override
    public NElementParser setContentType(NContentType contentType) {
        this.contentType = contentType == null ? NContentType.JSON : contentType;
        return this;
    }

    @Override
    public NElementParser json() {
        return this.setContentType(NContentType.JSON);
    }

    @Override
    public NElementParser yaml() {
        return this.setContentType(NContentType.YAML);
    }

    @Override
    public NElementParser tson() {
        return this.setContentType(NContentType.TSON);
    }

    @Override
    public NElementParser xml() {
        return this.setContentType(NContentType.XML);
    }

    @Override
    public <T> T parse(URL url, Class<T> clazz) {
        return this.parse(NPath.of(url), clazz);
    }

    private InputStream prepareInputStream(InputStream is, Object origin) {
        if (this.isLogProgress() || this.isTraceProgress()) {
            return NInputStreamMonitor.of().setSource(is).setOrigin(origin).setLogProgress(this.isLogProgress()).setTraceProgress(this.isTraceProgress()).setProgressFactory(this.getProgressFactory()).create();
        }
        return is;
    }

    private InputStream prepareInputStream(NPath path) {
        if (this.isLogProgress()) {
            return NInputStreamMonitor.of().setSource(path).setOrigin(path).setLogProgress(this.isLogProgress()).setTraceProgress(this.isTraceProgress()).setProgressFactory(this.getProgressFactory()).create();
        }
        return path.getInputStream();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T parse(NPath path, Class<T> clazz) {
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                try {
                    try (InputStream is = this.prepareInputStream(path);){
                        T t = this.parseWithSource(new InputStreamReader(is), clazz, (Object)path);
                        return t;
                    }
                    catch (NException ex) {
                        throw new NParseException(NMsg.ofC("unexpected error loading path %s : %s", path, ex), (Throwable)ex);
                    }
                    catch (UncheckedIOException ex) {
                        throw new NParseException(NMsg.ofC("unable to load path %s : %s", path, ex), (Throwable)ex);
                    }
                    catch (RuntimeException ex) {
                        throw new NParseException(NMsg.ofC("unable to parse path %s : %s", path, ex), (Throwable)ex);
                    }
                }
                catch (IOException ex) {
                    throw new NParseException(NMsg.ofC("unable to load path %s : %s", path, ex), (Throwable)ex);
                }
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("invalid content type %s. Only structured content types are allowed.", this.contentType));
    }

    @Override
    public <T> T parse(InputStream inputStream, Class<T> clazz) {
        return this.parseWithSource(inputStream, clazz, null);
    }

    @Override
    public <T> T parseWithSource(InputStream inputStream, Class<T> clazz, Object source) {
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parseWithSource(new InputStreamReader(this.prepareInputStream(inputStream, null)), clazz, source);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("invalid content type %s. Only structured content types are allowed.", this.contentType));
    }

    @Override
    public <T> T parse(String string, Class<T> clazz) {
        return this.parseWithSource(string, clazz, null);
    }

    @Override
    public <T> T parseWithSource(String string, Class<T> clazz, Object source) {
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parseWithSource(new StringReader(string), clazz, source);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("invalid content type %s. Only structured content types are allowed.", this.contentType));
    }

    @Override
    public <T> T parse(byte[] bytes, Class<T> clazz) {
        return this.parseWithSource(bytes, clazz, null);
    }

    @Override
    public <T> T parseWithSource(byte[] bytes, Class<T> clazz, Object source) {
        switch (this.contentType) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                return this.parseWithSource(new InputStreamReader(this.prepareInputStream(new ByteArrayInputStream(bytes), source)), clazz, source);
            }
        }
        throw new NIllegalArgumentException(NMsg.ofC("invalid content type %s. Only structured content types are allowed.", this.contentType));
    }

    @Override
    public <T> T parse(Reader reader, Class<T> clazz) {
        return this.parseWithSource(reader, clazz, null);
    }

    @Override
    public <T> T parseWithSource(Reader reader, Class<T> clazz, Object source) {
        return this.createFactoryContext().createObject(this.model.getStreamFormat(this.contentType == null ? NContentType.JSON : this.contentType).parseElement(reader, this.createFactoryContext(), source), clazz);
    }

    @Override
    public <T> T parse(Path file, Class<T> clazz) {
        return this.parse(NPath.of(file), clazz);
    }

    @Override
    public <T> T parse(File file, Class<T> clazz) {
        return this.parse(NPath.of(file), clazz);
    }

    @Override
    public NElement parse(URL url) {
        return this.parse(url, NElement.class);
    }

    @Override
    public NElement parse(InputStream inputStream) {
        return this.parse(inputStream, NElement.class);
    }

    @Override
    public NElement parseWithSource(InputStream inputStream, Object source) {
        return this.parseWithSource(inputStream, NElement.class, source);
    }

    @Override
    public NElement parse(String string) {
        if (string == null || string.isEmpty()) {
            return NElement.ofNull();
        }
        return this.parse(string, NElement.class);
    }

    @Override
    public NElement parse(byte[] bytes) {
        return this.parse(bytes, NElement.class);
    }

    @Override
    public NElement parse(Reader reader) {
        return this.parse(reader, NElement.class);
    }

    @Override
    public NElement parseWithSource(String string, Object source) {
        if (string == null || string.isEmpty()) {
            return NElement.ofNull();
        }
        return this.parseWithSource(string, NElement.class, source);
    }

    @Override
    public NElement parseWithSource(byte[] bytes, Object source) {
        return this.parseWithSource(bytes, NElement.class, source);
    }

    @Override
    public NElement parseWithSource(Reader reader, Object source) {
        return this.parseWithSource(reader, NElement.class, source);
    }

    @Override
    public NElement parse(Path file) {
        return this.parse(file, NElement.class);
    }

    @Override
    public NElement parse(File file) {
        return this.parse(file, NElement.class);
    }

    @Override
    public NElement parse(NPath file) {
        return this.parse(file, NElement.class);
    }

    @Override
    public NElementMapperStore mapperStore() {
        return this.userElementMapperStore;
    }

    private DefaultNElementFactoryContext createFactoryContext() {
        NReflectRepository reflectRepository = NWorkspaceUtils.of().getReflectRepository();
        DefaultNElementFactoryContext c = new DefaultNElementFactoryContext(this.isNtf(), reflectRepository, this.userElementMapperStore);
        switch (this.getContentType()) {
            case JSON: 
            case YAML: 
            case XML: 
            case TSON: {
                c.setNtf(false);
            }
        }
        return c;
    }

    @Override
    public NElementParser doWithMapperStore(Consumer<NElementMapperStore> doWith) {
        if (doWith != null) {
            doWith.accept(this.mapperStore());
        }
        return this;
    }

    public Object elementToObject(NElement o, Type type) {
        return this.createFactoryContext().createObject(o, type);
    }

    @Override
    public int getScore(NScorableContext context) {
        return 10;
    }

    @Override
    public NProgressFactory getProgressFactory() {
        return this.progressFactory;
    }

    @Override
    public NElementParser setProgressFactory(NProgressFactory progressFactory) {
        this.progressFactory = progressFactory;
        return this;
    }
}

