/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper.builder;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NElementMapperBuilder;
import net.thevpc.nuts.elem.NElementMapperBuilderFieldConfigurer;
import net.thevpc.nuts.elem.NElementMapperBuilderInitializer;
import net.thevpc.nuts.elem.NElementMapperBuilderInstanceFactory;
import net.thevpc.nuts.reflect.NReflectRepository;
import net.thevpc.nuts.reflect.NReflectType;
import net.thevpc.nuts.reflect.NReflectUtils;
import net.thevpc.nuts.runtime.standalone.elem.mapper.builder.NElementMapperFromBuilder;

public class DefaultNElementMapperBuilder<T>
implements NElementMapperBuilder<T> {
    NReflectType type;
    Function<String, String> renamer;
    Predicate<String> paramFieldFieldFilter;
    Predicate<String> bodyFieldNameFilter;
    boolean built = false;
    boolean wrapCollections = true;
    boolean containerIsCollection = false;
    List<NElementMapperBuilderFieldConfigurer<T>> onUnsupportedBody = new ArrayList<NElementMapperBuilderFieldConfigurer<T>>();
    List<NElementMapperBuilderFieldConfigurer<T>> onUnsupportedArg = new ArrayList<NElementMapperBuilderFieldConfigurer<T>>();
    List<NElementMapperBuilderInitializer<T>> postProcess = new ArrayList<NElementMapperBuilderInitializer<T>>();
    NElementMapperBuilderInstanceFactory<T> onNewInstance;
    Map<Type, Object> defaultValueByType = new HashMap<Type, Object>();

    public DefaultNElementMapperBuilder(NReflectRepository javaWord, Type type) {
        this.type = javaWord.getType(type);
    }

    @Override
    public Predicate<String> getParamFieldFieldFilter() {
        return this.paramFieldFieldFilter;
    }

    @Override
    public NElementMapperBuilder<T> setParamFieldFieldFilter(Predicate<String> paramFieldFieldFilter) {
        this.paramFieldFieldFilter = paramFieldFieldFilter;
        return this;
    }

    @Override
    public Predicate<String> getBodyFieldNameFilter() {
        return this.bodyFieldNameFilter;
    }

    @Override
    public NElementMapperBuilder<T> setBodyFieldNameFilter(Predicate<String> bodyFieldNameFilter) {
        this.bodyFieldNameFilter = bodyFieldNameFilter;
        return this;
    }

    @Override
    public NElementMapperBuilder<T> configureLenient() {
        this.setParamFieldFieldFilter(null).setBodyFieldNameFilter(null).setWrapCollections(true);
        return this;
    }

    @Override
    public NElementMapperBuilder<T> setWrapCollections(boolean wrapCollections) {
        this.wrapCollections = wrapCollections;
        this.invalidateBuild();
        return this;
    }

    @Override
    public NElementMapperBuilder<T> setContainerIsCollection(boolean value) {
        this.containerIsCollection = value;
        this.invalidateBuild();
        return this;
    }

    private Type uniformType(Type type) {
        if (type instanceof Class) {
            Class c = (Class)type;
            return NReflectUtils.toBoxedType(c).orElse(c);
        }
        return type;
    }

    public boolean hasDefaultValueByType(Type type) {
        return this.defaultValueByType.containsKey(this.uniformType(type));
    }

    public Object getDefaultValueByType(Type type) {
        return this.defaultValueByType.get(this.uniformType(type));
    }

    @Override
    public NElementMapperBuilder<T> setBooleanDefaultTrue() {
        return this.setTypeDefaultValue((Type)((Object)Boolean.class), true);
    }

    @Override
    public NElementMapperBuilder<T> setBooleanDefaultFalse() {
        return this.setTypeDefaultValue((Type)((Object)Boolean.class), false);
    }

    @Override
    public NElementMapperBuilder<T> setInstanceFactory(NElementMapperBuilderInstanceFactory<T> instanceFactory) {
        this.onNewInstance = instanceFactory;
        return this;
    }

    @Override
    public NElementMapperBuilder<T> setTypeDefaultValue(Type type, Object defaultValue) {
        this.defaultValueByType.put(this.uniformType(type), defaultValue);
        return this;
    }

    @Override
    public NElementMapperBuilder<T> onUnsupportedChild(NElementMapperBuilderFieldConfigurer<T> a) {
        if (a != null) {
            this.onUnsupportedBody.add(a);
        }
        return this;
    }

    @Override
    public NElementMapperBuilder<T> onUnsupportedParam(NElementMapperBuilderFieldConfigurer<T> a) {
        if (a != null) {
            this.onUnsupportedArg.add(a);
        }
        return this;
    }

    @Override
    public NElementMapperBuilder<T> onInitializeInstance(NElementMapperBuilderInitializer<T> a) {
        if (a != null) {
            this.postProcess.add(a);
        }
        return this;
    }

    private void invalidateBuild() {
        this.built = false;
    }

    private String uniformName(String s) {
        s = s.trim();
        if (this.renamer == null) {
            return s;
        }
        return this.renamer.apply(s);
    }

    public boolean isCollectionType0(Type raw) {
        if (raw instanceof Class) {
            Class cls = (Class)raw;
            if (cls.isArray()) {
                return true;
            }
            if (Collection.class.isAssignableFrom(cls)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public NElementMapper<T> build() {
        return new NElementMapperFromBuilder(this);
    }
}

