/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementBuilder;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPrimitiveElement;

public class NElementMapperNElementBuilder
implements NElementMapper<NElementBuilder> {
    @Override
    public Object destruct(NElementBuilder src, Type typeOfSrc, NElementFactoryContext context) {
        switch (src.type()) {
            case ARRAY: {
                return src.build().asArray().get().children().stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
            }
            case OBJECT: {
                HashSet<Object> visited = new HashSet<Object>();
                boolean map = true;
                ArrayList<Object> all = new ArrayList<Object>();
                for (NElement item : src.build().asObject().get().children()) {
                    if (map && item instanceof NPairElement) {
                        NPairElement nPairElement = (NPairElement)item;
                        Object k = context.destruct(nPairElement.key(), null);
                        Object v = context.destruct(nPairElement.value(), null);
                        if (map && visited.contains(k)) {
                            map = false;
                        } else {
                            visited.add(k);
                        }
                        all.add(new AbstractMap.SimpleEntry<Object, Object>(k, v));
                        continue;
                    }
                    all.add(context.destruct(item, null));
                }
                if (map) {
                    LinkedHashMap m = new LinkedHashMap();
                    for (Object e : all) {
                        Map.Entry entry = (Map.Entry)e;
                        m.put(entry.getKey(), entry.getValue());
                    }
                    return m;
                }
                return all;
            }
            case CUSTOM: {
                return src.build().asCustom().get();
            }
        }
        return context.createElement(src, (Type)((Object)NPrimitiveElement.class));
    }

    @Override
    public NElement createElement(NElementBuilder src, Type typeOfSrc, NElementFactoryContext context) {
        if (src.type().isAnyPrimitive()) {
            return src.build();
        }
        switch (src.type()) {
            case ARRAY: {
                NArrayElement arr = src.build().asArray().get();
                ArrayList<NElement> children = new ArrayList<NElement>(arr.size());
                boolean someChange = false;
                for (NElement c : arr) {
                    NElement v2 = context.createElement(c);
                    if (!someChange) {
                        someChange = v2 != c;
                    }
                    children.add(v2);
                }
                if (someChange) {
                    return NElement.ofArrayBuilder().addAll(children.toArray(new NElement[0])).build();
                }
                return src.build();
            }
            case OBJECT: {
                NObjectElement obj = src.build().asObject().get();
                ArrayList<NElement> children = new ArrayList<NElement>(obj.size());
                boolean someChange = false;
                for (NElement e : obj) {
                    boolean someChange0;
                    NElement k2 = context.createElement(e);
                    boolean bl = someChange0 = k2 != e;
                    if (someChange0) {
                        if (!someChange) {
                            someChange = true;
                        }
                        children.add(k2);
                        continue;
                    }
                    children.add(e);
                }
                if (someChange) {
                    NObjectElementBuilder obj2 = NElement.ofObjectBuilder();
                    obj2.addAll(children.toArray(new NElement[0]));
                    return obj2.build();
                }
                return src.build();
            }
            case CUSTOM: {
                Object v1 = src.build().asCustom().get().value();
                if (context.isIndestructibleObject(v1)) {
                    return src.build();
                }
                return context.createElement(v1);
            }
        }
        return src.build();
    }

    @Override
    public NElementBuilder createObject(NElement src, Type typeOfResult, NElementFactoryContext context) {
        return this.createElement(src.builder(), typeOfResult, context).builder();
    }
}

