/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.thevpc.nuts.elem.NArrayElement;
import net.thevpc.nuts.elem.NArrayElementBuilder;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NObjectElement;
import net.thevpc.nuts.elem.NObjectElementBuilder;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.elem.NPairElementBuilder;
import net.thevpc.nuts.elem.NPrimitiveElement;
import net.thevpc.nuts.elem.NUpletElement;
import net.thevpc.nuts.elem.NUpletElementBuilder;
import net.thevpc.nuts.util.NBooleanRef;
import net.thevpc.nuts.util.NRef;

public class NElementMapperNElement
implements NElementMapper<NElement> {
    @Override
    public Object destruct(NElement src, Type typeOfSrc, NElementFactoryContext context) {
        switch (src.type()) {
            case PAIR: {
                NPairElement p = src.asPair().get();
                return new AbstractMap.SimpleEntry<Object, Object>(context.defaultDestruct(p.key(), (Type)((Object)NElement.class)), context.defaultDestruct(p.value(), (Type)((Object)NElement.class)));
            }
            case UPLET: 
            case NAMED_UPLET: {
                return src.asUplet().get().params().stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
            }
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: 
            case PARAMETRIZED_ARRAY: {
                return src.asArray().get().children().stream().map(x -> context.destruct(x, null)).collect(Collectors.toList());
            }
            case OBJECT: 
            case PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: {
                HashSet<Object> visited = new HashSet<Object>();
                boolean map = true;
                ArrayList<Object> all = new ArrayList<Object>();
                for (NElement nElement : src.asObject().get().children()) {
                    if (map && nElement instanceof NPairElement) {
                        NPairElement nPairElement = (NPairElement)nElement;
                        Object k = context.destruct(nPairElement.key(), null);
                        Object v = context.destruct(nPairElement.value(), null);
                        if (visited.contains(k)) {
                            map = false;
                        } else {
                            visited.add(k);
                        }
                        all.add(new AbstractMap.SimpleEntry<Object, Object>(k, v));
                        continue;
                    }
                    Object object = context.destruct(nElement, null);
                    all.add(object);
                }
                if (map) {
                    LinkedHashMap m = new LinkedHashMap();
                    for (Object e : all) {
                        Map.Entry entry = (Map.Entry)e;
                        m.put(entry.getKey(), entry.getValue());
                    }
                    return m;
                }
                return all;
            }
            case CUSTOM: {
                return src.asCustom().get();
            }
        }
        return context.createElement(src, (Type)((Object)NPrimitiveElement.class));
    }

    @Override
    public NElement createElement(NElement src, Type typeOfSrc, NElementFactoryContext context) {
        if (src.type().isAnyPrimitive()) {
            return src;
        }
        switch (src.type()) {
            case PAIR: {
                NPairElement p = src.asPair().get();
                NBooleanRef someChange = NRef.ofBoolean(false);
                NElement k = this.convertOne_objectToElement(p.key(), src, typeOfSrc, context, someChange);
                NElement v = this.convertOne_objectToElement(p.value(), src, typeOfSrc, context, someChange);
                List<NElementAnnotation> anns = this.convertAnn_objectToElement(p.annotations(), src, typeOfSrc, context, someChange);
                if (((Boolean)someChange.get()).booleanValue()) {
                    NPairElementBuilder obj2 = NElement.ofPairBuilder();
                    obj2.key(k);
                    obj2.value(v);
                    obj2.addAnnotations((List)anns);
                    obj2.addComments(p.comments());
                    return obj2.build();
                }
                return p;
            }
            case UPLET: 
            case NAMED_UPLET: {
                NUpletElement arr = src.asUplet().get();
                NBooleanRef someChange = NRef.ofBoolean(false);
                List<NElement> params = this.convertList_objectToElement(arr.params(), src, typeOfSrc, context, someChange);
                List<NElementAnnotation> anns = this.convertAnn_objectToElement(arr.annotations(), src, typeOfSrc, context, someChange);
                if (((Boolean)someChange.get()).booleanValue()) {
                    NUpletElementBuilder obj2 = NElement.ofUpletBuilder();
                    obj2.addAll(params.toArray(new NElement[0]));
                    obj2.name(arr.name().orNull());
                    obj2.addAnnotations((List)anns);
                    obj2.addComments(arr.comments());
                    return obj2.build();
                }
                return src;
            }
            case ARRAY: 
            case NAMED_PARAMETRIZED_ARRAY: 
            case NAMED_ARRAY: 
            case PARAMETRIZED_ARRAY: {
                NArrayElement arr = src.asArray().get();
                NBooleanRef someChange = NRef.ofBoolean(false);
                List<NElement> children = this.convertList_objectToElement(arr.children(), src, typeOfSrc, context, someChange);
                List<NElement> params = this.convertList_objectToElement(arr.params().orNull(), src, typeOfSrc, context, someChange);
                List<NElementAnnotation> anns = this.convertAnn_objectToElement(arr.annotations(), src, typeOfSrc, context, someChange);
                if (((Boolean)someChange.get()).booleanValue()) {
                    NArrayElementBuilder obj2 = NElement.ofArrayBuilder();
                    obj2.addAll(children.toArray(new NElement[0]));
                    if (params != null) {
                        obj2.addParams(params);
                    }
                    obj2.name(arr.name().orNull());
                    obj2.addAnnotations((List)anns);
                    obj2.addComments(arr.comments());
                    return obj2.build();
                }
                return src;
            }
            case OBJECT: 
            case PARAMETRIZED_OBJECT: 
            case NAMED_OBJECT: 
            case NAMED_PARAMETRIZED_OBJECT: {
                NObjectElement obj = src.asObject().get();
                NBooleanRef someChange = NRef.ofBoolean(false);
                List<NElement> children = this.convertList_objectToElement(obj.children(), src, typeOfSrc, context, someChange);
                List<NElement> params = this.convertList_objectToElement(obj.params().orNull(), src, typeOfSrc, context, someChange);
                List<NElementAnnotation> anns = this.convertAnn_objectToElement(obj.annotations(), src, typeOfSrc, context, someChange);
                if (((Boolean)someChange.get()).booleanValue()) {
                    NObjectElementBuilder obj2 = NElement.ofObjectBuilder();
                    obj2.addAll(children.toArray(new NElement[0]));
                    if (params != null) {
                        obj2.addParams(params);
                    }
                    obj2.name(obj.name().orNull());
                    obj2.addAnnotations((List)anns);
                    obj2.addComments(obj.comments());
                    return obj2.build();
                }
                return src;
            }
            case CUSTOM: {
                Object v1 = src.asCustom().get().value();
                if (context.isIndestructibleObject(v1)) {
                    return src;
                }
                return context.createElement(v1);
            }
        }
        return src;
    }

    private List<NElementAnnotation> convertAnn_objectToElement(List<NElementAnnotation> oldList, NElement src, Type typeOfSrc, NElementFactoryContext context, NBooleanRef someChange) {
        ArrayList<NElementAnnotation> newList = null;
        if (oldList != null) {
            newList = new ArrayList<NElementAnnotation>(oldList.size());
            boolean anyChange00 = false;
            for (NElementAnnotation e : oldList) {
                NBooleanRef someChange0 = NRef.ofBoolean(false);
                List<NElement> sub = this.convertList_objectToElement(e.params(), src, typeOfSrc, context, someChange0);
                if (((Boolean)someChange0.get()).booleanValue()) {
                    newList.add(NElement.ofAnnotation(e.name(), sub.toArray(new NElement[0])));
                    someChange.set(true);
                    anyChange00 = true;
                    continue;
                }
                newList.add(e);
            }
            if (anyChange00) {
                return newList;
            }
        }
        return oldList;
    }

    private NElement convertOne_objectToElement(NElement k, NElement src, Type typeOfSrc, NElementFactoryContext context, NBooleanRef someChange) {
        NElement k2 = context.createElement(k);
        if (k2 != k) {
            someChange.set();
            return k2;
        }
        return k;
    }

    private List<NElement> convertList_objectToElement(List<NElement> oldParams, NElement src, Type typeOfSrc, NElementFactoryContext context, NBooleanRef someChange) {
        ArrayList<NElement> newParams = null;
        if (oldParams != null) {
            newParams = new ArrayList<NElement>(oldParams.size());
            for (NElement e : oldParams) {
                boolean someChange0;
                NElement k2 = context.createElement(e);
                boolean bl = someChange0 = k2 != e;
                if (someChange0) {
                    someChange.set(true);
                    newParams.add(k2);
                    continue;
                }
                newParams.add(e);
            }
        }
        return newParams;
    }

    @Override
    public NElement createObject(NElement o, Type typeOfResult, NElementFactoryContext context) {
        return this.createElement(o, typeOfResult, context);
    }
}

