/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.runtime.standalone.elem.mapper;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import net.thevpc.nuts.elem.NElement;
import net.thevpc.nuts.elem.NElementAnnotation;
import net.thevpc.nuts.elem.NElementFactoryContext;
import net.thevpc.nuts.elem.NElementMapper;
import net.thevpc.nuts.elem.NPairElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNObjectElement;
import net.thevpc.nuts.runtime.standalone.elem.item.DefaultNPairElement;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NIllegalArgumentException;
import net.thevpc.nuts.util.NUnsupportedEnumException;

public class NElementMapperMap
implements NElementMapper<Map> {
    @Override
    public Object destruct(Map src, Type typeOfSrc, NElementFactoryContext context) {
        Map je = src;
        LinkedHashMap<Object, Object> m = new LinkedHashMap<Object, Object>();
        if (je != null) {
            Iterator iterator = je.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e0;
                Map.Entry e = e0 = iterator.next();
                Object k = context.destruct(e.getKey(), null);
                Object v = context.destruct(e.getValue(), null);
                m.put(k, v);
            }
        }
        return m;
    }

    @Override
    public NElement createElement(Map o, Type typeOfSrc, NElementFactoryContext context) {
        Map je = o;
        ArrayList<NElement> m = new ArrayList<NElement>();
        if (je != null) {
            Iterator iterator = je.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry e0;
                Map.Entry e = e0 = iterator.next();
                NElement k = context.createElement(e.getKey());
                if (!(e.getKey() instanceof NElement) && k.isString()) {
                    k = NElement.ofNameOrString(k.asStringValue().get());
                }
                NElement v = context.createElement(e.getValue());
                m.add(new DefaultNPairElement(k, v, new NElementAnnotation[0], null));
            }
        }
        return new DefaultNObjectElement(null, null, m, new NElementAnnotation[0], null);
    }

    public Map fillObject(NElement o, Map all, Type elemType1, Type elemType2, Type to, NElementFactoryContext context) {
        if (o.isAnyObject()) {
            for (NElement ee : o.asObject().get().children()) {
                NPairElement kv = (NPairElement)ee;
                NElement k = kv.key();
                NElement v = kv.value();
                all.put(context.createObject(k, elemType1), context.createObject(v, elemType2));
            }
        } else if (o.isAnyArray()) {
            for (NElement ee : o.asArray().get().children()) {
                NPairElement kv = (NPairElement)ee;
                NElement k = kv.key();
                NElement v = kv.value();
                all.put(context.createObject(k, elemType1), context.createObject(v, elemType2));
            }
        } else {
            throw new NUnsupportedEnumException(o.type());
        }
        return all;
    }

    @Override
    public Map createObject(NElement o, Type to, NElementFactoryContext context) {
        Class cls = Map.class;
        Type elemType1 = null;
        Type elemType2 = null;
        if (to instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)to;
            Type rawType = pt.getRawType();
            if (rawType instanceof Class) {
                cls = (Class)rawType;
            }
            elemType1 = pt.getActualTypeArguments()[0];
            elemType2 = pt.getActualTypeArguments()[1];
        }
        if (cls == null) {
            throw new NIllegalArgumentException(NMsg.ofPlain("class is null"));
        }
        switch (cls.getName()) {
            case "java.util.Map": 
            case "java.util.LinkedHashMap": {
                return this.fillObject(o, new LinkedHashMap(o.asObject().get().size()), elemType1, elemType2, to, context);
            }
            case "java.util.HashMap": {
                return this.fillObject(o, new HashMap(o.asObject().get().size()), elemType1, elemType2, to, context);
            }
            case "java.util.SortedMap": 
            case "java.util.NavigableMap": {
                return this.fillObject(o, new TreeMap(), elemType1, elemType2, to, context);
            }
        }
        return this.fillObject(o, (Map)context.getTypesRepository().getType(to).newInstance(), elemType1, elemType2, to, context);
    }
}

